/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.locale;

import java.util.Locale;

import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.Strings;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/04/21
 */
public class CurrentLocaleDetails extends Subr {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		ConsIterator itr = new ConsIterator(body);
		Datum c1a = Iterators.nextIf(itr);
		Locale l = Locale.getDefault();
		ConsListBuilder b;
		String s;

		SubrUtils.checkTerminated(itr, body, mesg);
		if(c1a == null) {
			b = new ConsListBuilder();
			if(!Strings.isEmpty(l.getVariant())) {
				b.append(new LispString(l.getVariant()));
			}
			return b.get();
		} else if(c1a.isNil()) {
			Locale.setDefault(
					new Locale(l.getLanguage(), l.getCountry()));
			return Undef.UNDEF;
		} else if(!(c1a instanceof Cons)) {
			throw mesg.getError("err.require.list", c1a);
		} else {
			s = SubrUtils.getSymbolName(
					SubrUtils.car(c1a, mesg), mesg);
			Locale.setDefault(
					new Locale(l.getLanguage(), l.getCountry(), s));
			return Undef.UNDEF;
		}
	}

}
