/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public abstract class RangeFactory<C extends Comparable<?>, I extends Range<C>> {
    RangeFactory() {
    }

    abstract I create(Cut<C> var1, Cut<C> var2);

    public I open(C lower, C upper) {
        return this.create(new Cut.AboveValue<C>(lower), new Cut.BelowValue<C>(upper));
    }

    public I closed(C lower, C upper) {
        return this.create(new Cut.BelowValue<C>(lower), new Cut.AboveValue<C>(upper));
    }

    public I closedOpen(C lower, C upper) {
        return this.create(new Cut.BelowValue<C>(lower), new Cut.BelowValue<C>(upper));
    }

    public I openClosed(C lower, C upper) {
        return this.create(new Cut.AboveValue<C>(lower), new Cut.AboveValue<C>(upper));
    }

    public I range(C lowerEndpoint, Range.BoundType lowerType, C upperEndpoint, Range.BoundType upperType) {
        Preconditions.checkNotNull(lowerType);
        Preconditions.checkNotNull(upperType);
        Cut lowerBound = lowerType == Range.BoundType.OPEN ? new Cut.AboveValue<C>(lowerEndpoint) : new Cut.BelowValue<C>(lowerEndpoint);
        Cut upperBound = upperType == Range.BoundType.OPEN ? new Cut.BelowValue<C>(upperEndpoint) : new Cut.AboveValue<C>(upperEndpoint);
        return this.create(lowerBound, upperBound);
    }

    public I lessThan(C endpoint) {
        return this.create(this.noLowerBound(), new Cut.BelowValue<C>(endpoint));
    }

    public I atMost(C endpoint) {
        return this.create(this.noLowerBound(), new Cut.AboveValue<C>(endpoint));
    }

    public I greaterThan(C endpoint) {
        return this.create(new Cut.AboveValue<C>(endpoint), this.noUpperBound());
    }

    public I atLeast(C endpoint) {
        return this.create(new Cut.BelowValue<C>(endpoint), this.noUpperBound());
    }

    public I all() {
        return this.create(this.noLowerBound(), this.noUpperBound());
    }

    private Cut<C> noLowerBound() {
        return Cut.BELOW_ALL;
    }

    private Cut<C> noUpperBound() {
        return Cut.ABOVE_ALL;
    }
}

