package jp.sourceforge.tamanegisoul.sa.widget;

import java.util.Calendar;
import java.util.Date;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TimePicker;

public class TimePreference extends DialogPreference {

    private TimePicker mTimePicker;
    private CheckBox mCheckBox;
    private Calendar mCalendar;

    public TimePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public TimePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public CharSequence getSummary() {
        if(PreferenceUtils.getString(getContext(), getKey()) == null){
            return "無効";
        }else{
            return PreferenceUtils.getString(getContext(), getKey());
        }
    }

    @Override
    protected View onCreateDialogView() {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View layout = inflater.inflate(R.layout.time_preference, null);
        mTimePicker = (TimePicker) layout.findViewById(R.id.time);
        // mTimePicker = new TimePicker(getContext());
        mTimePicker.setIs24HourView(android.text.format.DateFormat.is24HourFormat(getContext()));

        Date time = PreferenceUtils.getTime(getContext(), getKey());

        mCheckBox = (CheckBox) layout.findViewById(R.id.toggle_disabled);
        mCheckBox.setChecked(time == null);
        mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                mTimePicker.setEnabled(!isChecked);
            }
        });

        mTimePicker.setEnabled(time != null);
        if (time == null)
            time = new Date();
        mCalendar = Calendar.getInstance();
        mCalendar.setTime(time);

        mTimePicker.setCurrentHour(mCalendar.get(Calendar.HOUR_OF_DAY));
        mTimePicker.setCurrentMinute(mCalendar.get(Calendar.MINUTE));


        return layout;
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        LogUtil.d("TimePreference.onDialogClosed(%s)", positiveResult);
        if (positiveResult) {
            if (mCheckBox.isChecked()) {
                PreferenceUtils.setTime(getContext(), getKey(), null);
            } else {
                mCalendar.set(Calendar.HOUR_OF_DAY, mTimePicker.getCurrentHour());
                mCalendar.set(Calendar.MINUTE, mTimePicker.getCurrentMinute());
                PreferenceUtils.setTime(getContext(), getKey(), mCalendar.getTime());
            }
            setSummary(getSummary());
        }
        super.onDialogClosed(positiveResult);
    }

}
