package jp.sourceforge.tamanegisoul.sa;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;

/**
 * 休日設定画面
 * 起動時のIntentには、休日IDを受けとる。
 * これが設定されていれば休日更新、設定されていなければ新規休日作成。
 */
public class HolidayActivity extends Activity {

    private DBHelper mDbHelper;
    private Integer mHolidayId;

    private DatePicker mDatePicker;
    private EditText mNameText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // 初期化
        super.onCreate(savedInstanceState);
        setContentView(R.layout.holiday);
        mDbHelper = new DBHelper(this);
        initWidget();

        // Intentを取得(更新の場合はidを受け取る)
        Intent i = getIntent();
        mHolidayId = i.hasExtra(DBHelper.C_HOLIDAY_ID) ? i.getExtras().getInt(DBHelper.C_HOLIDAY_ID) : null;
        if (mHolidayId != null) {
            bindDataToView();
        }
    }

    private void initWidget() {
        // インスタンス変数に
        mDatePicker = (DatePicker) findViewById(R.id.datePicker);
        mNameText = (EditText) findViewById(R.id.name);
        // Buttonのリスナー登録
        ((Button) findViewById(R.id.setButton)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                saveHoliday();
                finish();
            }
        });
        ((Button) findViewById(R.id.removeButton)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                removeHoliday();
                finish();
            }
        });
    }

    /**
     * DBの内容をViewに反映する。
     */
    private void bindDataToView() {
        SQLiteDatabase db = mDbHelper.getReadableDatabase();
        Cursor c = db.query(DBHelper.T_HOLIDAY, null, DBHelper.C_HOLIDAY_ID + "=?", new String[] { mHolidayId.toString() }, null, null, null);
        c.moveToFirst();
        String date = c.getString(c.getColumnIndex(DBHelper.C_HOLIDAY_DATE));
        mDatePicker.init(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(5, 7)) - 1, Integer.parseInt(date.substring(8)),
                null);
        mNameText.setText(c.getString(c.getColumnIndex(DBHelper.C_HOLIDAY_NAME)));
        db.close();
    }

    /**
     * 現在の設定値をDBに保存する。
     */
    private void saveHoliday() {
        SQLiteDatabase db = mDbHelper.getWritableDatabase();
        ContentValues v = new ContentValues();
        v.put(DBHelper.C_HOLIDAY_NAME, mNameText.getText().toString());
        v.put(DBHelper.C_HOLIDAY_DATE, String.format("%d-%02d-%02d", mDatePicker.getYear(), mDatePicker.getMonth() + 1, mDatePicker.getDayOfMonth()));

        if (mHolidayId == null) {
            db.insert(DBHelper.T_HOLIDAY, null, v);
        } else {
            v.put(DBHelper.C_HOLIDAY_ID, mHolidayId);
            db.replace(DBHelper.T_HOLIDAY, null, v);
        }
        db.close();
    }

    /**
     * 現在の設定値を削除する。
     */
    private void removeHoliday() {
        if (mHolidayId != null) {
            SQLiteDatabase db = mDbHelper.getWritableDatabase();
            db.delete(DBHelper.T_HOLIDAY, DBHelper.C_HOLIDAY_ID + "=?", new String[] { String.valueOf(mHolidayId) });
            db.close();
        }
    }
}
