package jp.sourceforge.tamanegisoul.sa;

import android.app.KeyguardManager;
import android.app.KeyguardManager.KeyguardLock;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;

/**
 * アラーム起動時にAlarmManagerから呼び出されるレシーバー
 */
public class AlarmReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        // TODO 曜日と休日判定して鳴動要否を判断
        LogUtil.d("AlarmReceived. AlarmId->%s", intent.getExtras().getLong(DBHelper.C_ALARM_ID));
        // 画面スリープを解除
        PowerManager powerManager = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP
                | PowerManager.ON_AFTER_RELEASE, "ScheduleAlarm");
        wakeLock.acquire();
        // 画面ロックを解除
        KeyguardManager keyguardManager = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
        final KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("hoge");
        boolean isScreenLock = keyguardManager.inKeyguardRestrictedInputMode();
        LogUtil.d("ScreenLocked->%s", isScreenLock);
        if (isScreenLock) {
            keyguardLock.disableKeyguard();
            keyguardManager.exitKeyguardSecurely(new KeyguardManager.OnKeyguardExitResult() {
                @Override
                public void onKeyguardExitResult(boolean success) {
                    // TODO セキュリティロックの解除が上手くいかない…
                    LogUtil.d("KeyguardExitResult->%s", success);
                    keyguardLock.reenableKeyguard();
                }
            });
        }
        // アラーム鳴動画面を表示
        Intent i = new Intent(context, DoAlarmActivity.class);
        i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(i);
        // 画面ロックと画面スリープロックを開放
        if (isScreenLock)
            keyguardLock.reenableKeyguard();
        if (wakeLock.isHeld())
            wakeLock.release();
    }

}
