package jp.sourceforge.tamanegisoul.sa.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


import android.content.Context;
import android.content.SharedPreferences.Editor;
import android.net.Uri;
import android.preference.PreferenceManager;

/**
 * プリファレンスのユーティリティ
 */
public final class PreferenceUtils {
    
    public static final String KEY_WEEKDAY_TIME= "weekday_time";
    public static final String KEY_HOLIDAY_TIME= "holiday_time";
    public static final String KEY_ACCOUNT= "account";
    
    public static final void setTime(Context context, String key, Date time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context).edit();
        editor.putString(key, df.format(time));
        editor.commit();
    }
    
    public static final void setString(Context context, String key, String value) {
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context).edit();
        editor.putString(key, value);
        editor.commit();
    }
    
    public static final Calendar getTime(Context context, String key) {
        String timeStr = PreferenceManager.getDefaultSharedPreferences(context).getString(key, null);
        if (timeStr == null)
            return null;
        else {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(df.parse(timeStr));
                calendar.set(Calendar.SECOND, 0);
                return calendar;
            } catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final String getString(Context context, String key) {
        String value = PreferenceManager.getDefaultSharedPreferences(context).getString(key, null);
        LogUtil.d("Preference key->%s, value->%s", key, value);
        return value;
    }

    public static final Uri getRingtone(Context context) {
        String preference = PreferenceManager.getDefaultSharedPreferences(context).getString("ringtone", "");
        if (preference.equals("")) {
            return null;
        } else {
            return Uri.parse(preference);
        }
    }

    public static final long[] getVibratorPattern(Context context) {
        long[] pattern = null;
        String preference = PreferenceManager.getDefaultSharedPreferences(context).getString("vibrator", "");
        if (!preference.equals("")) {
            String[] patternStringArray = preference.split(",");
            pattern = new long[patternStringArray.length];
            for (int i = 0; i < patternStringArray.length; i++) {
                pattern[i] = Integer.parseInt(patternStringArray[i]);
            }
        }
        return pattern;
    }
}
