package jp.sourceforge.tamanegisoul.sa.action;

import java.util.Arrays;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.AppAccountManager;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import jp.sourceforge.tamanegisoul.sa.widget.GoogleCalQueryProgressDialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.preference.ListPreference;
import android.preference.RingtonePreference;

/**
 * 設定画面
 */
public class AppPreferenceActivity extends android.preference.PreferenceActivity implements OnSharedPreferenceChangeListener {

    private static final String KEY_VIBRATOR = "vibrator";
    private static final String KEY_RINGTONE = "ringtone";
    private static final String KEY_SNOOZE = "snooze";

    private Vibrator mVibrator;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mVibrator = (Vibrator) getSystemService("vibrator");
        addPreferencesFromResource(R.layout.preference);
    }

    @Override
    public void onResume() {
        super.onResume();

        // account
        AppAccountManager accountManager = new AppAccountManager(this);
        String[] accountStrings = accountManager.getAccountNames();
        ListPreference accountPreference = (ListPreference) findPreference("account");
        accountPreference.setEntries(accountStrings);
        accountPreference.setEntryValues(accountStrings);

        setPreferenceSummary();
        getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        setPreferenceSummary();
        // 設定したバイブレーターを一度鳴らす
        if (key.equals(KEY_VIBRATOR)) {
            long[] pattern = PreferenceUtils.getVibratorPattern(this);
            if (pattern != null)
                mVibrator.vibrate(pattern[1]);
        } else if (key.equals(PreferenceUtils.KEY_HOLIDAY_TIME) || key.equals(PreferenceUtils.KEY_WEEKDAY_TIME)) {
            AppAlarmManager.getInstance(this).resetAlarm(false);
        } else if (key.equals(PreferenceUtils.KEY_ACCOUNT)) {
            GoogleCalQueryProgressDialog d = new GoogleCalQueryProgressDialog(this);
            d.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    if (!((GoogleCalQueryProgressDialog) dialog).isCanceled()) {
                        AppAlarmManager.getInstance(AppPreferenceActivity.this).resetAlarm(false);
                    }
                }
            });
            d.show();
        }
    }

    /**
     * ビューに設定値を表示する。
     */
    private void setPreferenceSummary() {
        SharedPreferences sharedPreferences = getPreferenceScreen().getSharedPreferences();
        // アカウント
        ((ListPreference) findPreference("account")).setSummary(sharedPreferences.getString("account", "未設定"));
        // 着信音
        String ringtoneValue = sharedPreferences.getString(KEY_RINGTONE, "");
        RingtonePreference ringtonePreference = (RingtonePreference) findPreference(KEY_RINGTONE);
        if (ringtoneValue.equals("")) {
            ringtonePreference.setSummary("サイレント");
        } else {
            Uri uri = Uri.parse(ringtoneValue);
            Ringtone ringtone = RingtoneManager.getRingtone(this, uri);
            ringtonePreference.setSummary(ringtone.getTitle(this));
        }
        // バイブレーター
        String vibratorValue = sharedPreferences.getString(KEY_VIBRATOR, "");
        ListPreference vibratorListPreference = (ListPreference) findPreference(KEY_VIBRATOR);
        if (vibratorValue.equals("")) {
            vibratorListPreference.setSummary("なし");
        } else {
            String[] values = getResources().getStringArray(R.array.array_vibrator_value);
            int index = Arrays.binarySearch(values, vibratorValue);
            vibratorListPreference.setSummary(getResources().getStringArray(R.array.array_vibrator)[index]);
        }
        // スヌーズ
        String snoozeValue = sharedPreferences.getString(KEY_SNOOZE, "");
        ListPreference snoozeListPreference = (ListPreference) findPreference(KEY_SNOOZE);
        if (snoozeValue.equals("")) {
            snoozeListPreference.setSummary("なし");
        } else {
            String[] values = getResources().getStringArray(R.array.array_snooze_value);
            int index = Math.abs(Arrays.binarySearch(values, snoozeValue));
            LogUtil.d("%s,%s,%s", snoozeValue, values[2], index);
            snoozeListPreference.setSummary(getResources().getStringArray(R.array.array_snooze)[index]);
        }
    }
}