package jp.sourceforge.tamanegisoul.sa.action;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.AppAccountManager;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.DBHelper;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import android.accounts.Account;
import android.content.ContentResolver;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;
import android.preference.RingtonePreference;

/**
 * 設定画面
 */
public class AppPreferenceActivity extends PreferenceActivity implements OnSharedPreferenceChangeListener {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.preference);
        addPreferencesFromResource(R.layout.preference_screen);
    }

    @Override
    public void onResume() {
        super.onResume();

        // アカウント
        String[] accountStrings = AppAccountManager.getInstance(this).getAccountNames();
        ListPreference accountPreference = (ListPreference) findPreference("account");
        accountPreference.setEntries(accountStrings);
        accountPreference.setEntryValues(accountStrings);

        setPreferenceSummary();
        getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        setPreferenceSummary();
        if (key.equals(PreferenceUtils.KEY_VIBRATOR)) {
            // 設定したバイブレーターを一度鳴らす
            long[] pattern = PreferenceUtils.getVibratorPattern(this);
            if (pattern != null)
                ((Vibrator) getSystemService("vibrator")).vibrate(pattern[1]);
        } else if (key.equals(PreferenceUtils.KEY_HOLIDAY_TIME) || key.equals(PreferenceUtils.KEY_WEEKDAY_TIME) || key.equals(PreferenceUtils.KEY_HOLIDAY_OF_WEEK)) {
            // アラームを再設定
            AppAlarmManager.getInstance(this).refreshAlarm();
        } else if (key.equals(PreferenceUtils.KEY_ACCOUNT)) {
            // カレンダーと同期
            Account account = AppAccountManager.getInstance(this).getAccount();
            if (account != null)
                ContentResolver.requestSync(account, DBHelper.URI_CALENDAR.getAuthority(), new Bundle());
        }
    }

    /**
     * ビューに設定値を表示する。
     */
    private void setPreferenceSummary() {
        SharedPreferences sharedPreferences = getPreferenceScreen().getSharedPreferences();
        // アカウント
        ((ListPreference) findPreference("account")).setSummary(sharedPreferences.getString("account", "未設定"));
        // 着信音
        String ringtoneValue = sharedPreferences.getString(PreferenceUtils.KEY_RINGTONE, "");
        RingtonePreference ringtonePreference = (RingtonePreference) findPreference(PreferenceUtils.KEY_RINGTONE);
        if (ringtoneValue.equals("")) {
            ringtonePreference.setSummary("サイレント");
        } else {
            Uri uri = Uri.parse(ringtoneValue);
            Ringtone ringtone = RingtoneManager.getRingtone(this, uri);
            ringtonePreference.setSummary(ringtone.getTitle(this));
        }
        // バイブレーター
        String vibratorValue = sharedPreferences.getString(PreferenceUtils.KEY_VIBRATOR, "");
        ListPreference vibratorListPreference = (ListPreference) findPreference(PreferenceUtils.KEY_VIBRATOR);
        if (vibratorValue.equals("")) {
            vibratorListPreference.setSummary("なし");
        } else {
            String[] values = getResources().getStringArray(R.array.array_vibrator_value);
            for (int i = 0; i < values.length; i++) {
                if (values[i].equals(vibratorValue)) {
                    vibratorListPreference.setSummary(getResources().getStringArray(R.array.array_vibrator)[i]);
                    break;
                }
            }
        }
        // スヌーズ
        String snoozeValue = sharedPreferences.getString(PreferenceUtils.KEY_SNOOZE_INTERVAL, "");
        ListPreference snoozeListPreference = (ListPreference) findPreference(PreferenceUtils.KEY_SNOOZE_INTERVAL);
        if (snoozeValue.equals("")) {
            snoozeListPreference.setSummary("なし");
        } else {
            String[] values = getResources().getStringArray(R.array.array_snooze_value);
            // Arrays.binarySearchで上手くいかないので…
            for (int i = 0; i < values.length; i++) {
                if (values[i].equals(snoozeValue)) {
                    LogUtil.d("%s,%s,%s", snoozeValue, values[i], i);
                    snoozeListPreference.setSummary(getResources().getStringArray(R.array.array_snooze)[i]);
                }
            }
        }
        // 最大鳴動時間
        String maxAlarmTimeValue = sharedPreferences.getString(PreferenceUtils.KEY_MAX_ALARM_TIME, "");
        ListPreference maxAlarmTimeListPreference = (ListPreference) findPreference(PreferenceUtils.KEY_MAX_ALARM_TIME);
        if (maxAlarmTimeValue.equals("")) {
            maxAlarmTimeListPreference.setSummary("永久");
        } else {
            String[] values = getResources().getStringArray(R.array.array_max_alarm_time_value);
            // Arrays.binarySearchで上手くいかないので…
            for (int i = 0; i < values.length; i++) {
                if (values[i].equals(maxAlarmTimeValue)) {
                    LogUtil.d("%s,%s,%s", maxAlarmTimeValue, values[i], i);
                    maxAlarmTimeListPreference.setSummary(getResources().getStringArray(R.array.array_max_alarm_time)[i]);
                }
            }
        }
    }
}