/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.storage.speckle.jdbc.internal.DataTypeConverter;
import com.google.storage.speckle.jdbc.internal.DataTypeConverters;
import com.google.storage.speckle.jdbc.internal.Util;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JdbcType {
    JDBC_TYPE_BIT(-7, Byte.class),
    JDBC_TYPE_TINYINT(-6, Short.class),
    JDBC_TYPE_SMALLINT(5, Integer.class),
    JDBC_TYPE_INTEGER(4, Integer.class),
    JDBC_TYPE_BIGINT(-5, Long.class),
    JDBC_TYPE_FLOAT(6, Float.class),
    JDBC_TYPE_REAL(7, Float.class),
    JDBC_TYPE_DOUBLE(8, Double.class),
    JDBC_TYPE_NUMERIC(2, BigDecimal.class),
    JDBC_TYPE_DECIMAL(3, BigDecimal.class),
    JDBC_TYPE_CHAR(1, String.class),
    JDBC_TYPE_VARCHAR(12, String.class),
    JDBC_TYPE_LONGVARCHAR(-1, String.class),
    JDBC_TYPE_DATE(91, Date.class),
    JDBC_TYPE_TIME(92, Time.class),
    JDBC_TYPE_TIMESTAMP(93, Timestamp.class),
    JDBC_TYPE_BINARY(-2, byte[].class),
    JDBC_TYPE_VARBINARY(-3, byte[].class),
    JDBC_TYPE_LONGVARBINARY(-4, byte[].class),
    JDBC_TYPE_NULL(0, Object.class),
    JDBC_TYPE_OTHER(1111, Object.class),
    JDBC_TYPE_JAVA_OBJECT(2000, Object.class),
    JDBC_TYPE_DISTINCT(2001, Object.class),
    JDBC_TYPE_STRUCT(2002, Struct.class),
    JDBC_TYPE_ARRAY(2003, Array.class),
    JDBC_TYPE_BLOB(2004, Blob.class),
    JDBC_TYPE_CLOB(2005, Clob.class),
    JDBC_TYPE_REF(2006, Ref.class),
    JDBC_TYPE_DATALINK(70, Object.class),
    JDBC_TYPE_BOOLEAN(16, Boolean.class),
    JDBC_TYPE_ROWID(-8, RowId.class),
    JDBC_TYPE_NCHAR(-15, String.class),
    JDBC_TYPE_NVARCHAR(-9, String.class),
    JDBC_TYPE_LONGNVARCHAR(-16, String.class),
    JDBC_TYPE_NCLOB(2011, NClob.class),
    JDBC_TYPE_SQLXML(2009, SQLXML.class);

    private static final Map<Integer, JdbcType> JDBC_TYPE_MAP;
    private final int jdbcType;
    private final Class<?> columnClass;

    private JdbcType(int jdbcType, Class<?> columnClass) {
        this.jdbcType = jdbcType;
        this.columnClass = columnClass;
    }

    public int getCode() {
        return this.jdbcType;
    }

    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    public DataTypeConverter<?> getConverter() {
        return DataTypeConverters.getConverter(this.getColumnClass());
    }

    public static JdbcType fromCode(int id) {
        JdbcType d = JDBC_TYPE_MAP.get(id);
        if (d != null) {
            return d;
        }
        throw new IllegalArgumentException("jdbc type " + id + " not found");
    }

    static {
        HashMap<Integer, JdbcType> jdbcBuilder = Util.newHashMap();
        for (JdbcType d : EnumSet.allOf(JdbcType.class)) {
            jdbcBuilder.put(d.getCode(), d);
        }
        JDBC_TYPE_MAP = Collections.unmodifiableMap(jdbcBuilder);
    }
}

