/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Key;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query
implements Serializable {
    public static final String KIND_METADATA_KIND = "__kind__";
    public static final String PROPERTY_METADATA_KIND = "__property__";
    public static final String NAMESPACE_METADATA_KIND = "__namespace__";
    static final long serialVersionUID = 7090652715949085374L;
    private final String kind;
    private final List<SortPredicate> sortPredicates;
    private final List<FilterPredicate> filterPredicates;
    private Key ancestor;
    private boolean keysOnly;
    private AppIdNamespace appIdNamespace;
    private transient String fullTextSearch;

    public Query() {
        this((String)null);
    }

    public Query(String kind) {
        this(kind, null, new ArrayList<SortPredicate>(), new ArrayList<FilterPredicate>(), false, DatastoreApiHelper.getCurrentAppIdNamespace(), null);
    }

    Query(String kind, Key ancestor, List<SortPredicate> sortPreds, List<FilterPredicate> filterPreds, boolean keysOnly, AppIdNamespace appIdNamespace, String fullTextSearch) {
        this.kind = kind;
        this.ancestor = ancestor;
        this.sortPredicates = sortPreds;
        this.filterPredicates = filterPreds;
        this.keysOnly = keysOnly;
        this.appIdNamespace = appIdNamespace;
        this.fullTextSearch = fullTextSearch;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.appIdNamespace == null) {
            this.appIdNamespace = this.ancestor != null ? this.ancestor.getAppIdNamespace() : new AppIdNamespace(DatastoreApiHelper.getCurrentAppId(), "");
        }
    }

    public Query(Key ancestor) {
        this((String)null);
        if (ancestor != null) {
            this.setAncestor(ancestor);
        }
    }

    public Query(String kind, Key ancestor) {
        this(kind);
        if (ancestor != null) {
            this.setAncestor(ancestor);
        }
    }

    public String getKind() {
        return this.kind;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace;
    }

    public Key getAncestor() {
        return this.ancestor;
    }

    public Query setAncestor(Key ancestor) {
        if (ancestor != null && !ancestor.isComplete()) {
            throw new IllegalArgumentException(ancestor + " is incomplete.");
        }
        if (ancestor == null && this.ancestor == null) {
            throw new IllegalArgumentException("Cannot clear ancestor unless ancestor has already been set");
        }
        if (ancestor != null && !ancestor.getAppIdNamespace().equals(this.appIdNamespace)) {
            throw new IllegalArgumentException("Namespace of ancestor key and query must match.");
        }
        this.ancestor = ancestor;
        return this;
    }

    public Query addFilter(String propertyName, FilterOperator operator, Object value) {
        this.filterPredicates.add(new FilterPredicate(propertyName, operator, value));
        return this;
    }

    public List<FilterPredicate> getFilterPredicates() {
        return Collections.unmodifiableList(this.filterPredicates);
    }

    public Query addSort(String propertyName) {
        return this.addSort(propertyName, SortDirection.ASCENDING);
    }

    public Query addSort(String propertyName, SortDirection direction) {
        this.sortPredicates.add(new SortPredicate(propertyName, direction));
        return this;
    }

    public List<SortPredicate> getSortPredicates() {
        return Collections.unmodifiableList(this.sortPredicates);
    }

    public Query setKeysOnly() {
        this.keysOnly = true;
        return this;
    }

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    String getFullTextSearch() {
        return this.fullTextSearch;
    }

    Query setFullTextSearch(String fullTextSearch) {
        this.fullTextSearch = fullTextSearch;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.keysOnly != query.keysOnly) {
            return false;
        }
        if (this.ancestor != null ? !this.ancestor.equals(query.ancestor) : query.ancestor != null) {
            return false;
        }
        if (!this.appIdNamespace.equals(query.appIdNamespace)) {
            return false;
        }
        if (!((Object)this.filterPredicates).equals(query.filterPredicates)) {
            return false;
        }
        if (!this.kind.equals(query.kind)) {
            return false;
        }
        if (!((Object)this.sortPredicates).equals(query.sortPredicates)) {
            return false;
        }
        return !(this.fullTextSearch != null ? !this.fullTextSearch.equals(query.fullTextSearch) : query.fullTextSearch != null);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + ((Object)this.sortPredicates).hashCode();
        result = 31 * result + ((Object)this.filterPredicates).hashCode();
        result = 31 * result + (this.ancestor != null ? this.ancestor.hashCode() : 0);
        result = 31 * result + (this.keysOnly ? 1 : 0);
        result = 31 * result + this.appIdNamespace.hashCode();
        result = 31 * result + (this.fullTextSearch != null ? this.fullTextSearch.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SELECT " + (this.keysOnly ? "__key__" : "*"));
        if (this.kind != null) {
            result.append(" FROM ");
            result.append(this.kind);
        }
        if (this.ancestor != null || !this.filterPredicates.isEmpty()) {
            result.append(" WHERE ");
        }
        String AND_SEPARATOR = " AND ";
        for (FilterPredicate filter : this.filterPredicates) {
            result.append(filter);
            result.append(" AND ");
        }
        if (this.ancestor != null) {
            result.append("__ancestor__ is ");
            result.append(this.ancestor);
        } else if (!this.filterPredicates.isEmpty()) {
            result.delete(result.length() - " AND ".length(), result.length());
        }
        String COMMA_SEPARATOR = ", ";
        if (!this.sortPredicates.isEmpty()) {
            result.append(" ORDER BY ");
            for (SortPredicate sort : this.sortPredicates) {
                result.append(sort);
                result.append(", ");
            }
            result.delete(result.length() - ", ".length(), result.length());
        }
        return result.toString();
    }

    public static final class FilterPredicate
    implements Serializable {
        static final long serialVersionUID = 7681475799401864259L;
        private final String propertyName;
        private final FilterOperator operator;
        private final Object value;

        public FilterPredicate(String propertyName, FilterOperator operator, Object value) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (operator == null) {
                throw new NullPointerException("Operator was null");
            }
            if (operator == FilterOperator.IN) {
                if (!(value instanceof Collection) && value instanceof Iterable) {
                    ArrayList newValue = new ArrayList();
                    for (Object val : (Iterable)value) {
                        newValue.add(val);
                    }
                    value = newValue;
                }
                DataTypeUtils.checkSupportedValue(propertyName, value, true, true);
            } else {
                DataTypeUtils.checkSupportedValue(propertyName, value, false, false);
            }
            this.propertyName = propertyName;
            this.operator = operator;
            this.value = value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public FilterOperator getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPredicate that = (FilterPredicate)o;
            if (this.operator != that.operator) {
                return false;
            }
            if (!this.propertyName.equals(that.propertyName)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + this.operator.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.propertyName + " " + this.operator.toString() + " " + (this.value != null ? this.value.toString() : "NULL");
        }
    }

    public static final class SortPredicate
    implements Serializable {
        static final long serialVersionUID = -623786024456258081L;
        private final String propertyName;
        private final SortDirection direction;

        public SortPredicate(String propertyName, SortDirection direction) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (direction == null) {
                throw new NullPointerException("Direction was null");
            }
            this.propertyName = propertyName;
            this.direction = direction;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public SortDirection getDirection() {
            return this.direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortPredicate that = (SortPredicate)o;
            if (this.direction != that.direction) {
                return false;
            }
            return this.propertyName.equals(that.propertyName);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }

        public String toString() {
            return this.propertyName + (this.direction == SortDirection.DESCENDING ? " DESC" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterOperator {
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        EQUAL("="),
        NOT_EQUAL("!="),
        IN("IN");

        private final String shortName;

        private FilterOperator(String shortName) {
            this.shortName = shortName;
        }

        public String toString() {
            return this.shortName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

