/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class SpeckleRpcOptions {
    private Long queryTimeOutMillis;
    private Long connectTimeOutMillis;
    private boolean includeExportedKeys;
    private int[] generatedColumnIndices;
    private String[] generatedColumnNames;
    private int fetchSize;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 2;
    public static final long DEFAULT_QUERY_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);

    public final SpeckleRpcOptions setQueryTimeOutMillis(long millis) {
        this.queryTimeOutMillis = millis;
        return this;
    }

    public long getQueryTimeOutMillis() {
        return this.queryTimeOutMillis != null ? this.queryTimeOutMillis : DEFAULT_QUERY_TIMEOUT_MILLIS;
    }

    public void clearQueryTimeOutMillis() {
        this.queryTimeOutMillis = null;
    }

    public final SpeckleRpcOptions setConnectTimeOutMillis(long millis) {
        this.connectTimeOutMillis = millis;
        return this;
    }

    public long getConnectTimeOutMillis() {
        return this.connectTimeOutMillis != null ? this.connectTimeOutMillis : DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    public void clearConnectTimeOutMillis() {
        this.connectTimeOutMillis = null;
    }

    public SpeckleRpcOptions setIncludeExportedKeys(boolean includeExportedKeys) {
        this.includeExportedKeys = includeExportedKeys;
        return this;
    }

    public boolean getIncludeExportedKeys() {
        return this.includeExportedKeys;
    }

    public SpeckleRpcOptions setGeneratedColumnIndices(int ... generatedColumnIndices) {
        this.generatedColumnIndices = generatedColumnIndices;
        return this;
    }

    public int[] getGeneratedColumnIndices() {
        return this.generatedColumnIndices;
    }

    public SpeckleRpcOptions setGeneratedColumnNames(String ... generatedColumnNames) {
        this.generatedColumnNames = generatedColumnNames;
        return this;
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumnNames;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public static SpeckleRpcOptions defaultOptions() {
        return new SpeckleRpcOptions();
    }

    public static SpeckleRpcOptions defaultOptions(SpeckleUrl url) {
        Integer queryTimeoutSeconds;
        SpeckleRpcOptions options = SpeckleRpcOptions.defaultOptions();
        Integer connectTimeOutSeconds = url.getConnectTimeoutSeconds();
        if (connectTimeOutSeconds != null) {
            options.setConnectTimeOutMillis(TimeUnit.SECONDS.toMillis(connectTimeOutSeconds.intValue()));
        }
        if ((queryTimeoutSeconds = url.getQueryTimeoutSeconds()) != null) {
            options.setQueryTimeOutMillis(TimeUnit.SECONDS.toMillis(queryTimeoutSeconds.intValue()));
        }
        return options;
    }

    public int hashCode() {
        return this.queryTimeOutMillis != null ? this.queryTimeOutMillis.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpeckleRpcOptions)) {
            return false;
        }
        SpeckleRpcOptions that = (SpeckleRpcOptions)o;
        return SpeckleRpcOptions.equal(this.queryTimeOutMillis, that.queryTimeOutMillis) && this.includeExportedKeys == that.includeExportedKeys && Arrays.equals(this.generatedColumnIndices, that.generatedColumnIndices) && Arrays.equals(this.generatedColumnNames, that.generatedColumnNames) && this.fetchSize == that.fetchSize && this.resultSetType == that.resultSetType && this.resultSetConcurrency == that.resultSetConcurrency && this.resultSetHoldability == that.resultSetHoldability;
    }

    private static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public String toString() {
        return "SpeckleRpcOptions " + "{connectTimeOutMillis = " + this.connectTimeOutMillis + "}" + "{queryTimeOutMillis = " + this.queryTimeOutMillis + "}" + "{includeExportedKeys = " + this.includeExportedKeys + "}" + "{generatedColumnIndices = " + Arrays.toString(this.generatedColumnIndices) + "}" + "{generatedColumnNames = " + Arrays.toString(this.generatedColumnNames) + "}" + "{fetchSize = " + this.fetchSize + "}" + "{resultSetType = " + this.resultSetType + "}" + "{resultSetConcurrency = " + this.resultSetConcurrency + "}" + "{resultSetHoldability = " + this.resultSetHoldability + "}";
    }
}

