/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.ExecResponse;
import com.google.storage.speckle.jdbc.SpeckleConnection;
import com.google.storage.speckle.jdbc.SpeckleResultSet;
import com.google.storage.speckle.jdbc.SpeckleStreamingResultSet;
import com.google.storage.speckle.jdbc.internal.ConnectionOperationHelper;
import com.google.storage.speckle.jdbc.internal.DataTypeConverters;
import com.google.storage.speckle.jdbc.internal.Exceptions;
import com.google.storage.speckle.jdbc.internal.SimpleListResultSet;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.SpeckleWrapper;
import com.google.storage.speckle.jdbc.internal.Util;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeckleStatement
extends SpeckleWrapper
implements Statement {
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final SpeckleConnection conn;
    private final SpeckleRpcOptions rpcOptions;
    private final SpeckleUrl url;
    private SpeckleResultSet rs;
    private ExecResponse response;
    private SQLWarning warnings;
    private long rowsUpdated = -1L;
    private int queryTimeoutSeconds = 0;
    protected boolean open = true;
    private List<BigDecimal> generatedKeys;
    private Long statementId;

    SpeckleStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, SpeckleConnection conn, SpeckleUrl url) {
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.conn = conn;
        this.url = url;
        this.rpcOptions = SpeckleRpcOptions.defaultOptions(url);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfNotOpen();
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            if (this.statementId != null) {
                this.conn.executeOp(SpeckleRpcOptions.defaultOptions(this.url), ConnectionOperationHelper.closeStatement(this.statementId));
            }
        }
        finally {
            this.clearState();
            this.open = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeImpl(sql);
    }

    protected boolean executeImpl(String sql) throws SQLException {
        this.throwIfNotOpen();
        this.clearState();
        this.response = this.executeSqlImpl(this.rpcOptions, sql);
        if (this.response.hasResult()) {
            Client.ResultProto result = this.response.getResult();
            this.warnings = SpeckleStatement.createSqlWarnings(result.getWarningsList());
            this.generatedKeys = SpeckleStatement.getGeneratedKeysAsBigDecimal(result);
            if (result.hasStatementId()) {
                this.statementId = result.getStatementId();
            }
            if (result.hasRows()) {
                Client.RowSetProto rsp = result.getRows();
                this.rs = this.statementId != null ? new SpeckleStreamingResultSet(this, result, this.warnings, this.conn.getCatalog(), this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : new SpeckleResultSet(this, rsp.getTuplesList(), rsp.getColumnsList(), this.warnings, this.conn.getCatalog(), this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
                return true;
            }
            this.rowsUpdated = result.getRowsUpdated();
        }
        return false;
    }

    private static List<BigDecimal> getGeneratedKeysAsBigDecimal(Client.ResultProto result) throws SQLException {
        ArrayList<BigDecimal> generatedKeys = Util.newArrayList();
        for (ByteString keyString : result.getGeneratedKeysList()) {
            if (keyString.size() <= 0) continue;
            generatedKeys.add(DataTypeConverters.getConverter(BigDecimal.class).toObject(keyString));
        }
        return generatedKeys;
    }

    static SQLWarning createSqlWarnings(List<Client.SqlException> warningsList) {
        if (warningsList.size() == 0) {
            return null;
        }
        SQLWarning firstWarning = null;
        SQLWarning lastWarning = null;
        for (Client.SqlException w : warningsList) {
            SQLWarning current = new SQLWarning(w.getMessage(), w.getSqlState(), w.getCode());
            if (firstWarning == null) {
                firstWarning = current;
            }
            if (lastWarning != null) {
                lastWarning.setNextWarning(current);
            }
            lastWarning = current;
        }
        return firstWarning;
    }

    protected ExecResponse executeSqlImpl(SpeckleRpcOptions options, String sql) throws SQLException {
        this.throwIfNotOpen();
        return this.conn.executeSql(options, sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return this.executeImpl(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setIncludeExportedKeys(true);
        this.setGeneratedColumnIndices(columnIndexes);
        return this.executeImpl(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setIncludeExportedKeys(true);
        this.setGeneratedColumnNames(columnNames);
        return this.executeImpl(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SpeckleResultSet executeQuery(String sql) throws SQLException {
        this.throwIfNotOpen();
        if (!this.executeImpl(sql)) {
            throw Exceptions.newStatementExecuteQueryNullResultSetException();
        }
        return this.rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateImpl(sql);
    }

    private int executeUpdateImpl(String sql) throws SQLException {
        this.throwIfNotOpen();
        if (this.executeImpl(sql)) {
            throw Exceptions.newStatementExecuteUpdateWithResultSetException();
        }
        return (int)this.rowsUpdated;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setIncludeExportedKeys(true);
        this.setGeneratedColumnIndices(columnIndexes);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setIncludeExportedKeys(true);
        this.setGeneratedColumnNames(columnNames);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public SpeckleConnection getConnection() throws SQLException {
        this.throwIfNotOpen();
        return this.conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.throwIfNotOpen();
        ArrayList<String> keys = Util.newArrayList();
        for (BigDecimal key : this.generatedKeys) {
            keys.add(key.toPlainString());
        }
        return SimpleListResultSet.oneColumnResultSet(keys, "GENERATED_KEY");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwIfNotOpen();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.throwIfNotOpen();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.throwIfNotOpen();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwIfNotOpen();
        return this.queryTimeoutSeconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwIfNotOpen();
        return this.rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwIfNotOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwIfNotOpen();
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwIfNotOpen();
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.throwIfNotOpen();
        int lastRowsUpdated = (int)this.rowsUpdated;
        this.rowsUpdated = -1L;
        return lastRowsUpdated;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfNotOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwIfNotOpen();
        if (seconds < 0) {
            throw Exceptions.newSqlException("Seconds must be >= 0.");
        }
        if (seconds == 0) {
            this.rpcOptions.clearQueryTimeOutMillis();
        } else {
            this.rpcOptions.setQueryTimeOutMillis(TimeUnit.SECONDS.toMillis(seconds));
        }
        this.queryTimeoutSeconds = seconds;
    }

    void setIncludeExportedKeys(boolean includeExportedKeys) {
        this.rpcOptions.setIncludeExportedKeys(includeExportedKeys);
    }

    void setGeneratedColumnIndices(int ... generatedColumnIndices) {
        this.rpcOptions.setGeneratedColumnIndices(generatedColumnIndices);
    }

    void setGeneratedColumnNames(String ... generatedColumnNames) {
        this.rpcOptions.setGeneratedColumnNames(generatedColumnNames);
    }

    protected void throwIfNotOpen() throws SQLException {
        if (!this.open) {
            throw Exceptions.newStatementClosedException();
        }
    }

    ExecResponse executeNext() throws SQLException {
        return this.conn.executeNext(this.rpcOptions, this.statementId);
    }

    void setWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    private void clearState() {
        this.response = null;
        this.rs = null;
        this.warnings = null;
        this.rowsUpdated = -1L;
        this.generatedKeys = null;
        this.statementId = null;
    }
}

