/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.images.Image;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

final class ImageImpl
implements Image {
    static final long serialVersionUID = -7970719108027515279L;
    private byte[] imageData;
    private int width;
    private int height;
    private Image.Format format;
    private BlobKey blobKey;
    private static final int EOI_MARKER = 217;
    private static final int RST_MARKER_START = 208;
    private static final int RST_MARKER_END = 215;
    private static final int TEM_MARKER = 1;
    private static final int HUFFMAN_TABLE_MARKER = 196;
    private static final int ARITHMETIC_CODING_CONDITIONING_MARKER = 204;

    ImageImpl(byte[] imageData) {
        this.setImageData(imageData);
    }

    ImageImpl(BlobKey blobKey) {
        this.width = -1;
        this.height = -1;
        this.blobKey = blobKey;
    }

    public int getWidth() {
        if (this.width < 0) {
            this.updateDimensions();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height < 0) {
            this.updateDimensions();
        }
        return this.height;
    }

    public Image.Format getFormat() {
        if (this.format == null) {
            this.updateDimensions();
        }
        return this.format;
    }

    public byte[] getImageData() {
        return this.imageData != null ? (byte[])this.imageData.clone() : null;
    }

    public void setImageData(byte[] imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("imageData must not be null");
        }
        if (imageData.length == 0) {
            throw new IllegalArgumentException("imageData must not be empty");
        }
        this.imageData = (byte[])imageData.clone();
        this.width = -1;
        this.height = -1;
        this.format = null;
        this.blobKey = null;
    }

    public BlobKey getBlobKey() {
        return this.blobKey;
    }

    public boolean equals(Object o) {
        if (o instanceof Image) {
            Image other = (Image)o;
            BlobKey otherBlobKey = other.getBlobKey();
            if (this.blobKey != null || otherBlobKey != null) {
                return this.blobKey == null ? otherBlobKey == null : this.blobKey.equals(otherBlobKey);
            }
            return Arrays.equals(this.imageData, other.getImageData());
        }
        return false;
    }

    public int hashCode() {
        if (this.blobKey != null) {
            return this.blobKey.hashCode();
        }
        return Arrays.hashCode(this.imageData);
    }

    private void updateDimensions() {
        if (this.imageData == null) {
            throw new UnsupportedOperationException("No image data is available.");
        }
        if (this.imageData.length < 8) {
            throw new IllegalArgumentException("imageData must be a valid image");
        }
        if (this.imageData[0] == 71 && this.imageData[1] == 73 && this.imageData[2] == 70) {
            this.updateGifDimensions();
            this.format = Image.Format.GIF;
        } else if (this.imageData[0] == -119 && this.imageData[1] == 80 && this.imageData[2] == 78 && this.imageData[3] == 71 && this.imageData[4] == 13 && this.imageData[5] == 10 && this.imageData[6] == 26 && this.imageData[7] == 10) {
            this.updatePngDimensions();
            this.format = Image.Format.PNG;
        } else if (this.imageData[0] == -1 && this.imageData[1] == -40) {
            this.updateJpegDimensions();
            this.format = Image.Format.JPEG;
        } else if (this.imageData[0] == 73 && this.imageData[1] == 73 && this.imageData[2] == 42 && this.imageData[3] == 0 || this.imageData[0] == 77 && this.imageData[1] == 77 && this.imageData[2] == 0 && this.imageData[3] == 42) {
            this.updateTiffDimensions();
            this.format = Image.Format.TIFF;
        } else if (this.imageData[0] == 66 && this.imageData[1] == 77) {
            this.updateBmpDimensions();
            this.format = Image.Format.BMP;
        } else if (this.imageData[0] == 0 && this.imageData[1] == 0 && this.imageData[2] == 1 && this.imageData[3] == 0) {
            this.updateIcoDimensions();
            this.format = Image.Format.ICO;
        } else {
            throw new IllegalArgumentException("imageData must be a valid image");
        }
    }

    private void updateGifDimensions() {
        if (this.imageData.length < 10) {
            throw new IllegalArgumentException("corrupt GIF format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.getChar(6) & 0xFFFF;
        this.height = buffer.getChar(8) & 0xFFFF;
    }

    private void updatePngDimensions() {
        if (this.imageData.length < 24) {
            throw new IllegalArgumentException("corrupt PNG format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.width = buffer.getInt(16);
        this.height = buffer.getInt(20);
    }

    private void updateJpegDimensions() {
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (ImageImpl.extend(buffer.get()) != 255 || ImageImpl.extend(buffer.get()) != 216) {
            throw new IllegalArgumentException("corrupt JPEG format: Expected SOI marker");
        }
        try {
            while (true) {
                int code;
                if ((code = ImageImpl.extend(buffer.get())) != 255) {
                    continue;
                }
                while (code == 255) {
                    code = ImageImpl.extend(buffer.get());
                }
                if (ImageImpl.isFrameMarker(code)) {
                    buffer.position(buffer.position() + 3);
                    this.height = ImageImpl.extend(buffer.getShort());
                    this.width = ImageImpl.extend(buffer.getShort());
                    return;
                }
                if (code == 217) {
                    throw new IllegalArgumentException("corrupt JPEG format: No frame sgements found.");
                }
                if (code >= 208 && code <= 215 || code == 1) continue;
                int length = ImageImpl.extend(buffer.getShort(buffer.position()));
                buffer.position(buffer.position() + length);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("corrupt JPEG format");
        }
        catch (BufferUnderflowException ex) {
            throw new IllegalArgumentException("corrupt JPEG format");
        }
    }

    private static boolean isFrameMarker(int code) {
        return (code & 0xF0) == 192 && code != 196 && code != 204;
    }

    private static int extend(byte b) {
        return b & 0xFF;
    }

    private static int extend(short s) {
        return s & 0xFFFF;
    }

    private void updateTiffDimensions() {
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        if (this.imageData[0] == 73) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int offset = buffer.getInt(4);
        int ifdSize = buffer.getChar(offset) & 0xFFFF;
        offset += 2;
        for (int i = 0; i < ifdSize && offset + 12 <= this.imageData.length; ++i) {
            int tag = buffer.getChar(offset) & 0xFFFF;
            if (tag == 256 || tag == 257) {
                int type = buffer.getChar(offset + 2) & 0xFFFF;
                int result = type == 3 ? buffer.getChar(offset + 8) & 0xFFFF : (type == 4 ? buffer.getInt(offset + 8) : this.imageData[offset + 8]);
                if (tag == 256) {
                    this.width = result;
                    if (this.height != -1) {
                        return;
                    }
                } else {
                    this.height = result;
                    if (this.width != -1) {
                        return;
                    }
                }
            }
            offset += 12;
        }
        if (this.width == -1 || this.height == -1) {
            throw new IllegalArgumentException("corrupt tiff format");
        }
    }

    private void updateBmpDimensions() {
        if (this.imageData.length < 18) {
            throw new IllegalArgumentException("corrupt BMP format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.get(6) & 0xFF;
        this.height = buffer.get(7) & 0xFF;
        int headerLength = buffer.getInt(14);
        if (headerLength == 12 && this.imageData.length >= 22) {
            this.width = buffer.getChar(18) & 0xFFFF;
            this.height = buffer.getChar(20) & 0xFFFF;
        } else if ((headerLength == 40 || headerLength == 108 || headerLength == 124 || headerLength == 64) && this.imageData.length >= 26) {
            this.width = buffer.getInt(18);
            this.height = buffer.getInt(22);
        } else {
            throw new IllegalArgumentException("corrupt BMP format");
        }
    }

    private void updateIcoDimensions() {
        if (this.imageData.length < 8) {
            throw new IllegalArgumentException("corrupt ICO format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.get(6) & 0xFF;
        this.height = buffer.get(7) & 0xFF;
        if (this.width == 0) {
            this.width = 256;
        }
        if (this.height == 0) {
            this.height = 256;
        }
    }
}

