package jp.sourceforge.tamanegisoul.sa;

import android.content.Context;
import android.net.Uri;
import android.preference.PreferenceManager;

/**
 * プリファレンスのユーティリティ
 */
public final class PreferenceUtils {

    public static final Uri getRingtone(Context context) {
        String preference = PreferenceManager.getDefaultSharedPreferences(context).getString("ringtone", "");
        if (preference.equals("")) {
            return null;
        } else {
            return Uri.parse(preference);
        }
    }

    public static final long[] getVibratorPattern(Context context) {
        long[] pattern = null;
        String preference = PreferenceManager.getDefaultSharedPreferences(context).getString("vibrator", "");
        if (!preference.equals("")) {
            String[] patternStringArray = preference.split(",");
            pattern = new long[patternStringArray.length];
            for (int i = 0; i < patternStringArray.length; i++) {
                pattern[i] = Integer.parseInt(patternStringArray[i]);
            }
        }
        return pattern;
    }
}
