/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.LiteralByteString;
import java.util.NoSuchElementException;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] bytes, int offset, int length) {
        super(bytes);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset too small: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length too small: " + offset);
        }
        if ((long)offset + (long)length > (long)bytes.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + offset + "+" + length);
        }
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    public byte byteAt(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + index);
        }
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + index + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + index];
    }

    public int size() {
        return this.bytesLength;
    }

    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

