/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.QueryRuntime;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.CachedQuery;
import org.datanucleus.store.query.cache.QueryCache;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class QueryManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManager.class.getClassLoader());
    OMFContext omfCtx;
    QueryCache cache = null;
    Map<String, Collection> queryMethodEvaluatorMap = new HashMap<String, Collection>();
    QueryRuntime queryRuntime = null;

    public QueryManager(OMFContext omfContext) {
        this.omfCtx = omfContext;
        if (omfContext.getJMXManager() != null) {
            ManagementManager mgmtMgr = omfContext.getJMXManager();
            ManagementServer mgntServer = omfContext.getJMXManager().getManagementServer();
            this.queryRuntime = new QueryRuntime();
            String mbeanName = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.queryRuntime.getClass()) + ",Name=QueryRuntime";
            mgntServer.registerMBean(this.queryRuntime, mbeanName);
        }
        this.initialiseQueryCache();
    }

    protected void initialiseQueryCache() {
        PersistenceConfiguration conf = this.omfCtx.getPersistenceConfiguration();
        String queryCacheType = conf.getStringProperty("datanucleus.cache.query.type");
        if (queryCacheType != null && !queryCacheType.equalsIgnoreCase("none")) {
            String queryCacheClassName = this.omfCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query", "name", queryCacheType, "class-name");
            if (queryCacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)queryCacheType)).setFatal();
            }
            try {
                Class<?> level2CacheClass = Class.forName(queryCacheClassName);
                Class[] ctrArgsClasses = new Class[]{OMFContext.class};
                Object[] ctrArgs = new Object[]{this.omfCtx};
                Constructor<?> ctr = level2CacheClass.getConstructor(ctrArgsClasses);
                this.cache = (QueryCache)ctr.newInstance(ctrArgs);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)queryCacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)queryCacheType, (Object)queryCacheClassName), e).setFatal();
            }
        }
    }

    public void close() {
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
        this.queryMethodEvaluatorMap.clear();
        this.queryMethodEvaluatorMap = null;
        this.queryRuntime = null;
    }

    public QueryRuntime getQueryRuntime() {
        return this.queryRuntime;
    }

    public Query newQuery(String language, ObjectManager om, Object query) {
        String impl;
        if (language == null) {
            return null;
        }
        String languageImpl = language;
        if (language.equalsIgnoreCase("JDOQL")) {
            impl = this.omfCtx.getPersistenceConfiguration().getStringProperty("datanucleus.query.JDOQL.implementation");
            if (impl != null) {
                languageImpl = impl;
            }
        } else if (language.equalsIgnoreCase("JPQL") && (impl = this.omfCtx.getPersistenceConfiguration().getStringProperty("datanucleus.query.JPQL.implementation")) != null) {
            languageImpl = impl;
        }
        try {
            if (query == null) {
                Class[] argsClass = new Class[]{ObjectManager.class};
                Object[] args = new Object[]{om};
                Query q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
                return q;
            }
            Query q = null;
            if (query instanceof String) {
                Class[] argsClass = new Class[]{ObjectManager.class, String.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else if (query instanceof Query) {
                Class[] argsClass = new Class[]{ObjectManager.class, query.getClass()};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else {
                Class[] argsClass = new Class[]{ObjectManager.class, Object.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            }
            return q;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(t.getMessage(), t).setFatal();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), e).setFatal();
        }
    }

    public synchronized void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.cache != null) {
            String queryKey = language + ":" + query;
            CachedQuery cachedQuery = new CachedQuery(compilation);
            this.cache.put(queryKey, cachedQuery);
        }
    }

    public synchronized QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        CachedQuery cachedQuery;
        if (this.cache != null && (cachedQuery = this.cache.get(queryKey = language + ":" + query)) != null) {
            return cachedQuery.getCompilation();
        }
        return null;
    }

    public synchronized void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        String queryKey;
        CachedQuery cachedQuery;
        if (this.cache != null && (cachedQuery = this.cache.get(queryKey = language + ":" + query)) != null) {
            cachedQuery.addDatastoreCompilation(datastore, compilation);
        }
    }

    public synchronized Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        CachedQuery cachedQuery;
        if (this.cache != null && (cachedQuery = this.cache.get(queryKey = language + ":" + query)) != null) {
            return cachedQuery.getDatastoreCompilation(datastore);
        }
        return null;
    }

    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Collection methods = this.queryMethodEvaluatorMap.get(methodName);
        if (methods != null) {
            for (InvocationEvaluator eval : methods) {
                if (!eval.supportsType(type)) continue;
                return eval;
            }
        } else {
            String[] evaluatorNames = this.omfCtx.getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_methods", "name", methodName, "memory-evaluator");
            if (evaluatorNames != null) {
                HashSet<InvocationEvaluator> evaluators = new HashSet<InvocationEvaluator>();
                InvocationEvaluator evalToUse = null;
                for (int i = 0; i < evaluatorNames.length; ++i) {
                    try {
                        Class evalCls = this.omfCtx.getClassLoaderResolver(null).classForName(evaluatorNames[i]);
                        InvocationEvaluator eval = (InvocationEvaluator)evalCls.newInstance();
                        evaluators.add(eval);
                        if (!eval.supportsType(type)) continue;
                        evalToUse = eval;
                        continue;
                    }
                    catch (Exception e) {
                        NucleusLogger.QUERY.warn("Extension org.datanucleus.store_query_methods has method=" + methodName + " referencing evaluator " + evaluatorNames[i] + " but an error occurred in construction : " + e.getMessage());
                    }
                }
                this.queryMethodEvaluatorMap.put(methodName, evaluators);
                return evalToUse;
            }
        }
        return null;
    }
}

