using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class MoveToRecycle : Action {
		public override string DisplayString {
			get { return "S~ɓ"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView activeView = ViewInterfaces.LastFocusedFileView;

				if (activeView.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				List<IFilerItem> selectedItems = activeView.SelectedFilerItems;

				DeleteJob job = new DeleteJob(selectedItems, true);
				if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
					JobManager.Instance.AddJob(job);
				} else {
					job.Execute();

					activeView.UpdateView();
					activeView.SelectMode = SelectMode.Normal;
				}
			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
