using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class MoveToAnotherFileView : Action {
		public override string DisplayString {
			get { return "ACe𔽑΂̃r[Ɉړ"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView activeView = ViewInterfaces.LastFocusedFileView;
				IFileView inactiveView = ViewInterfaces.OtherOfLastFocusedFileView;

				if (activeView.CurrentPath == "" || inactiveView.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				List<IFilerItem> list = activeView.SelectedFilerItems;
				string destFolder = inactiveView.CurrentPath;

				MoveJob job;
				try {
					job = new MoveJob(new Folder(destFolder), list);
				} catch (InvalidPreConditionJobException ex) {
					SCFiler2System.ShowDialogMessage(ex.Message);
					return;
				}

				if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
					JobManager.Instance.AddJob(job);
				} else {
					JobManager.Instance.ExecuteJobNow(job);
					activeView.UpdateView();
					activeView.SelectMode = SelectMode.Normal;
					inactiveView.UpdateView();
					inactiveView.SelectMode = SelectMode.Normal;
					inactiveView.ViewMode = ViewMode.Normal;
				}
			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
