using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.ViewInterface {
	class ViewInterfacesImpl : IViewInterfaces {
		private static ViewInterfacesImpl instance = new ViewInterfacesImpl();
		public static ViewInterfacesImpl Instance {
			get { return instance; }
		}

		private ViewInterfacesImpl() {
		}

		#region IViewInterfaces o

		public void CheckUpdateAllView() {
			ViewInterfaces.CheckUpdateAllView();
		}

		public IItemView CurrentItemView {
			get {
				return ViewInterfaces.CurrentItemView;
			}
		}

		public IFileView LastFocusedFileView {
			get { 
				return ViewInterfaces.LastFocusedFileView;
			}
		}

		public IFileView LeftFileView {
			get {
				return ViewInterfaces.LeftFileView;
			}
		}

		public IFileView OtherOfLastFocusedFileView {
			get {
				return ViewInterfaces.OtherOfLastFocusedFileView;
			}
		}

		public IFileView RightFileView {
			get {
				return ViewInterfaces.RightFileView;
			}
		}

		public void PrintInMessageArea(string message) {
			SCFiler2System.ShowHistoryMessage(message);
		}

		public void PrintInStatusbar(string message) {
			SCFiler2System.ShowTempMessage(message);
		}

		public void ShowDialogbox(string message) {
			SCFiler2System.ShowDialogMessage(message);
		}

		public List<IHistoryView> HistoryViews {
			get {
				return ViewInterfaces.HistoryViews;
			}
		}

		#endregion
	}
}
