using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class ThumbnailMode : Action {
		public override string DisplayString {
			get { return "TlC\"; }
		}

		public override ActionType Type {
			get { return ActionType.View; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView view = ViewInterfaces.LastFocusedFileView;
			if (view.CurrentPath == "") {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
				return;
			}

			if (view.ViewMode != ViewMode.ThumbnailMode) {
				view.ViewMode = ViewMode.ThumbnailMode;
			} else {
				//łɃTlC\猳ɖ߂
				view.ViewMode = ViewMode.Normal;
			}
		}
	}
}
