using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.CommonDialog;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	class RepeatOverwriteState {
		enum RepeatSate {
			Normal,
			OverwriteEvery,
			NotOverwriteEvery,
		}
		RepeatSate state = RepeatSate.Normal;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <returns>폜Ȃtrue/ȂȂfalse</returns>
		public bool IsOverwrite(IFilerItem destination, IFilerItem source) {
			switch (state) {
				case RepeatSate.Normal:
					IsOverwriteDialog dialog = new IsOverwriteDialog(destination, source);
					dialog.TopMost = true;
					IsOverwriteDialog.DialogResult result = dialog.ShowDialog();
					switch (result) {
						case IsOverwriteDialog.DialogResult.Yes:
							return true;
						case IsOverwriteDialog.DialogResult.No:
							return false;
						case IsOverwriteDialog.DialogResult.AllYes:
							this.state = RepeatSate.OverwriteEvery;
							return true;
						case IsOverwriteDialog.DialogResult.AllNo:
							this.state = RepeatSate.NotOverwriteEvery;
							return false;
					}
					break;
				case RepeatSate.OverwriteEvery:
					return true;
				case RepeatSate.NotOverwriteEvery:
					return false;
			}
			return false;

		}

	}

}
