﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

//２重起動防止用（Diagnostics,InteropServices）
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace SCFiler2 {
	static class Program {
		/// <summary>
		/// このアプリケーションのウィンドウ名
		/// コンパイラ？により自動でつけられるので、Spy++などで調べる
		/// ビルドによって替わるかもしれないので注意
		/// </summary>
		const string windowClassName = @"WindowsForms10.Window.8.app.0.33c0d9d";
		/// <summary>
		/// このアプリケーションが一つしか立ち上がらないようにするためのmutex
		/// </summary>
		const string mutexName = @"MutexSCFiler2";

		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main() {
			System.Threading.Mutex mutex = new System.Threading.Mutex(false, mutexName);

			//すでにSCFiler2のプロセスがあったらそれを表示。なかったら起動
			if (mutex.WaitOne(0, false)) { //初回
				Application.EnableVisualStyles();
				Application.SetCompatibleTextRenderingDefault(false);
				MainForm form = new MainForm();
				Application.Run(form);
			} else { //すでに起動済み
				if (!ShowPrevProcess()) {
					MessageBox.Show("ウィンドウを前面に出すのを失敗しました");
				}
			}
			mutex.Close();
		}

		#region ２重起動防止ロジック
		[DllImport("USER32.DLL", CharSet = CharSet.Auto)]
		private static extern int ShowWindow(
			System.IntPtr hWnd,
			int nCmdShow
		);

		[DllImport("USER32.DLL", CharSet = CharSet.Auto)]
		private static extern bool SetForegroundWindow(
			System.IntPtr hWnd
		);

		private const int SW_NORMAL = 1;//使っていない
		private const int SW_RESTORE = 9;//画面を元の大きさに戻す
		public static bool ShowPrevProcess() {
			IntPtr hWnd = FindWindow(windowClassName, null);
			IntPtr fore = GetForegroundWindow();

			if (hWnd != IntPtr.Zero) {
				int foregroundID = GetWindowThreadProcessId(GetForegroundWindow(), IntPtr.Zero);
				int scfilerID = GetWindowThreadProcessId(hWnd, IntPtr.Zero);
				
				if (IsIconic(hWnd)) {
					ShowWindow(hWnd, SW_RESTORE);
				}
				Microsoft.VisualBasic.Interaction.AppActivate("SCFiler2");
				//以前はSetForegroundWindow(hWnd);のみ記述していたが、XPの場合AppActivateの方が切り替えに成功しやすい				

				//AttachThreadInput(scfilerID, foregroundID, true);
				//SetForegroundWindow(hWnd);
				//BringWindowToTop(hWnd);
				//AttachThreadInput(scfilerID, foregroundID, false);
				return true;
			} else {
				return false;
			}
		}

		[DllImport("user32.dll")]
		private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

		[DllImport("user32.dll")]
		private static extern bool IsIconic(IntPtr hWnd);

		[DllImport("user32.dll")]
		private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

		[DllImport("user32.dll")]
		private static extern int GetWindowThreadProcessId(IntPtr hWnd, IntPtr ProcessId);

		[DllImport("user32.dll")]
		private static extern IntPtr GetForegroundWindow();

		[DllImport("user32.dll")]
		extern static bool AttachThreadInput(int idAttach, int idAttachTo, bool fAttach);

		[DllImport("user32.dll", SetLastError = true)]
		static extern bool BringWindowToTop(IntPtr hWnd);
		#endregion
	}
}