using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// WusȂǂ̐i󋵂ʃXbh\̃_CAO
	/// MainFormShowDialog()Ń_CAO\ԂŕʃXbhĂяoƂɎgp
	/// EDialogoɁAʃXbh̓o^ς݂̃X^[g\bhN邱Ƃł
	/// EʃXbh當󂯎_CAOɕ\邱Ƃł
	/// ELZ\
	/// </summary>
	public partial class OperationProcessDialog : Form {
		private Thread processThread;

		public delegate void OperationProcessDelegate();
		public delegate void CancelProcessDelegate();
		public delegate void CloseDialogDelegate();

		public OperationProcessDelegate operationProcessMethod;
		public CancelProcessDelegate cancelProcessMethod;
		public CloseDialogDelegate closeDialogMethod;

		public OperationProcessDialog() {
			InitializeComponent();
			this.messageLabel.Text = "";
			this.setMessageDelegate = new SetMessageDelegate(SetMessage);
			this.closeDialogMethod = new CloseDialogDelegate(CloseDialog);
		}

		private delegate void SetMessageDelegate(string message);
		private SetMessageDelegate setMessageDelegate;

		/// <summary>
		/// _CAO̕\̕XV
		/// </summary>
		/// <param name="message">\镶</param>
		public void SetMessage(string message) {
			if (this.InvokeRequired) {
				this.Invoke(this.setMessageDelegate, new object[] { message });
			} else {
				this.messageLabel.Text = message;
				this.Update();
			}
		}

		/// <summary>
		/// _CAO
		/// </summary>
		public void CloseDialog() {
			if (this.InvokeRequired) {
				this.Invoke(this.closeDialogMethod);
			} else {
				this.Close();
			}
		}

		/// <summary>
		/// _CAOɓo^Ă郁\bhJn
		/// </summary>
		private void StartProcess() {
			operationProcessMethod();
			this.CloseDialog();
		}

		/// <summary>
		/// _CAO\Aw肵\bhVXbhŊJn
		/// </summary>
		/// <param name="operationMethod">_CAO\ƂɁAVvZXŋNĂق\bh</param>
		/// <param name="cancelMethod">_CAOʂăLZvƂɌĂяoĂق\bh</param>
		/// <returns>JnXbh</returns>
		public Thread ShowDialogAndStartProcess(OperationProcessDelegate operationMethod, CancelProcessDelegate cancelMethod) {
		    this.operationProcessMethod = operationMethod;
		    this.cancelProcessMethod = cancelMethod;

		    if (operationProcessMethod != null) {
		        processThread = new Thread(new ThreadStart(StartProcess));
		        processThread.Start();
		    }
			MainForm.Instance.AddOwnedForm(this);
		    this.Show();
			return processThread;
		}

		private void cancelButton_Click(object sender, EventArgs e) {
			if (cancelProcessMethod != null) {
				cancelProcessMethod();
			}
		}
	}
}