using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Operation;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class NarrowDownFileViewItem : Action {
		public override string DisplayString {
			get { return "i荞"; }
		}

		public override ActionType Type {
			get { return ActionType.View; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView view = ViewInterfaces.LastFocusedFileView;
			view.SwitchNarrowDownMode();
		}
	}
}
