using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	class MoveToDriveRoot : Action {
		public override string DisplayString {
			get { return "hCũ[gɈړ"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;

				//hCuꗗ\słȂ
				if (view.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(view.CurrentPath);
				view.ChangePath(info.Root.ToString());
				view.SelectMode = SelectMode.Normal;
			} else {
				//Ȃ
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}
}
