using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCFiler2.CommonDialog {
	public partial class Messagebox : Form {
		new public enum DialogResult {
			Yes,
			No
		}
		private DialogResult result = DialogResult.No;
		public DialogResult Result {
			get { return result; }
		}


		public string Title {
			set { base.Text = value; }
			get { return base.Text; }
		}

		public Messagebox() {
			InitializeComponent();
		}

		static public DialogResult Show(string text) {	
			Messagebox box = new Messagebox();
			box.MessageLabel.Text = text;
			box.ShowDialog();
			return box.Result;
		}

		static public DialogResult Show(string title, string text) {
			Messagebox box = new Messagebox();
			box.MessageLabel.Text = text;
			box.Text = title;
			box.ShowDialog();
			return box.Result;
		}

		private void YesButton_Click(object sender, EventArgs e) {
			this.result = DialogResult.Yes;
			this.Close();
		}

		private void NoButton_Click(object sender, EventArgs e) {
			this.result = DialogResult.No;
			this.Close();
		}
	}
}