using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Util;
using SCFiler2.Operation;
using SCFiler2.PluginInterface;

namespace SCFiler2 {
	/// <summary>
	/// ͂ꂽL[Action̊֌WǗBVOgB
	/// </summary>
	internal class KeyCommandManager {
		static KeyCommandManager instance = new KeyCommandManager();
		private System.Collections.Hashtable validKeys = new System.Collections.Hashtable();
			
		/// <summary>
		/// KeyCommandManager̃CX^XBiVOgj
		/// </summary>
		static internal KeyCommandManager Instance {
			get { return instance; }
		}

		private KeyCommandManager() {
			RegistValidKeys();
		}

		/// <summary>
		/// L[R}hƁAANV̊֘AÂێNX
		/// </summary>
		private class Command {
			public string commandString;
			public ActionManager.ActionID actionID;
			public Command(ActionManager.ActionID action, string command) {
				this.actionID = action;
				this.commandString = command;
			}
		}
		private List<Command> commandList = new List<Command>();

		private class Plugin {
			internal string commandString;
			internal Client plugin;
			internal Plugin(Client plugin, string command) {
				this.plugin = plugin;
				this.commandString = command;
			}
		}
		private List<Plugin> pluginList = new List<Plugin>();

		/// <summary>
		/// L[R}h蓖ĂĂAction擾
		/// </summary>
		/// <param name="keyCommand">ΏۃL[R}h</param>
		/// <returns>łɎgpĂA蓖ĂĂActionBgĂȂnull</returns>
		internal Action GetAssignedAction(string keyCommand) {
			foreach (Command com in commandList) {
				if (com.commandString == keyCommand) {
					return ActionManager.CreateAction(com.actionID);
				}
			}
			return null;
		}

		/// <summary>
		/// L[R}h蓖ĂĂvOC擾
		/// </summary>
		/// <param name="keyCommand">ΏۃL[R}h</param>
		/// <returns>keyCommandɊ蓖ĂĂvOCiClientjBgĂȂnull</returns>
		internal Client GetAssignedPlugin(string keyCommand) {
			foreach (Plugin plugin in pluginList) {
				if (plugin.commandString == keyCommand) {
					return plugin.plugin;
				}
			}
			return null;
		}

		/// <summary>
		/// L[R}hłɓo^Ă邩ǂmF
		/// </summary>
		/// <param name="keyCommand">ΏۃL[R}h</param>
		/// <returns>łɓo^ς݂łtrue</returns>
		internal bool IsUsed(string keyCommand) {
			foreach (Command com in commandList) {
				if (com.commandString == keyCommand) {
					return true;
				}
			}
			foreach (Plugin plugin in pluginList) {
				if (plugin.commandString == keyCommand) {
					return true;
				}
			}
			return false;
		}

		/// <summary>
		/// ActionɊ蓖ĂĂL[R}hɑΉ镶擾
		/// </summary>
		/// <param name="action">ׂΏۂActionID</param>
		/// <returns>Ή镶Bo^ĂȂ""Ԃ</returns>
		internal string GetAssignedKeyCommand(ActionManager.ActionID actionID) {
			foreach (Command com in commandList) {
				if (com.actionID == actionID) {
					return com.commandString;
				}
			}
			return "";
		}

		internal string GetAssignedKeyCommand(Client plugin) {
			foreach (Plugin p in pluginList) {
				if (p.plugin.Name == plugin.Name) {
					return p.commandString;
				}
			}
			return "";
		}

		/// <summary>
		/// ANVɃL[蓖ĂBłɃANVɃL[蓖ĂĂƂ͏㏑
		/// </summary>
		/// <param name="actionID">蓖đΏۂActionɑΉID</param>
		/// <param name="keyCommand">ActionɊ蓖ĂL[</param>
		internal void RegistAction(ActionManager.ActionID actionID, string keyCommand) {
			foreach (Command com in commandList) {
				//ANVɂ鎞́Akey㏑
				if (com.actionID == actionID) {
					com.commandString = keyCommand;
					return;
				}
			}
			Command newCommand = new Command(actionID, keyCommand);
			commandList.Add(newCommand);
		}

		/// <summary>
		/// vOCɃL[蓖ĂBłɃL[蓖ĂĂƂ͏㏑
		/// </summary>
		/// <param name="plugin">蓖đΏۂ̃vOC</param>
		/// <param name="keyCommand">vOCɊ蓖ĂL[</param>
		internal void RegistPlugin(Client plugin, string keyCommand) {
			foreach (Plugin p in pluginList) {
				if (p.plugin.Name == plugin.Name) {
					p.commandString = keyCommand;
					return;
				}
			}
			Plugin tmp = new Plugin(plugin, keyCommand);
			pluginList.Add(tmp);
		}

		/// <summary>
		/// L[蓖čς݂̃ANVAL[蓖Ă
		/// </summary>
		/// <param name="action">L[蓖ĂΏۂ̃ANVID</param>
		public void ReleaseAssignedKey(ActionManager.ActionID actionID) {
			foreach (Command com in this.commandList) {
				if (com.actionID == actionID) {
					commandList.Remove(com);
					break;
				}
			}
		}

		/// <summary>
		/// L[蓖čς݂̃vOCAL[蓖Ă
		/// </summary>
		/// <param name="plugin">L[蓖ĂΏۂ̃vOC</param>
		public void ReleaseAssignedKey(Client plugin) {
			foreach (Plugin p in pluginList) {
				if (p.plugin.Name == plugin.Name) {
					pluginList.Remove(p);
					break;
				}
			}
		}

		/// <summary>
		/// L[蓖Đݒǂݍ
		/// </summary>
		public void Load() {
			SettingFile file = SettingFile.Instance;

			foreach (ActionManager.ActionID id in Enum.GetValues(typeof(ActionManager.ActionID))) {
				Action action = ActionManager.CreateAction(id);
				string str = file.Load("KeyAssign", action.DisplayString);
				if (str != "") {
					RegistAction(id, str);
				}
			}

			string[] pluginList = file.Load("PluginKeyAssign", "PluginList").Split(new char[] {','});
			foreach (Client plugin in SCFiler2.Plugin.PluginManager.Instance.Plugins) {
				string str = file.Load("PluginKeyAssign", plugin.Name);
				if (str != "") {
					RegistPlugin(plugin, str);
				}
			}

			//o^ς݂̃vOCXgƎۂɌoꂽvOCrāAȂȂĂL[o^͍폜
			//TODÔƂPluginListSave()XVȂA肪ȂƎv̂Ƃ肠ۗ
			foreach (string str in pluginList) {
				bool found = false;
				foreach (Client plugin in SCFiler2.Plugin.PluginManager.Instance.Plugins) {
					if (plugin.Name == str) {
						found = true;
					}
				}
				if (!found) {
					//ȂnullĐݒt@C폜
					file.Save("PluginkeyAssign", str, null);
				}
			}
		}

		/// <summary>
		/// L[蓖Đݒۑ
		/// </summary>
		public void Save() {
			SettingFile file = SettingFile.Instance;

			foreach (ActionManager.ActionID id in Enum.GetValues(typeof(ActionManager.ActionID))) {
				string str = GetAssignedKeyCommand(id);
				Action action = ActionManager.CreateAction(id);
				if (str == "") {
					file.Save("KeyAssign", action.DisplayString, null); //null̓t@C폜
				} else {
					file.Save("KeyAssign", action.DisplayString, str);
				}
			}

			string pluginList = "";
			foreach (Client plugin in SCFiler2.Plugin.PluginManager.Instance.Plugins) {
				string str = GetAssignedKeyCommand(plugin);
				if (str == "") {
					file.Save("PluginKeyAssign", plugin.Name, null);
				} else {
					file.Save("PluginKeyAssign", plugin.Name, str);
				}
				pluginList = pluginList + plugin.Name + ',';
			}
			if (pluginList.Length > 1) {
				//Ō̃J}Ƃ
				pluginList.Remove(pluginList.Length - 1, 1);
			}
			file.Save("PluginKeyAssign", "PluginList", pluginList);
		}

		/// <summary>
		/// R}ho^\ǂ𒲂ׂ
		/// </summary>
		/// <param name="control"></param>
		/// <param name="alt"></param>
		/// <param name="shift"></param>
		/// <param name="key"></param>
		/// <returns>o^\ȃL[trueԂ</returns>
		public bool IsValidCommand(bool control, bool alt, bool shift, Keys key) {
			if (validKeys.Contains(key)) {
				return true;
			} else {
				return false;
			}
		}


		/// <summary>
		/// L[ꂽƂActions
		/// </summary>
		/// <param name="control">ControlĂ邩ǂ</param>
		/// <param name="alt">AltĂ邩ǂ</param>
		/// <param name="shift">shiftĂ邩ǂ</param>
		/// <param name="key">ꂽL[</param>
		/// <returns>strue, L[ɑΉActionȂĎsłȂfalseԂ</returns>
		internal bool ExecuteAction(bool control, bool alt, bool shift, Keys key) {
			string str = GetCommandString(control, alt, shift, key);
			if (str == "") {
				return false;
			}
			Action action = GetAssignedAction(str);
			if (action == null) {
				return false;
			}
			action.Execute();
			return true;
		}

		/// <summary>
		/// L[ꂽƂɃvOCs
		/// </summary>
		/// <param name="control"></param>
		/// <param name="alt"></param>
		/// <param name="shift"></param>
		/// <param name="key"></param>
		/// <returns>strue, L[ɑΉvOCȂĎsłȂfalseԂ</returns>
		internal bool ExecutePlugin(bool control, bool alt, bool shift, Keys key) {
			string str = GetCommandString(control, alt, shift, key);
			if (str == "") {
				return false;
			}
			Client plugin = GetAssignedPlugin(str);
			if (plugin == null) {
				return false;
			}
			plugin.Execute();
			return true;
		}
		
		/// <summary>
		/// ꂽL[Ή镶ɕϊ
		/// </summary>
		/// <param name="control">ControlĂ邩ǂ</param>
		/// <param name="alt">AltĂ邩ǂ</param>
		/// <param name="shift">shiftĂ邩ǂ</param>
		/// <param name="key">ꂽL[</param>
		/// <returns>L[ɑΉ镶BLł͂Ȃꍇ""Ԃ</returns>
		internal string GetCommandString(bool control, bool alt, bool shift, Keys key) {
			if (!validKeys.Contains(key)) {
				return "";
			}
			string commandStr = "";
			if (control) {
				commandStr += "Ctrl-";
			}
			if (alt) {
				commandStr += "Alt-";
			}
			if (shift) {
				commandStr += "Shift-";
			}
			commandStr += validKeys[key];
			return commandStr;
		}


		#region LL[o^ƑΉ̒`
		/// <summary>
		/// LȃL[̓o^ƁAɑΉ镶`BiToStringƂ˂ɂłȂƂ̂Łj
		/// </summary>
		private void RegistValidKeys() {
		    validKeys.Add(Keys.Enter, "Enter");
		    validKeys.Add(Keys.Escape, "Escape");
		    validKeys.Add(Keys.Space, "Space");
			validKeys.Add(Keys.Back, "Back");
		    validKeys.Add(Keys.Delete, "Del");
		    validKeys.Add(Keys.Oem5, "\\");
		    validKeys.Add(Keys.Left,"Left");
		    validKeys.Add(Keys.Right,"Right");
			validKeys.Add(Keys.Up, "Up");
			validKeys.Add(Keys.Down, "Down");
			validKeys.Add(Keys.PageUp, "PageUp");
			validKeys.Add(Keys.PageDown, "PageDown");
			validKeys.Add(Keys.Home, "Home");
			validKeys.Add(Keys.End, "End");
			validKeys.Add(Keys.Insert, "Ins");
		    validKeys.Add(Keys.F1, "F1");
		    validKeys.Add(Keys.F2, "F2");
		    validKeys.Add(Keys.F3, "F3");
		    validKeys.Add(Keys.F4, "F4");
		    validKeys.Add(Keys.F5, "F5");
		    validKeys.Add(Keys.F6, "F6");
		    validKeys.Add(Keys.F7, "F7");
		    validKeys.Add(Keys.F8, "F8");
		    validKeys.Add(Keys.F9, "F9");
		    validKeys.Add(Keys.F10, "F10");
		    validKeys.Add(Keys.F11, "F11");
		    validKeys.Add(Keys.F12, "F12");
		    validKeys.Add(Keys.A, "A");
		    validKeys.Add(Keys.B, "B");
		    validKeys.Add(Keys.C, "C");
		    validKeys.Add(Keys.D, "D");
		    validKeys.Add(Keys.E, "E");
		    validKeys.Add(Keys.F, "F");
		    validKeys.Add(Keys.G, "G");
		    validKeys.Add(Keys.H, "H");
		    validKeys.Add(Keys.I, "I");
		    validKeys.Add(Keys.J, "J");
		    validKeys.Add(Keys.K, "K");
		    validKeys.Add(Keys.L, "L");
		    validKeys.Add(Keys.M, "M");
		    validKeys.Add(Keys.N, "N");
		    validKeys.Add(Keys.O, "O");
		    validKeys.Add(Keys.P, "P");
		    validKeys.Add(Keys.Q, "Q");
		    validKeys.Add(Keys.R, "R");
		    validKeys.Add(Keys.S, "S");
		    validKeys.Add(Keys.T, "T");
		    validKeys.Add(Keys.U, "U");
		    validKeys.Add(Keys.V, "V");
		    validKeys.Add(Keys.W, "W");
		    validKeys.Add(Keys.X, "X");
		    validKeys.Add(Keys.Y, "Y");
		    validKeys.Add(Keys.Z, "Z");
		}
		#endregion

	}
}
