﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using System.Windows.Forms;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// JumpFolderManager。シングルトン。
	/// </summary>
	public class JumpFolderManager {
		static JumpFolderManager instance = new JumpFolderManager();
		/// <summary>
		/// JumpFolderManagerのインスタンス。JumpFolderManagerはシングルトン
		/// </summary>
		static public JumpFolderManager Instance {
			get {return instance;}
		}

		private List<IJumpFolder> jumpFolderList = new List<IJumpFolder>();
		int loadFolderNum = 0; //saveするときに前回よりフォルダ数が減ってたら、nullを埋めるために記録しておく

		private JumpFolderManager() {
			Load();
		}

		/// <summary>
		/// JumpFolderManagerが管理しているJumpFolderを全て取得
		/// </summary>
		public List<IJumpFolder> JumpFolders {
			get {
				return jumpFolderList;
			}
		}

		/// <summary>
		/// 保存している情報から読み込む
		/// </summary>
		private void Load() {
			SettingFile file = SettingFile.Instance;
			int loadFolderNum = file.LoadInt("JumpFolder", "Number", 0);
			try {
				//１個１個読み込む
				for (int i = 0; i < loadFolderNum; i++) {
					string tmp_str = file.Load("JumpFolder", "Folder" + i);
					string[] strs = tmp_str.Split(',');
					jumpFolderList.Add(new JumpFolder(strs[0], strs[1]));
				}
			} catch (Exception) {
				loadFolderNum = 0;
				jumpFolderList.Clear();
			}
		}

		private void Save() {
			SettingFile file = SettingFile.Instance;
			//全体データを登録
			file.Save("JumpFolder", "Number", jumpFolderList.Count.ToString());

			//全フォルダを１個１個登録
			for (int i = 0; i < jumpFolderList.Count; i++) {
				file.Save("JumpFolder", "Folder" + i, jumpFolderList[i].Title + "," + jumpFolderList[i].Folder.FullName);
			}
			//前回より減った場合はnullを渡して項目を無くす
			for (int i = jumpFolderList.Count; i < loadFolderNum; i++) {
				file.Save("JumpFolder", "Folder" + i, null);
			}
		}

		/// <summary>
		/// JumpFolderを登録する
		/// </summary>
		/// <param name="jumpFolder"></param>
		/// <returns>登録されたらtrue, 失敗したらfalse</returns>
		public bool AddFolder(IJumpFolder jumpFolder) {
			foreach (JumpFolder folder in jumpFolderList) {
				if (folder.Folder.FullName == jumpFolder.Folder.FullName || folder.Title == jumpFolder.Title) {
					SCFiler2System.ShowDialogMessage("すでに登録されています");
					return false;
				}
			}
			if (!System.IO.Directory.Exists(jumpFolder.Folder.FullName)) {
				SCFiler2System.ShowDialogMessage("無効なフォルダを登録しようとしています");
				return false;
			}
			jumpFolderList.Add(jumpFolder);
			Save();
			return true;
		}

		public void RemoveFolder(IJumpFolder jumpFolder) {
			foreach (IJumpFolder folder in jumpFolderList) {
				if (folder.Folder == jumpFolder.Folder && folder.Title == jumpFolder.Title) {
					jumpFolderList.Remove(folder);
					Save();
					return;
				}
			}
		}

		/// <summary>
		/// target_itemの登録順番を一つ上のアイテムと入れ替える
		/// </summary>
		/// <param name="targetItem"></param>
		public void ItemOrderUp(IJumpFolder targetItem) {
			for (int i = 0; i < jumpFolderList.Count; i++) {
				if (targetItem.Title == jumpFolderList[i].Title) {
					if (i == 0) {
						return; //一番上のアイテムなので何もできない
					}
					IJumpFolder tmpItem = jumpFolderList[i - 1];
					jumpFolderList[i - 1] = jumpFolderList[i];
					jumpFolderList[i] = tmpItem;
					return;
				}
			}
			Save();
		}

		/// <summary>
		/// target_itemの登録順番を一つ下のアイテムと入れ替える
		/// </summary>
		/// <param name="targetItem"></param>
		public void ItemOrderDown(IJumpFolder targetItem) {
			for (int i = 0; i < jumpFolderList.Count; i++) {
				if (targetItem.Title == jumpFolderList[i].Title) {
					if (i == jumpFolderList.Count - 1) {
						return; //最後のアイテムなので何もできない
					}
					IJumpFolder tmpItem = jumpFolderList[i + 1];
					jumpFolderList[i + 1] = jumpFolderList[i];
					jumpFolderList[i] = tmpItem;
					return;
				}
			}
			Save();
		}
	}
}
