using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.Operation;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2 {
	public partial class HistoryView : UserControl , IHistoryView {
		HistoryManager manager = null;

		public ViewType Type {
			get { return ViewType.HistoryView; }
		}

		public HistoryView() {
			InitializeComponent();
		}

		/// <summary>
		/// r[őIĂACeԂ
		/// </summary>
		public List<IFilerItem> SelectedFilerItems {
			get {
				List<IFilerItem> list = new List<IFilerItem>();
				foreach (ListViewItem item in listView.SelectedItems) {
					list.Add((IFilerItem)item.Tag);
				}
				return list;
			}
		}

		public List<IFilerItem> Items {
			get {
				List<IFilerItem> list = new List<IFilerItem>();
				foreach (ListViewItem item in listView.Items) {
					list.Add((IFilerItem)item.Tag);
				}
				return list;
			}
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="historyManager">r[\ĂHistoryManager</param>
		/// <param name="viewTitle">̕ۑȂǂɎgCX^Xʂ邽߂̕</param>
		public void Initialise(HistoryManager historyManager, string viewTitle) {
			//֘Ȁ
			manager = historyManager;

			//ŏ̕\
			viewTitleLabel.Text = viewTitle;
			UpdateView();
			titlePanel.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			viewTitleLabel.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}

		public void UpdateView() {
			//r[̏Ԃ̍XV
			SuspendLayout();
			this.listView.BeginUpdate();
			listView.Columns.Add("", listView.Width);

			listView.Items.Clear();
			foreach (FilerItem item in manager.ItemList) {
				ListViewItem viewItem = new ListViewItem(item.Name);
				viewItem.Tag = item;
				viewItem.ToolTipText = item.FullName;
				listView.Items.Add(viewItem);
			}
			if (listView.Items.Count > 0) {
				listView.Items[0].Selected = true;
				listView.Items[0].Focused = true;
			}
			listView.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);
			this.listView.EndUpdate();
			ResumeLayout();
		}

		/// <summary>
		/// IԂƃtH[JX\ȌێȂr[XV
		/// </summary>
		public void UpdateView(bool isKeepSelectingAndFocus) {
			throw new Exception("");
		}

		/// <summary>
		/// Xgr[̃ACeSĂIBSđIԂSĉBtH[JX̂ACȇIԂɖ߂
		/// </summary>
		public void SelectAll() {
			if (listView.SelectedItems.Count == listView.Items.Count) {
				foreach (ListViewItem item in listView.Items) {
					if (item.Focused != true) {
						item.Selected = false;
					}
				}
			} else {
				foreach (ListViewItem item in listView.Items) {
					item.Selected = true;
				}
			}
		}

		/// <summary>
		/// r[̐FANeBu̎̐FɕύX
		/// </summary>
		private void SetViewActiveColor() {
			titlePanel.BackColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleBack;
			viewTitleLabel.ForeColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleText;
		}

		/// <summary>
		/// r[̐FANeBu̎̐FɕύX
		/// </summary>
		private void SetViewInactiveColor() {
			titlePanel.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			viewTitleLabel.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}

		private void HistoryView_Enter(object sender, EventArgs e) {
			MainForm.Instance.NotifyHistoryViewFocused(this);
			DisplayCurrentItemInformation();
			SetViewActiveColor();
		}

		private void HistoryView_Leave(object sender, EventArgs e) {
			SCFiler2System.ShowTempMessage("");
			SetViewInactiveColor();
		}

		private void listView_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.ExecuteAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void listView_DoubleClick(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ExecuteFocusedItem).Execute();
		}

		private void listView_SelectedIndexChanged(object sender, EventArgs e) {
			if (listView.Focused == false) {
				return;
			}
			DisplayCurrentItemInformation();
		}

		/// <summary>
		/// ݑI𒆂̃ACȅ\
		/// </summary>
		private void DisplayCurrentItemInformation() {
			if (listView.SelectedItems.Count > 0) {
				IFilerItem item = (IFilerItem)listView.SelectedItems[0].Tag;
				SCFiler2System.ShowTempMessage(item.FullName);
			} else {
				SCFiler2System.ShowTempMessage("");
			}
		}

		private void listView_ItemDrag(object sender, ItemDragEventArgs e) {
			//IACeFullNameXg
			string[] selectedFiles = FilerItem.GetStringArrayFromFileList(this.SelectedFilerItems);

			//hbO
			DataObject data = new DataObject(DataFormats.FileDrop, selectedFiles);
			listView.DoDragDrop(data, DragDropEffects.Copy | DragDropEffects.Link);
		}

		private void listView_SizeChanged(object sender, EventArgs e) {
			listView.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);

		}

		private void listView_MouseUp(object sender, MouseEventArgs e) {
			if (e.Button == MouseButtons.Right && listView.SelectedItems.Count > 0) {
				listView.ContextMenu = ViewContextMenu.Instance.GetHistoryViewContextMenu(this.SelectedFilerItems);
			}
		}

		private void clearButton_Click(object sender, EventArgs e) {
			this.manager.Clear();
		}

		private void clearButton_MouseHover(object sender, EventArgs e) {
		}

		private void clearButton_MouseLeave(object sender, EventArgs e) {
		}

		new public void Focus() {
			base.Focus();
		}

		public void SetFocus(IFilerItem target) {
			foreach (ListViewItem item in this.listView.Items) {
				IFilerItem fItem = (IFilerItem)item.Tag;
				if (fItem.FullName == target.FullName) {
					item.Focused = true;
					break;
				}
			}
		}

		public void SetSelection(IFilerItem target, bool isSelected) {
			foreach (ListViewItem item in this.listView.Items) {
				IFilerItem fItem = (IFilerItem)item.Tag;
				if (fItem.FullName == target.FullName) {
					item.Selected = isSelected;
					break;
				}
			}
		}

		public void ClearSelection() {
			this.listView.SelectedItems.Clear();
		}
	}
}
