using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	abstract public class HistoryManager {
		private List<IFilerItem> historyList = new List<IFilerItem>();//ۑ郊Xg
		private HistoryView view; //̃}l[WƊ֘AtĂr[
		private string viewName; //֘Ar[̖O
		private int loadedItemNum; //loadƂACeĂƂinit@C߂ɓǂݍݐۑĂ

		/// <summary>
		/// HistoryManagerɓo^ĂACeꗗ
		/// </summary>
		public List<IFilerItem> ItemList {
			get { return historyList; }
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="focusedView">HistoryManagerΉHistoryView</param>
		/// <param name="viewName">HistoryMangerɑΉr[̖OBt@Cւ̐ݒۑƁAtH[̕\Ɏg</param>
		public HistoryManager(HistoryView view, string viewName) {
			this.view = view;
			this.viewName = viewName;
		}

		/// <summary>
		/// FullNameIFilerItem(HistoryManagerɉAFileFolder)̃CX^X쐬Bݒt@C痚ǂݍޗp
		/// </summary>
		/// <param name="itemFullname">肽ACeFullName</param>
		/// <returns>쐬CX^X</returns>
		abstract protected IFilerItem CreateNewItem(string itemFullName);

		/// <summary>
		/// sꂽACeo^Ώۂ̃ACeǂԂ
		/// </summary>
		/// <param name="item">sꂽACe</param>
		/// <returns>o^Ώۂ̃ACetrue</returns>
		abstract protected bool IsRegist(IFilerItem item);

		/// <summary>
		/// o^IFilerItemԂ\bh
		/// sꂽt@Co^t@C̎̂
		/// </summary>
		/// <param name="item">sꂽACe</param>
		/// <returns>Historyɓo^邽߂Item</returns>
		abstract protected IFilerItem CreateNewItemFromExecutedItem(IFilerItem item);

		public void Clear() {
			this.historyList.Clear();
			this.view.UpdateView();
		}

		/// <summary>
		/// itemsꂽƂʒm
		/// </summary>
		/// <param name="item">sꂽACe</param>
		public void NotifyItemExecuted(IFilerItem item) {
			if (IsRegist(item) == false) {
				return;
			}
			IFilerItem registItem = CreateNewItemFromExecutedItem(item);

			//łɂ폜iԏɒǉ邽߁j
			foreach (IFilerItem one in historyList) {
				if (one.FullName == registItem.FullName) {
					historyList.Remove(one);
					break;
				}
			}
			
			historyList.Insert(0, registItem);
			int max = SCFiler2System.Instance.Option.HistoryView.ItemMaxNum;
			if (historyList.Count > max) {
				historyList.RemoveRange(max, historyList.Count - max);
			}
			view.UpdateView();
		}

		/// <summary>
		/// ݒt@C痚Ɛݒǂݍ
		/// </summary>
		virtual public void Load() {
			SettingFile file = SettingFile.Instance;
			try {
				int num = file.LoadInt(viewName, "Num", 0);

				//ݒt@CɕKvȏۑĂĂAIvVݒl萔ȂȂ悤for
				for (int i = 0; i < num && i < SCFiler2System.Instance.Option.HistoryView.ItemMaxNum; i++) {
					string str = file.Load(viewName, "History" + i);
					historyList.Add(CreateNewItem(str));
				}
				loadedItemNum = num;
			} catch (Exception) {
				SCFiler2System.ShowHistoryMessage("[HistoryManager]̓ǂݍ݂Ɏs܂");
				//sƂȂ̂őSăNA
				historyList.Clear();
				loadedItemNum = 0;
			}
		}

		/// <summary>
		/// ݒt@CɗƐݒ
		/// </summary>
		virtual public void Save() {
			SettingFile file = SettingFile.Instance;
			int index = 0;

			file.Save(viewName, "Num", historyList.Count.ToString());
			for (index = 0; index < historyList.Count && index < SCFiler2System.Instance.Option.HistoryView.ItemMaxNum; index++) {
				file.Save(viewName, "History" + index, historyList[index].FullName);
			}
			//ǂݍ񂾐菭Ȃꍇ͏
			for (; index < loadedItemNum; index++) {
				file.Save(viewName, "History" + index, null);
			}
		}
	}
}
