/*
	$Id: FileOperation.cs,v 1.26 2008/06/13 02:47:56 catwalk Exp $
*/

using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Runtime.Serialization;
using System.Threading;
using System.Windows.Forms;

namespace ShellContextMenu {
	using IO = System.IO;
	using Path = System.IO.Path;
	using MemoryStream = System.IO.MemoryStream;
	
	/// <summary>
	/// t@CɊւNX
	/// </summary>
	public static class FileOperation{
		
		#region SHFileOperation
		
		/// <summary>
		/// SHFileOperationɓnNXB
		/// </summary>
		private class SHFileOperationArgs{
			private IntPtr handle;
			public IntPtr Handle{
				get{return handle;}
				set{handle = value;}
			}
			private FileOperationFunc func;
			public FileOperationFunc Func{
				get {return func;}
				set {func = value;}
			}
			private FileOperationOptions options;
			public FileOperationOptions Options{
				get {return options;}
				set {options = value;}
			}
			private string from;
			public string From{
				get { return from; }
				set { from = value; }
			}
			private string to;
			public string To{
				get { return to; }
				set { to = value; }
			}
			private string progressTitle;
			public string ProgressTitle{
				get { return progressTitle; }
				set { progressTitle = value; }
			}
			private FileOperationCallback callback;
			public FileOperationCallback Callback {
				get { return callback; }
				set { callback = value; }
			}
		}
		
		/// <summary>
		/// SHFileOperationĂяoB
		/// </summary>
		/// <param name="args">SHFileOperationArgs</param>
		/// <returns>FileOperationResult</returns>
		private static FileOperationResult SHFileOperation(SHFileOperationArgs args){
			SHFileOperationStruct sh = new SHFileOperationStruct();
			sh.Handle = args.Handle;
			sh.Func = args.Func;
			sh.From = args.From + '\0';
			sh.To = args.To + '\0';
			sh.Options = args.Options;
			sh.AnyOperationsAborted = false;
			sh.NameMappings = IntPtr.Zero;
			sh.ProgressTitle = args.ProgressTitle;
			FileOperationResult result = new FileOperationResult(args.From, args.To, Shell.SHFileOperation(ref sh), sh.AnyOperationsAborted);
			return result;
		}
		
		public static void Delete(params string[] files){
			Delete(files, FileOperationOptions.None, IntPtr.Zero, null, null);
		}
		
		public static void Delete(string[] files, FileOperationOptions options){
			Delete(files, options, IntPtr.Zero, null, null);
		}
		
		public static void Delete(string[] files, FileOperationOptions options, IntPtr hwnd){
			Delete(files, options, hwnd, null, null);
		}
		
		public static void Delete(string[] files, FileOperationOptions options, IntPtr hwnd, string progressTitle){
			Delete(files, options, hwnd, progressTitle, null);
		}
		
		public static void Delete(string[] files, FileOperationOptions options, IntPtr hwnd, string progressTitle, FileOperationCallback callback){
			if(files == null){
				throw new ArgumentNullException();
			}
			if(files.Length == 0){
				throw new ArgumentException();
			}
			SHFileOperationArgs args = new SHFileOperationArgs();
			args.Handle = hwnd;
			args.Func = FileOperationFunc.Delete;
			args.Options = options;
			args.From = String.Join("\0", files);
			args.To = null;
			args.ProgressTitle = progressTitle;
			args.Callback = callback;
			Thread thread = new Thread(new ParameterizedThreadStart(Delete_Thread));
			thread.Start(args);
		}
		
		private static void Delete_Thread(object obj){
			try{
				SHFileOperationArgs args = (SHFileOperationArgs)obj;
				FileOperationResult result = SHFileOperation(args);
				if(args.Callback != null){
					args.Callback(result);
				}
			}catch(Exception){
			}
		}
		
		public static void Move(string to, params string[] files){
			Move(files, to, FileOperationOptions.None, IntPtr.Zero, null, null);
		}
		
		public static void Move(string[] files, string to, FileOperationOptions options){
			Move(files, to, options, IntPtr.Zero, null, null);
		}
		
		public static void Move(string[] files, string to, FileOperationOptions options, IntPtr hwnd){
			Move(files, to, options, hwnd, null, null);
		}
		
		public static void Move(string[] files, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle){
			Move(files, to, options, hwnd, progressTitle, null);
		}
		
		public static void Move(string[] files, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle, FileOperationCallback callback){
			if(files == null){
				throw new ArgumentNullException();
			}
			if(files.Length == 0){
				throw new ArgumentException();
			}
			SHFileOperationArgs args = new SHFileOperationArgs();
			args.Handle = hwnd;
			args.Func = FileOperationFunc.Move;
			args.Options = options;
			args.From = String.Join("\0", files);
			args.To = to;
			args.ProgressTitle = progressTitle;
			args.Callback = callback;
			Thread thread = new Thread(new ParameterizedThreadStart(Move_Thread));
			thread.Start(args);
		}
		
		private static void Move_Thread(object obj){
			try{
				SHFileOperationArgs args = (SHFileOperationArgs)obj;
				FileOperationResult result = SHFileOperation(args);
				if(args.Callback != null){
					args.Callback(result);
				}
			}catch(Exception){
			}
		}
		
		public static void Copy(string to, params string[] files){
			Copy(files, to, FileOperationOptions.None, IntPtr.Zero, null, null);
		}
		
		public static void Copy(string[] files, string to, FileOperationOptions options){
			Copy(files, to, options, IntPtr.Zero, null, null);
		}
		
		public static void Copy(string[] files, string to, FileOperationOptions options, IntPtr hwnd){
			Copy(files, to, options, hwnd, null, null);
		}
		
		public static void Copy(string[] files, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle){
			Copy(files, to, options, hwnd, progressTitle, null);
		}
		
		public static void Copy(string[] files, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle, FileOperationCallback callback){
			if(files == null){
				throw new ArgumentNullException();
			}
			if(files.Length == 0){
				throw new ArgumentException();
			}
			SHFileOperationArgs args = new SHFileOperationArgs();
			args.Handle = hwnd;
			args.Func = FileOperationFunc.Copy;
			args.Options = options;
			args.From = String.Join("\0", files);
			args.To = to;
			args.ProgressTitle = progressTitle;
			args.Callback = callback;
			Thread thread = new Thread(new ParameterizedThreadStart(Copy_Thread));
			thread.Start(args);
		}
		
		private static void Copy_Thread(object obj){
			try{
				SHFileOperationArgs args = (SHFileOperationArgs)obj;
				FileOperationResult result = SHFileOperation(args);
				if(args.Callback != null){
					args.Callback(result);
				}
			}catch(Exception){
			}
		}
			
		public static void Rename(string from, string to){
			Rename(from, to, FileOperationOptions.None, IntPtr.Zero, null, null);
		}
		
		public static void Rename(string from, string to, FileOperationOptions options){
			Rename(from, to, options, IntPtr.Zero, null, null);
		}
		
		public static void Rename(string from, string to, FileOperationOptions options, IntPtr hwnd){
			Rename(from, to, options, hwnd, null, null);
		}
		
		public static void Rename(string from, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle){
			Rename(from, to, options, hwnd, progressTitle, null);
		}
		
		public static void Rename(string from, string to, FileOperationOptions options, IntPtr hwnd, string progressTitle, FileOperationCallback callback){
			if((from == null) || (to == null)){
				throw new ArgumentNullException();
			}
			SHFileOperationArgs args = new SHFileOperationArgs();
			args.Handle = hwnd;
			args.Func = FileOperationFunc.Rename;
			args.Options = options;
			args.From = from;
			args.To = to;
			args.ProgressTitle = progressTitle;
			args.Callback = callback;
			Thread thread = new Thread(new ParameterizedThreadStart(Rename_Thread));
			thread.Start(args);
		}
		
		private static void Rename_Thread(object obj){
			try{
				SHFileOperationArgs args = (SHFileOperationArgs)obj;
				FileOperationResult result = SHFileOperation(args);
				if(args.Callback != null){
					args.Callback(result);
				}
			}catch(Exception){
			}
		}
		
		/// <summary>
		/// Vt@C쐬B
		/// </summary>
		/// <param name="path">t@CpX</param>
		/// <remarks>
		/// 쐬̃fBNgꍇ͍쐬B
		/// ܂AobNXbV(\)̏ꍇ̓t@C쐬AfBNĝ݂쐬B
		/// </remarks>
		public static void CreateFile(string path){
			path = Path.GetFullPath(path);
			int idx = path.LastIndexOf("\\");
			if(idx != -1){
				try{
					IO.Directory.CreateDirectory(path.Substring(0, idx));
				}catch(Exception ex){
					throw new DirectoryCreateException("Faild to create directory.", ex);
				}
			}
			if(idx != (path.Length - 1)){
				try{
					IO.FileStream fs = IO.File.Create(path);
					fs.Close();
				}catch(Exception ex){
					throw new FileCreateException("Faild to create directory.", ex);
				}
			}
		}
		
		#endregion
		
		#region ShellExecute
		
		public static void Execute(string verb, string file){
			Execute(verb, file, null, null, ShowWindowCommand.ShowNormal, IntPtr.Zero);
		}
		
		public static void Execute(string verb, string file, string parameter){
			Execute(verb, file, parameter, null, ShowWindowCommand.ShowNormal, IntPtr.Zero);
		}
		
		public static void Execute(string verb, string file, string parameter, string directory){
			Execute(verb, file, parameter, directory, ShowWindowCommand.ShowNormal, IntPtr.Zero);
		}
		
		public static void Execute(string verb, string file, string parameter, string directory, ShowWindowCommand nShow){
			Execute(verb, file, parameter, directory, nShow, IntPtr.Zero);
		}
		
		/// <summary>
		/// t@CsB
		/// </summary>
		/// <param name="verb">s</param>
		/// <param name="file">t@CpX</param>
		/// <param name="parameter">p[^</param>
		/// <param name="directory">NfBNg</param>
		/// <param name="nShow">EChȄ</param>
		/// <param name="hwnd">EChEnh</param>
		public static void Execute(string verb, string file, string parameter, string directory, ShowWindowCommand nShow, IntPtr hwnd){
			ExecuteArgs args = new ExecuteArgs();
			args.Handle = hwnd;
			args.Verb = verb;
			args.File = file;
			args.Parameter = parameter;
			args.Directory = directory;
			args.Show = nShow;
			Thread thread = new Thread(new ParameterizedThreadStart(Execute_Thread));
			thread.Start(args);
		}
		
		private static void Execute_Thread(object obj){
			try{
				ExecuteArgs args = (ExecuteArgs)obj;
				ShellExecuteInfo shinfo = new ShellExecuteInfo();
				shinfo.Size = Marshal.SizeOf(shinfo);
				shinfo.Mask = SEEMask.None;
				shinfo.Handle = args.Handle;
				shinfo.Verb = args.Verb;
				shinfo.File = args.File;
				shinfo.Parameters = args.Parameter;
				shinfo.Directory = args.Directory;
				shinfo.Show = args.Show;
				Shell.ShellExecuteEx(ref shinfo);
			}catch(Exception){
			}
		}
		
		private class ExecuteArgs{
			private IntPtr handle;
			public IntPtr Handle {
				get { return handle; }
				set { handle = value; }
			}
			private string verb;
			public string Verb {
				get { return verb; }
				set { verb = value; }
			}
			private string file;
			public string File{
				get { return file; }
				set { file = value; }
			}
			private string parameter;
			public string Parameter{
				get { return parameter; }
				set { parameter = value; }
			}
			private string directory;
			public string Directory{
				get { return directory; }
				set { directory = value; }
			}
			private ShowWindowCommand show;
			public ShowWindowCommand Show{
				get { return show; }
				set { show = value; }
			}
		}
		
		#endregion
		
		#region Shell
		
		public static bool ExecuteDefaultAction(params string[] files){
			IShellFolder desktopFolder = null;
			IShellFolder parentFolder = null;
			IContextMenu iContextMenu = null;
			try{
				using(NativeMenuItem menu = new NativeMenuItem()){
					iContextMenu = Shell.GetIContextMenu(IntPtr.Zero, files, out desktopFolder, out parentFolder);
					iContextMenu.QueryContextMenu(menu.Handle, (uint)0, (uint)1, (uint)0x7fff, (uint)0);
					int cmdId = menu.GetDefaultItem(MenuFoundBy.Command, GetMenuDefaultItemOptions.Normal);
					if(cmdId != -1){
						cmdId--;
						Shell.InvokeCommand(iContextMenu, cmdId, IntPtr.Zero, ShowWindowCommand.ShowNormal);
						return true;
					}else{
						return false;
					}
				}
			}finally{
				if(iContextMenu != null){
					Marshal.ReleaseComObject(iContextMenu);
				}
				if(parentFolder != null){
					Marshal.ReleaseComObject(parentFolder);
				}
				if(desktopFolder != null){
					Marshal.ReleaseComObject(desktopFolder);
				}
			}
		}
		
		public static bool ShowContextMenu(Control control, Point pos, params string[] files){
			IShellFolder desktopFolder = null;
			IShellFolder parentFolder = null;
			IContextMenu iContextMenu = null;
			try{
				using(NativeMenuItem menu = new NativeMenuItem()){
					iContextMenu = Shell.GetIContextMenu(control.Handle, files, out desktopFolder, out parentFolder);
					iContextMenu.QueryContextMenu(menu.Handle, (uint)0, (uint)1, (uint)0x7fff, (uint)0);
					int cmdId = menu.Show(control, pos, TrackPopupMenuOptions.ReturnCommand | TrackPopupMenuOptions.LeftAlign | TrackPopupMenuOptions.TopAlign);
					if(cmdId != 0){
						cmdId--;
						Shell.InvokeCommand(iContextMenu, cmdId, control.Handle, ShowWindowCommand.ShowNormal);
						return true;
					}else{
						return false;
					}
				}
			}finally{
				if(iContextMenu != null){
					Marshal.ReleaseComObject(iContextMenu);
				}
				if(parentFolder != null){
					Marshal.ReleaseComObject(parentFolder);
				}
				if(desktopFolder != null){
					Marshal.ReleaseComObject(desktopFolder);
				}
			}
		}
		
		public static void ShowProperty(IntPtr hwnd, params string[] files){
			Shell.InvokeCommand(19, hwnd, ShowWindowCommand.ShowNormal, files);
		}
		
		public static OLEError EmptyRecycleBin(){
			return EmptyRecycleBin(null, IntPtr.Zero, SHEmptyRecycleBinOptions.None);
		}
		
		public static OLEError EmptyRecycleBin(string drive){
			return EmptyRecycleBin(drive, IntPtr.Zero, SHEmptyRecycleBinOptions.None);
		}
		
		public static OLEError EmptyRecycleBin(string drive, IntPtr hwnd){
			return EmptyRecycleBin(drive, hwnd, SHEmptyRecycleBinOptions.None);
		}
		
		public static OLEError EmptyRecycleBin(string drive, IntPtr hwnd, SHEmptyRecycleBinOptions options){
			return Shell.SHEmptyRecycleBin(hwnd, drive, options);
		}
		
		#endregion
		
		#region Clipboard
		
		/// <summary>
		/// t@CNbv{[hɃRs[B
		/// </summary>
		/// <param name="files">Rs[t@C</param>
		public static void CopyToClipboard(params string[] files){
			SetFilesToClipboard(files, (DropEffect.Copy | DropEffect.Link));
		}
		
		/// <summary>
		/// t@CNbv{[hɐ؂B
		/// </summary>
		/// <param name="files">؂t@C</param>
		public static void CutToClipboard(params string[] files){
			SetFilesToClipboard(files, (DropEffect.Move | DropEffect.Link));
		}
		
		public static void PasteClipboardFiles(string outputDir){
			PasteClipboardFiles(outputDir, FileOperationOptions.None, IntPtr.Zero, null, null);
		}
		
		public static void PasteClipboardFiles(string outputDir, FileOperationOptions options){
			PasteClipboardFiles(outputDir, options, IntPtr.Zero, null, null);
		}
		
		public static void PasteClipboardFiles(string outputDir, FileOperationOptions options, IntPtr hwnd){
			PasteClipboardFiles(outputDir, options, hwnd, null, null);
		}
		
		public static void PasteClipboardFiles(string outputDir, FileOperationOptions options, IntPtr hwnd, string progressTitle){
			PasteClipboardFiles(outputDir, options, hwnd, progressTitle, null);
		}
		
		public static void PasteClipboardFiles(string outputDir, FileOperationOptions options, IntPtr hwnd, string progressTitle, FileOperationCallback callback){
			DropEffect effect = ClipboardDropEffect;
			string[] files = ClipboardFiles;
			if(files.Length > 0){
				if((effect & DropEffect.Copy) == DropEffect.Copy){
					Copy(files, outputDir, options, hwnd, progressTitle, callback);
				}else if((effect & DropEffect.Move) == DropEffect.Move){
					Move(files, outputDir, options, hwnd, progressTitle, callback);
					ClearClipboard();
				}
			}
		}
		
		public static void ClearClipboard(){
			System.Windows.Forms.Clipboard.Clear();
		}
		
		/// <summary>
		/// Proffered DropEffect̒l𓾂vpeBB
		/// </summary>
		public static DropEffect ClipboardDropEffect{
			get{
				IDataObject iDataObj = System.Windows.Forms.Clipboard.GetDataObject();
				object dropEffect = iDataObj.GetData("Preferred DropEffect");
				MemoryStream stream = dropEffect as MemoryStream;
				if(stream != null){
					return (DropEffect)BitConverter.ToInt32(stream.ToArray(), 0);
				}else{
					return DropEffect.None;
				}
			}
		}
		
		public static string[] ClipboardFiles{
			get{
				if(System.Windows.Forms.Clipboard.ContainsFileDropList()){
					//TODO ToArray()Ȃƌ
					//return System.Windows.Forms.Clipboard.GetFileDropList().ToArray();
					return null;
				}else{
					return new string[0];
				}
			}
		}
		
		/// <summary>
		/// Nbv{[hɃt@Ci[B
		/// </summary>
		/// <param name="files">i[t@C</param>
		/// <param name="effect">DropEffect</param>
		public static void SetFilesToClipboard(string[] files, DropEffect effect){
			IDataObject iDataObj = new DataObject(DataFormats.FileDrop, files);
			MemoryStream dropEffect = new MemoryStream();
			byte[] bytes = new byte[]{(byte)effect, 0, 0, 0};
			dropEffect.Write(bytes, 0, bytes.Length);
			dropEffect.SetLength(bytes.Length);
			iDataObj.SetData("Preferred DropEffect", dropEffect);
			System.Windows.Forms.Clipboard.SetDataObject(iDataObj);
		}
		
		#endregion
	}
	
	[Flags]
	public enum DropEffect : int{
		None = 0,
		Copy = 1,
		Move = 2,
		Link = 4
	}
	
	public class FileOperationResult{
		public FileOperationResult(string from, string to, int errorCode, bool isAborted){
			this.FromFiles = from.Split('\0');
			this.To = to;
			this.IsAborted = isAborted;
			this.ErrorCode = errorCode;
		}

		string[] fromFiles;
		public string[] FromFiles{
			get { return fromFiles; }
			private set { fromFiles = value; }
		}

		private string to;
		public string To{
			get { return to; }
			private set { to = value; }
		}

		private bool isAborted;
		/// <summary>
		/// ~ꂽǂB
		/// </summary>
		public bool IsAborted{
			get { return isAborted; }
			private set { isAborted = value; }
		}
		
		private int errorCode;
		/// <summary>
		/// G[0ȊO̐
		/// </summary>
		public int ErrorCode{
			get { return errorCode; }
			private set { errorCode = value; }
		}
		
		public bool IsErrored{
			get{
				return (this.ErrorCode != 0);
			}
		}
	}
	
	public delegate void FileOperationCallback(FileOperationResult result);
	
	public class FileCreateException : IO.IOException{
		public FileCreateException() : base(){
		}
		
		public FileCreateException(string message) : base(message){
		}
		
		public FileCreateException(string message, Exception innerException) : base(message, innerException){
		}
		
		public FileCreateException(string message, int hresult) : base(message, hresult){
		}
		
		protected FileCreateException(SerializationInfo info, StreamingContext context) : base(info, context){
		}
	}
	
	public class DirectoryCreateException : IO.IOException{
		public DirectoryCreateException() : base(){
		}
		
		public DirectoryCreateException(string message) : base(message){
		}
		
		public DirectoryCreateException(string message, Exception innerException) : base(message, innerException){
		}
		
		public DirectoryCreateException(string message, int hresult) : base(message, hresult){
		}
		
		protected DirectoryCreateException(SerializationInfo info, StreamingContext context) : base(info, context){
		}
	}
}