using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using SCFiler2.Util;
using SCFiler2.Operation;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;

namespace SCFiler2 {
	/// <summary>
	/// GNXv[̊gq̊֘Atɑ΂ASCFiler2ł͕ʂ̃AvŋN邽߂̊֘AtێNXiVOgj
	/// p҂Execute()Ƀt@CnČĂяoƁA{NXΉOc[ŋN
	/// ݒ̓o^Add, Remove, Update\bh𗘗p
	/// </summary>
	public class ExtensionRelationCustomize {
		/// Ci[NXItemAK\ƂɈvƂɋNOc[IDԍĂ

		private ActionManager.ActionID[] externalToolActions = {
			ActionManager.ActionID.ExecuteExternalTool1,
			ActionManager.ActionID.ExecuteExternalTool2,
			ActionManager.ActionID.ExecuteExternalTool3,
			ActionManager.ActionID.ExecuteExternalTool4,
			ActionManager.ActionID.ExecuteExternalTool5
		};

		static private ExtensionRelationCustomize instance = new ExtensionRelationCustomize();
		static public ExtensionRelationCustomize Instance {
			get { return instance; }
		}

		private ExtensionRelationCustomize() {
			this.Load();
		}

		public class Item {
			/// <summary>
			/// ֘AÂݒ肵t@CK\
			/// </summary>
			public Regex expression;
			/// <summary>
			/// Oc[IDԍ
			/// </summary>
			public int num;
		}

		public List<Item> Items = new List<Item>();

		/// <summary>
		/// ݒۑ
		/// </summary>
		public void Save() {
			SettingFile.Instance.Save("ExtensionRelationCustomize", "ItemNum", Items.Count.ToString());
			for (int i = 0; i < Items.Count; i++) {
				SettingFile.Instance.Save("ExtensionRelationCustomize", "RegExpression" + i, Items[i].expression.ToString());
				SettingFile.Instance.Save("ExtensionRelationCustomize", "ExtToolNum" + i, Items[i].num.ToString());
			}
		}

		/// <summary>
		/// ݒǂݍ
		/// </summary>
		public void Load() {
			int num = SettingFile.Instance.LoadInt("ExtensionRelationCustomize", "ItemNum", 0);
			for (int i=0; i< num; i++) {
				Item item = new Item();
				item.expression = new Regex(SettingFile.Instance.Load("ExtensionRelationCustomize", "RegExpression" + i));
				item.num = SettingFile.Instance.LoadInt("ExtensionRelationCustomize", "ExtToolNum" + i , 0);
				Items.Add(item);
			}
		}

		/// <summary>
		/// o^ꂽ֘AÂŃAvP[VN
		/// o^Ă̂ɊYȂꍇ̓GNXv[̊֘AÂŋN
		/// </summary>
		/// <param name="target">AvP[VŊJt@C</param>
		public void Execute(IFilerItem target) {
			foreach (Item item in Items) {
				//K\ɍvOc[ŋN
				if (item.expression.IsMatch(target.FullName)) {
					ExternalToolManager.Instance.GetItem(item.num + 1).Execute(target);
					return;
				}
			}
			//ȂΒʏs
			this.ExecuteByNormalRelation(target);
		}

		/// <summary>
		/// GNXv[̊֘AÂŎs
		/// </summary>
		/// <param name="target"></param>
		private void ExecuteByNormalRelation(IFilerItem target) {
			//t@CAs
			try {
				ProcessStartInfo startInfo = new ProcessStartInfo(target.FullName);
				startInfo.WorkingDirectory = target.Path;
				Process.Start(startInfo);
			} catch {
				//TODO ʂProcessŎsłȂShell32.dllgċNB
				//Iɂ͂Hɓꂵق悢HH
				ShellUtil.ShellExecute(target.FullName, target.Path);
			}
			//r[ɒʒm
			foreach (HistoryManager manager in MainForm.Instance.AllHistoryManager) {
				manager.NotifyItemExecuted(target);
			}
		}

		/// <summary>
		/// ֘AÂ̐ݒǉ
		/// </summary>
		/// <param name="item">ǉݒ</param>
		public void Add(Item item) {
			this.Items.Add(item);
		}

		/// <summary>
		/// ֘AÂ̐ݒ폜
		/// </summary>
		/// <param name="itemIndex">폜ݒindex</param>
		public void Remove(int itemIndex) {
			this.Items.RemoveAt(itemIndex);
		}

		/// <summary>
		/// o^Ăݒ擾
		/// </summary>
		/// <param name="index">擾ݒindex</param>
		/// <returns>擾ݒ</returns>
		public Item GetItem(int index) {
			return this.Items[index];
		}

		/// <summary>
		/// o^ς݂̐ݒ̓eXV
		/// </summary>
		/// <param name="index">XVΏۂindex</param>
		/// <param name="item">uitem</param>
		public void Update(int index, Item item) {
			Items[index] = item;
		}
	}
}
