using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCFiler2 {
	public partial class ExtensionRelationCustomForm : Form {
		private ExtensionRelationCustomize.Item item;
		public ExtensionRelationCustomize.Item InputItem {
			get { return item; }
		}


		public ExtensionRelationCustomForm() {
			InitializeComponent();
			for (int i = 0; i < ExternalToolManager.MaxToolNum; i++) {
				this.ExternalToolCombobox.Items.Add("Oc[" + (i+1));
			}
		}

		private void cancelButton_Click(object sender, EventArgs e) {
			this.item = null;
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void okButton_Click(object sender, EventArgs e) {
			if (ExternalToolCombobox.SelectedItem == null) {
				SCFiler2System.ShowDialogMessage("Oc[IĂ܂");
				return;
			}
			this.item = new ExtensionRelationCustomize.Item();
			this.item.expression = new System.Text.RegularExpressions.Regex(this.RegExpressionTextbox.Text);
			this.item.num = ExternalToolCombobox.SelectedIndex;
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		public DialogResult ShowDialog(string regExpression, int num) {
			this.RegExpressionTextbox.Text = regExpression;
			this.ExternalToolCombobox.SelectedIndex = num;
			return this.ShowDialog();
		}
	}
}