using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class EasySelect : Action {
		public override string DisplayString {
			get { return "Xy[XőI[h"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				view.SelectMode = SelectMode.Easy;
			} else {
				SCFiler2System.ShowTempMessage("FileViewɃtH[JX܂");
			}

		}
	}
}
