using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Operation;
using System.Drawing;
using SCFiler2.Util;
using System.IO;

namespace SCFiler2 {
	/// <summary>
	/// JX^c[o[̈̃ACe\NX
	/// </summary>
	public class CustomToolbarItem {
		ActionManager.ActionID targetActionID;
		string displayString;

		Icon icon;
		string iconFilename;
		bool isGetIconFromExeFile;

		/// <summary>
		/// c[o[ɕ\Ƃ̃ACR
		/// </summary>
		public Icon Icon {
			get { return icon; }
		}

		/// <summary>
		/// c[`bvȂǂɕ\Ƃp̕
		/// </summary>
		public string DisplayString {
			get { return this.displayString; }
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="actionName">̃ACeꂽƂɎsAction\</param>
		/// <param name="iconFile">t@CipXjBpXicontH_ɓĂO</param>
		public CustomToolbarItem(string actionName, string iconFile) {
			foreach (ActionManager.ActionID id in ActionManager.AllActionID) {
				string str = ActionManager.GetDisplayString(id);
				if (str == actionName) {
					this.targetActionID = id;
					this.displayString = str;
					break;
				}
			}
			try {
				icon = new Icon(@"icons\" + iconFile);
			} catch (FileNotFoundException) {
				icon = Images.Default;
				SCFiler2System.ShowHistoryMessage("[error]JX^c[o[Ɋ蓖ĂꂽACR܂");
			}
			this.iconFilename = iconFile;
			this.isGetIconFromExeFile = false;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="actionName">̃ACeꂽƂɎsAction\</param>
		/// <param name="isGetIconFromExeFile">֘AtꂽOc[exet@CACR𒊏oƂtrue.Ŏw肷ƂfalseɂđRɎw肷</param>
		/// <param name="iconFile">t@CipXjBpXicontH_ɓĂOBisGetIconFromExeFiletruêƂ͗pȂ</param>
		public CustomToolbarItem(string actionName, bool isGetIconFromExeFile, string iconFile) {
			foreach (ActionManager.ActionID id in ActionManager.AllActionID) {
				string str = ActionManager.GetDisplayString(id);
				if (str == actionName) {
					this.targetActionID = id;
					this.displayString = str;
					break;
				}
			}
			this.isGetIconFromExeFile = isGetIconFromExeFile;
			this.iconFilename = iconFile;
			if (isGetIconFromExeFile == true) {
				Action targetAction = ActionManager.CreateAction(this.targetActionID);
				ExecuteExternalTool exeExtTool = targetAction as ExecuteExternalTool;
				try {
					if (exeExtTool != null) {
						this.icon = System.Drawing.Icon.ExtractAssociatedIcon(
							ExternalToolManager.Instance.GetItem(exeExtTool.Index).Path);
					} else {
						this.icon = Images.Default;
						SCFiler2System.ShowHistoryMessage("[error]Oc["+exeExtTool.Index+"܂");
					}
				} catch (ArgumentException) {
					this.icon = Images.Default;
					SCFiler2System.ShowHistoryMessage("[error]Oc[" + exeExtTool.Index + "܂");
				} catch (FileNotFoundException) {
					this.icon = Images.Default;
					SCFiler2System.ShowHistoryMessage("[error]Oc[" + exeExtTool.Index + "܂");
				}
			} else {
				this.icon = new Icon(iconFile);
			}
		}

		/// <summary>
		/// ̃JX^c[o[ɑΉActionIDԂ
		/// </summary>
		public ActionManager.ActionID ActionID {
			get { return this.targetActionID; }
		}

		/// <summary>
		/// ֘AtĂANV̎s
		/// </summary>
		public void ExecuteAction() {
			ActionManager.CreateAction(this.targetActionID).Execute();
		}

		/// <summary>
		/// CX^X𕶎񉻂郁\bhBCreateInstanceFromStringƑ΂ɂȂĎg
		/// </summary>
		/// <returns></returns>
		public override string ToString() {
			return  this.DisplayString + ","
				+ this.isGetIconFromExeFile.ToString() + ","
				+ this.iconFilename;
		}

		/// <summary>
		/// 񂩂CX^X쐬static\bh
		/// </summary>
		/// <param name="str">ƂȂ镶iCustomToolbarItem.ToString()́j</param>
		/// <returns>CX^XB񂩂畜łȂꍇnullԂ</returns>
		static public CustomToolbarItem CreateInstanceFromString(string str) {
			string[] strs = str.Split(',');

			//strƏ𖞂Ă邩`FbNAĂȂreturn null

			if (strs.Length != 3) {
				return null;
			}

			//܂͑P̃`FbN
			if (strs[0] == "") {
				return null;
			}
			Action targetAction = null;
			foreach (ActionManager.ActionID id in Enum.GetValues(typeof(ActionManager.ActionID))) {
				Action action = ActionManager.CreateAction(id);
				if (strs[0] == action.DisplayString) {
					targetAction = action;
					break;
				}
			}
			if (targetAction == null) {
				return null;
			}

			//Q̃`FbN
			bool isGetFileFromExe;
			try {
				isGetFileFromExe = bool.Parse(strs[1]);
			} catch (FormatException) {
				return null;
			}

			//Q̒lɏ]ăCX^X𐶐
			if (isGetFileFromExe == true) {
				Action action = targetAction as ExecuteExternalTool;
				if (action == null) {
					return null;
				} else {
					return new CustomToolbarItem(action.DisplayString, isGetFileFromExe, strs[2]);
				}
			} else {
				if (System.IO.File.Exists(@"icons\" + strs[2])) {
					return new CustomToolbarItem(targetAction.DisplayString, strs[2]);
				} else {
					return null;
				}
			}
		}
	}
}
