﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using SCFiler2.CommonDialog;
using SCFiler2.ViewInterface;
using SCFiler2.FileSystem;

namespace SCFiler2.Operation {
	public class CreateFolder : Action {
		public override string DisplayString {
			get { return "フォルダの新規作成"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				InputTextForm form = new InputTextForm("新規作成：フォルダ名を入力してください");
				if (form.ShowDialog() == System.Windows.Forms.DialogResult.Cancel) {
					SCFiler2System.ShowTempMessage("フォルダの新規作成はキャンセルされました");
					return;
				}
				string folderName = form.GetInputtedText();
				string newFolderFullName = view.CurrentPath + "\\" + folderName;
				Microsoft.VisualBasic.FileIO.FileSystem.CreateDirectory(newFolderFullName);
				view.UpdateView();
				view.ClearSelection();
				Folder folder = new Folder(newFolderFullName);
				view.SetFocus(folder);
				view.SetSelection(folder, true);
				view.SelectMode = SelectMode.Normal;
				SCFiler2System.ShowHistoryMessage("フォルダ" + folderName + "を作成しました");
			} else {
				SCFiler2System.ShowTempMessage("FileViewにフォーカスがありません");
			}
		}
	}
}
