﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class CopyToClipboard : Action {
		public override string DisplayString {
			get { return "クリップボードへコピー"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			IItemView view = ViewInterfaces.CurrentItemView;
			if (view.SelectedFilerItems.Count == 0) {
				SCFiler2System.ShowTempMessage("ファイルが選択されていません");
				return;
			}
			ClipboardManager.SendToClipboard(ClipboardManager.EffectType.Copy, view.SelectedFilerItems);
			SCFiler2System.ShowTempMessage("選択アイテムをクリップボードにコピーしました");
			ViewInterfaces.CheckUpdateAllView();
		}
	}
}
