#! python3
# -*- coding: utf-8 -*-
'''
  Copyright (C) 2012 psi

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import imp
import os
import unittest
import sys

if __name__ == "__main__":
	suite = unittest.TestSuite()
	loader = unittest.TestLoader()
	abs = os.path.abspath(os.path.dirname(__file__))
	sys.path.append(abs)
	for dpath,dnames,fnames in os.walk(abs):
		for fname in fnames:
			file=os.path.join(dpath, fname)
			if os.path.isfile(file) and file.endswith('_test.py'):
				print("Test: {0}".format(file))
				mod = imp.load_source(os.path.splitext(file)[0], file)
				suite.addTest(loader.loadTestsFromModule(mod))
	unittest.TextTestRunner(verbosity=3).run(suite)
