#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.h"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QtGui/QMainWindow>
#include <QProcess>

class RubySyntaxHighliter;
class QTabWidget;
class EditView;
class QTextBrowser;
class QPlainTextEdit;
class QAction;
class QMenu;
class QProcess;
class RubyProcess;
class QTimer;
class QThread;
class QTemporaryFile;
class QUrl;
class ReplaceDlg;
struct Settings;

#if 0
struct Settings
{
	QString		m_fontFamily;
	int			m_fontSize;
public:
    void	readSettings();
    void	writeSettings();
};
#endif

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public:
	Settings	*settings();

protected:
	void	createActions();
	void	createMenus();
	void	createToolBars();
	void	createDockWindows();
	void	setupStatusBar();
    void	readSettings();
    void	writeSettings();

    void	updateWindowTitle();
    void	updateCurFile();
    bool	maybeSave();
    bool	maybeSave(EditView *);
    bool	saveFile(EditView *, const QString &fileName);
    bool	loadFileToThisMainWindow(const QString &fileName);
    void	loadFile(const QString &fileName);
    bool	loadFile(EditView *, const QString &fileName);
    void	addToRecentFileList(const QString &);		//	WXg "recentFileList" ɒǉ
    void	updateRecentFileActions();
    void	updateRecentFileActionsOfAllMainWindows();
    void	addToRecentDirList(const QString &);		//	WXg "recentFileList" ɒǉ
    void	updateRecentDirActions();
    void	setCurrentFile(const QString &fileName);
    void	addToWindowsList(const QString &);
    MainWindow	*findMainWindow(const QString &fileName);
    void	close(EditView *);
    void	updateEncodingMenuChecked(uchar enc);

    void	openResultFile(uchar);

	void	callRuby(bool bRun);
	EditView	*createView();
	void	parseSyntaxError();

protected:
	//void	keyPressEvent ( QKeyEvent * event );
	bool	eventFilter ( QObject * watched, QEvent * event );
	void	closeEvent(QCloseEvent *event);
	void	dragEnterEvent ( QDragEnterEvent * event );
	void	dropEvent ( QDropEvent * event );

protected slots:
	void	newFile();
	void	open();
    bool	save();
    bool	saveAs();
    void	openRecentFile();
    void	openFromRecentDir();
	void	closeThisDocument();
	void	exit();
	void	setEncoding();

	void	undo();
	void	redo();
	void	cut();
	void	copy();
	void	paste();
	void	openLineAbove();
	void	openLineBelow();
	void	unIndent();

	void	replace();
	void	findWordAtCursor();
	void	findNext();
	void	findPrev();
	void	tagJump();
	void	jumpToErrorLine();
	void	gotoMatchedParen();

	void	run();
	void	stop();
	void	doSettings();
	void	about();

	void	browserBack();

	void	onFinished();
	//void	onFinished(int, QProcess::ExitStatus);
	void	checkSyntax();
	void	onReadyRead();
	void	onReadyReadError();
	void	doOutput(const QString &);		//	AEgvbgyCɃeLXgo
	void	doOutputError(const QString &);		//	G[o
	void	onTimer();
	void	onDocContentsChanged();
	void	onModificationChanged ( bool changed );
	void	tabCloseRequested(int);
	void	onTabChanged(int);
	void	onSourceChanged(const QUrl &);
	void	onEncodingChanged();

signals:
	void	startRuby(const QStringList &);
	void	writeToRuby(const QString &);

private:
	QTabWidget	*m_tabWidget;
	//EditView	*m_editor;
	QPlainTextEdit	*m_output;			//	o̓yCEBWbg
	QPlainTextEdit	*m_outputError;		//	G[o̓yCEBWbg
	QTextBrowser	*m_browser;			//	`[gAEwv\
	RubyProcess		*m_process;
	QTimer			*m_timer;
	QThread			*m_thread;			//	ruby sXbh
	QTemporaryFile	*m_tempFile;

	QString		m_fileName;				//	RpCt@C
	bool		m_running;
	//bool		m_docModified;			//	`FbNɃhLgCꂽ
	bool		m_toTerminate;
	int			m_docNumber;

	QString		m_findString;
	ReplaceDlg	*m_replaceDlg;
	Settings	*m_settings;

private:
    QAction *m_newAct;
    QAction *m_openAct;
    QAction *m_saveAct;
    QAction *m_saveAsAct;
    QAction *m_closeAct;
    QAction *m_exitAct;

    enum { MaxRecentFiles = 10 + 26 };
    QAction *m_recentFileActs[MaxRecentFiles];
    enum { MaxRecentDirs = 10 + 26 };
    QAction *m_recentDirActs[MaxRecentDirs];

    QMenu		*m_encMenu;
	QAction		*m_encUTF8Act;
	QAction		*m_encUTF16LEAct;
	QAction		*m_encUTF16BEAct;
	QAction		*m_encSJISAct;
	QAction		*m_encEUCAct;

	QAction		*m_runAct;
	QAction		*m_stopAct;
	QAction		*m_checkSyntaxAct;
	QAction		*m_jumpToErrorLineAct;

	QAction		*m_undoAct;
	QAction		*m_redoAct;
	QAction		*m_copyAct;
	QAction		*m_cutAct;
	QAction		*m_pasteAct;
	QAction		*m_openLineAboveAct;
	QAction		*m_openLineBelowAct;
	QAction		*m_unIndentAct;

	QAction		*m_replaceAct;
	QAction		*m_findWordAtCursorAct;
	QAction		*m_findNextAct;
	QAction		*m_findPrevAct;
	QAction		*m_tagJumpAct;
	QAction		*m_gotoMatchedParenAct;

	QAction		*m_browserHomeAct;
	QAction		*m_browserBackAct;

	QAction		*m_settingsAct;
	QAction		*m_aboutAct;
};

#endif // MAINWINDOW_H
