//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/
#include <QtGui>
//#include <QTextBrowse>
//#include <QClipBoard>

#include "mainwindow.h"
#include "EditView.h"
#include "RubyProcess.h"
#include "charEncoding.h"
#include "SettingsDlg.h"
#include "Settings.h"
#include "ReplaceDlg.h"

#define		VERSION_STR					"0.003 Dev"
#define		CHECK_SYNTAX_INTERVAL		200
#define		KEY_RECENTFILELIST			"recentFileList"
#define		KEY_RECENTDIRLIST			"recentDirList"

MainWindow::MainWindow(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	setAcceptDrops(true);
	m_settings = new Settings();
	m_running = false;
	//m_docModified = false;
	m_toTerminate = false;
	m_replaceDlg = 0;
	m_tempFile = 0;
	m_docNumber = 0;
	m_process = new RubyProcess();
	connect(this, SIGNAL(startRuby(const QStringList &)), m_process, SLOT(startRuby(const QStringList &)));
	connect(this, SIGNAL(writeToRuby(const QString &)), m_process, SLOT(writeToRuby(const QString &)));
	connect(m_process, SIGNAL(finished()), this, SLOT(onFinished()));
	//connect(m_process, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(onFinished(int, QProcess::ExitStatus)));
	connect(m_process, SIGNAL(readyReadStandardOutput()), this, SLOT(onReadyRead()));
	connect(m_process, SIGNAL(readyReadStandardError()), this, SLOT(onReadyReadError()));

	m_tabWidget = new QTabWidget;
	m_tabWidget->setAcceptDrops(false);
	m_tabWidget->setMovable(true);
	m_tabWidget->setTabsClosable(true);
	connect(m_tabWidget, SIGNAL(tabCloseRequested(int)), this, SLOT(tabCloseRequested(int)));
	connect(m_tabWidget, SIGNAL(currentChanged(int)), this, SLOT(onTabChanged(int)));
	//m_tabWidget->addTab(createView(), tr("Untitled-%1").arg(++m_docNumber));
#if 0
	m_editor = new EditView();
	QFont font = m_editor->font();
	font.setPointSize(14);
	m_editor->setFont(font);
	m_editor->setTabStopWidth(m_editor->fontMetrics().width("    "));	//	undone: 󔒐ݒ\
	connect(m_editor->document(), SIGNAL(contentsChanged()),
			this, SLOT(onDocContentsChanged()));
	m_editor->installEventFilter(this);
	m_tabWidget->addTab(m_editor, tr("Untitled"));
#endif
	setCentralWidget(m_tabWidget);

	createActions();
	createMenus();
	createToolBars();
	createDockWindows();
    readSettings();			//	createActions() ̌ɃR[邱

    connect(m_browserBackAct, SIGNAL(triggered()), m_browser, SLOT(backward()));
    setWindowTitle(QString("RuviEdit version %1").arg(VERSION_STR));

	newFile();
	m_timer = new QTimer;
	connect(m_timer, SIGNAL(timeout()), this, SLOT(onTimer()));
	m_timer->start(CHECK_SYNTAX_INTERVAL);
	statusBar()->showMessage(tr("Ready"));

	m_thread = new QThread;
	m_thread->start();
	m_process->moveToThread(m_thread);

	m_tabWidget->widget(0)->setFocus();
}

MainWindow::~MainWindow()
{
	delete m_settings;
}
EditView *MainWindow::createView()
{
	EditView *view = new EditView(m_settings);
#if 0
	QFont font = view->font();
	font.setPointSize(14);
#endif
	QFont font(m_settings->m_fontFamily, m_settings->m_fontSize);
	view->setFont(font);
	//view->setTextColor(m_settings->color(Settings::TEXT));
	view->onSettingsChanged();
	//connect(view->document(), SIGNAL(contentsChanged()),
	//		view, SLOT(onContentsChanged()));
	connect(view, SIGNAL(modificationChanged(bool)),
			this, SLOT(onModificationChanged(bool)));
	connect(view, SIGNAL(encodingChanged()),
			this, SLOT(onEncodingChanged()));
	view->installEventFilter(this);
	//QList<int> errLines;
	//errLines << 1 << 3;
	//view->setSyntaxErrorLineNums(errLines);
	//view->setTabChangesFocus(false);
	return view;
}
void MainWindow::createActions()
{
	//	t@C֘A
    m_newAct = new QAction(QIcon(":MainWindow/Resources/new.png"), tr("&New"), this);
    m_newAct->setShortcuts(QKeySequence::New);
    m_newAct->setStatusTip(tr("Create a new document"));
    connect(m_newAct, SIGNAL(triggered()), this, SLOT(newFile()));

    m_openAct = new QAction(QIcon(":MainWindow/Resources/open.png"), tr("&Open..."), this);
    m_openAct->setShortcuts(QKeySequence::Open);
    m_openAct->setStatusTip(tr("Open an existing file"));
    connect(m_openAct, SIGNAL(triggered()), this, SLOT(open()));

    m_saveAct = new QAction(QIcon(":MainWindow/Resources/save.png"), tr("&Save"), this);
    m_saveAct->setShortcuts(QKeySequence::Save);
    m_saveAct->setStatusTip(tr("Save to file"));
    connect(m_saveAct, SIGNAL(triggered()), this, SLOT(save()));

    m_saveAsAct = new QAction(tr("Save&As..."), this);
    m_saveAsAct->setShortcuts(QKeySequence::SaveAs);
    m_saveAsAct->setStatusTip(tr("Save the file under a new fileName"));
    connect(m_saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));

    //	RecentFilesMenu ̂߂̏
    for (int i = 0; i < MaxRecentFiles; ++i) {
        m_recentFileActs[i] = new QAction(this);
        m_recentFileActs[i]->setVisible(false);
        connect(m_recentFileActs[i], SIGNAL(triggered()), this, SLOT(openRecentFile()));
    }
    for (int i = 0; i < MaxRecentDirs; ++i) {
        m_recentDirActs[i] = new QAction(this);
        m_recentDirActs[i]->setVisible(false);
        connect(m_recentDirActs[i], SIGNAL(triggered()), this, SLOT(openFromRecentDir()));
    }

    m_closeAct = new QAction(tr("&CloseCurDoc"), this);
    m_closeAct->setShortcuts(QKeySequence::Close);
    m_closeAct->setStatusTip(tr("close current document"));
    connect(m_closeAct, SIGNAL(triggered()), this, SLOT(closeThisDocument()));

    m_exitAct = new QAction(tr("e&Xit"), this);
    //m_exitAct->setShortcuts(QKeySequence::Quit);
    m_exitAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_F4));
    m_exitAct->setStatusTip(tr("close all files and exit"));
    connect(m_exitAct, SIGNAL(triggered()), this, SLOT(exit()));

    m_encUTF8Act = new QAction(tr("UTF&8"), this);
    m_encUTF8Act->setData(CharEncoding::UTF8);
    m_encUTF8Act->setCheckable(true);
    connect(m_encUTF8Act, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encUTF16LEAct = new QAction(tr("UTF16&LE"), this);
    m_encUTF16LEAct->setData(CharEncoding::UTF16_LE);
    m_encUTF16LEAct->setCheckable(true);
    connect(m_encUTF16LEAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encUTF16BEAct = new QAction(tr("UTF16&BE"), this);
    m_encUTF16BEAct->setData(CharEncoding::UTF16_BE);
    m_encUTF16BEAct->setCheckable(true);
    connect(m_encUTF16BEAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encSJISAct = new QAction(tr("&SJIS"), this);
    m_encSJISAct->setData(CharEncoding::SJIS);
    m_encSJISAct->setCheckable(true);
    connect(m_encSJISAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encEUCAct = new QAction(tr("&EUC"), this);
    m_encEUCAct->setData(CharEncoding::EUC);
    m_encEUCAct->setCheckable(true);
    connect(m_encEUCAct, SIGNAL(triggered()), this, SLOT(setEncoding()));

    //	Ruby
	m_runAct = new QAction(QIcon(":MainWindow/Resources/Play.png"), tr("&Run"), this);
	m_runAct->setShortcut(QKeySequence(Qt::Key_F5));
	connect(m_runAct, SIGNAL(triggered()), this, SLOT(run()));
	m_stopAct = new QAction(QIcon(":MainWindow/Resources/Stop.png"), tr("&Stop"), this);
	m_stopAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F5));
	connect(m_stopAct, SIGNAL(triggered()), this, SLOT(stop()));
	m_checkSyntaxAct = new QAction(QIcon(":MainWindow/Resources/Check.png"), tr("&CheckSyntax"), this);
	m_checkSyntaxAct->setShortcut(QKeySequence(Qt::Key_F7));
	connect(m_checkSyntaxAct, SIGNAL(triggered()), this, SLOT(checkSyntax()));
	m_jumpToErrorLineAct = new QAction(tr("JumpTo&ErrorLine"), this);
	m_jumpToErrorLineAct->setShortcut(QKeySequence(Qt::Key_F4));
	connect(m_jumpToErrorLineAct, SIGNAL(triggered()), this, SLOT(jumpToErrorLine()));

	//	ҏW
	m_undoAct = new QAction(QIcon(":MainWindow/Resources/undo.png"), tr("&Undo"), this);
    m_undoAct->setShortcuts(QKeySequence::Undo);
    m_undoAct->setStatusTip(tr("undo edit command"));
	//m_undoAct->setEnabled(false);
    connect(m_undoAct, SIGNAL(triggered()), this, SLOT(undo()));
    ///connect(this, SIGNAL(canUndoChanged(bool)), m_undoAct, SLOT(setEnabled(bool)));

	m_redoAct = new QAction(QIcon(":MainWindow/Resources/redo.png"), tr("&Redo"), this);
    m_undoAct->setShortcuts(QKeySequence::Redo);
    //m_redoAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_R));
    m_redoAct->setStatusTip(tr("redo edit commande"));
	///m_redoAct->setEnabled(false);
    connect(m_redoAct, SIGNAL(triggered()), this, SLOT(redo()));
    ///connect(this, SIGNAL(canRedoChanged(bool)), m_redoAct, SLOT(setEnabled(bool)));

    m_cutAct = new QAction(QIcon(":MainWindow/Resources/cut.png"), tr("Cu&t"), this);
    m_cutAct->setShortcuts(QKeySequence::Cut);
    m_cutAct->setStatusTip(tr("Cut the current selection's contents to the clipboard"));
    connect(m_cutAct, SIGNAL(triggered()), this, SLOT(cut()));

    m_copyAct = new QAction(QIcon(":MainWindow/Resources/copy.png"), tr("&Copy"), this);
    m_copyAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_C));
    //m_copyAct->setShortcuts(QKeySequence::Copy);
    m_copyAct->setStatusTip(tr("Copy the current selection's contents to the clipboard"));
    connect(m_copyAct, SIGNAL(triggered()), this, SLOT(copy()));

    m_pasteAct = new QAction(QIcon(":MainWindow/Resources/paste.png"), tr("&Paste"), this);
    m_pasteAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_V));
    m_pasteAct->setStatusTip(tr("Paste the clipboard's contents into the current selection"));
    connect(m_pasteAct, SIGNAL(triggered()), this, SLOT(paste()));

    m_openLineAboveAct = new QAction(tr("&OpenLineAbove"), this);
    m_openLineAboveAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Return));
    m_openLineAboveAct->setStatusTip(tr("Open a new line above"));
    connect(m_openLineAboveAct, SIGNAL(triggered()), this, SLOT(openLineAbove()));
    m_openLineBelowAct = new QAction(tr("&OpenLineAbove"), this);
    m_openLineBelowAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Return));
    m_openLineBelowAct->setStatusTip(tr("Open a new line below"));
    connect(m_openLineBelowAct, SIGNAL(triggered()), this, SLOT(openLineBelow()));
    m_unIndentAct = new QAction(tr("&UnIndent"), this);
    m_unIndentAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Tab));
    //m_unIndentAct->setStatusTip(tr("Open a new line above"));
    connect(m_unIndentAct, SIGNAL(triggered()), this, SLOT(unIndent()));

    m_replaceAct = new QAction(tr("&Find/Replace..."), this);
    m_replaceAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F));
    connect(m_replaceAct, SIGNAL(triggered()), this, SLOT(replace()));

    m_findWordAtCursorAct = new QAction(tr("Find&Word"), this);
    m_findWordAtCursorAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F3));
    connect(m_findWordAtCursorAct, SIGNAL(triggered()), this, SLOT(findWordAtCursor()));

    m_findNextAct = new QAction(tr("Find&Next"), this);
    m_findNextAct->setShortcut(QKeySequence(Qt::Key_F3));
    connect(m_findNextAct, SIGNAL(triggered()), this, SLOT(findNext()));

    m_findPrevAct = new QAction(tr("Find&Prev"), this);
    m_findPrevAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F3));
    connect(m_findPrevAct, SIGNAL(triggered()), this, SLOT(findPrev()));

    m_tagJumpAct = new QAction(tr("&TagJump"), this);
    m_tagJumpAct->setShortcut(QKeySequence(Qt::Key_F9));
    connect(m_tagJumpAct, SIGNAL(triggered()), this, SLOT(tagJump()));
    m_gotoMatchedParenAct = new QAction(tr("&MatchedParen"), this);
    m_gotoMatchedParenAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_BracketRight));	//	^]
    connect(m_gotoMatchedParenAct, SIGNAL(triggered()), this, SLOT(gotoMatchedParen()));

    m_browserBackAct = new QAction(tr("&Back"), this);
    //m_browserBackAct->setStatusTip(tr("close all files and exit"));
    //connect(m_browserBackAct, SIGNAL(triggered()), this, SLOT(browserBack()));


    m_settingsAct = new QAction(QIcon(":MainWindow/Resources/settings.png"), tr("&Settings..."), this);
    m_settingsAct->setShortcut(QKeySequence(Qt::Key_F8));
    m_settingsAct->setStatusTip(tr("refer and/or modify Settings"));
    connect(m_settingsAct, SIGNAL(triggered()), this, SLOT(settings()));

    m_aboutAct = new QAction(QIcon(":MainWindow/Resources/Information.png"), tr("&AboutRuviEdit..."), this);
    m_aboutAct->setStatusTip(tr("refer and/or modify Settings"));
    connect(m_aboutAct, SIGNAL(triggered()), this, SLOT(about()));

}
void MainWindow::createMenus()
{
    QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(m_newAct);
    fileMenu->addAction(m_openAct);
    fileMenu->addAction(m_saveAct);
    fileMenu->addAction(m_saveAsAct);
    m_encMenu = fileMenu->addMenu(tr("encoding of this doc"));
    m_encMenu->addAction(m_encUTF8Act);
    m_encMenu->addAction(m_encUTF16LEAct);
    m_encMenu->addAction(m_encUTF16BEAct);
    m_encMenu->addAction(m_encSJISAct);
    m_encMenu->addAction(m_encEUCAct);
    fileMenu->addAction(m_closeAct);
    fileMenu->addSeparator();
    //	RecentFilesMenu ACeǉ
    QMenu *MRU = fileMenu->addMenu(tr("RecentFiles(&1)"));
    for (int i = 0; i < MaxRecentFiles; ++i)
        MRU->addAction(m_recentFileActs[i]);
    updateRecentFileActions();
    //	RecentDirMenu ACeǉ
    QMenu *MRUDir = fileMenu->addMenu(tr("OpenFromRecentDirs(&2)"));
    for (int i = 0; i < MaxRecentDirs; ++i)
        MRUDir->addAction(m_recentDirActs[i]);
    updateRecentDirActions();
    fileMenu->addSeparator();
    fileMenu->addAction(m_exitAct);

    QMenu *editMenu = menuBar()->addMenu(tr("&Edit"));
    editMenu->addAction(m_undoAct);
    editMenu->addAction(m_redoAct);
    editMenu->addAction(m_cutAct);
    editMenu->addAction(m_copyAct);
    editMenu->addAction(m_pasteAct);
    editMenu->addSeparator();
    editMenu->addAction(m_openLineAboveAct);
    editMenu->addAction(m_openLineBelowAct);
    editMenu->addAction(m_unIndentAct);
    editMenu->addSeparator();
    editMenu->addAction(m_replaceAct);
    editMenu->addAction(m_findWordAtCursorAct);
    editMenu->addAction(m_findNextAct);
    editMenu->addAction(m_findPrevAct);
    editMenu->addAction(m_tagJumpAct);
    editMenu->addAction(m_gotoMatchedParenAct);

    QMenu *rubyMenu = menuBar()->addMenu(tr("&Ruby"));
    rubyMenu->addAction(m_runAct);
    rubyMenu->addAction(m_stopAct);
    rubyMenu->addAction(m_checkSyntaxAct);
    rubyMenu->addAction(m_jumpToErrorLineAct);

    QMenu *otherMenu = menuBar()->addMenu(tr("&Other"));
    otherMenu->addAction(m_settingsAct);
    otherMenu->addAction(m_aboutAct);
    otherMenu->addAction(m_browserBackAct);
}
void MainWindow::createToolBars()
{
    QToolBar *fileToolBar = addToolBar(tr("File"));
    fileToolBar->setObjectName("File");
    fileToolBar->addAction(m_newAct);
    fileToolBar->addAction(m_openAct);
    fileToolBar->addAction(m_saveAct);

    QToolBar *rubyToolBar = addToolBar(tr("Ruby"));
    rubyToolBar->setObjectName("Ruby");
    rubyToolBar->addAction(m_runAct);
    rubyToolBar->addAction(m_stopAct);
    rubyToolBar->addAction(m_checkSyntaxAct);

    QToolBar *editToolBar = addToolBar(tr("Edit"));
    editToolBar->setObjectName("Edit");
    editToolBar->addAction(m_undoAct);
    editToolBar->addAction(m_redoAct);
    editToolBar->addAction(m_cutAct);
    editToolBar->addAction(m_copyAct);
    editToolBar->addAction(m_pasteAct);

    QToolBar *otherToolBar = addToolBar(tr("Other"));
    otherToolBar->setObjectName("Other");
    otherToolBar->addAction(m_settingsAct);
    otherToolBar->addAction(m_aboutAct);
}
void MainWindow::createDockWindows()
{
	QDockWidget *dock;
	dock = new QDockWidget(tr("Output"));
	dock->setWidget(m_output = new QPlainTextEdit());
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::BottomDockWidgetArea, dock);

	dock = new QDockWidget(tr("Error"));
	dock->setWidget(m_outputError = new QPlainTextEdit());
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::BottomDockWidgetArea, dock);
	m_outputError->installEventFilter(this);

	dock = new QDockWidget(tr("Help/Tutorial"));
	dock->setWidget(m_browser = new QTextBrowser);
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::RightDockWidgetArea, dock);
	m_browser->setOpenExternalLinks(true);		//	ONOuEUŊJ
	connect(m_browser, SIGNAL(sourceChanged(const QUrl &)), this, SLOT(onSourceChanged(const QUrl &)));

	QFile file(":/html/Resources/html/index.html");
	if( !file.open(QIODevice::ReadOnly) ) return;
	QByteArray ba = file.readAll();
#if 1
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	m_browser->setHtml(codec->toUnicode(ba));
#else
	QTextCodec *codec = QTextCodec::codecForHtml(ba);
	m_browser->setHtml(codec->toUnicode(ba));
#endif
}
Settings *MainWindow::settings()
{
	return m_settings;
}
void MainWindow::onSourceChanged(const QUrl &src)
{
	QString path = src.path();
	statusBar()->showMessage(path, 5000);

#if 0
	QFile file(":" + path);
	if( !file.open(QIODevice::ReadOnly) ) return;
	QByteArray ba = file.readAll();
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	m_browser->setHtml(codec->toUnicode(ba));
#endif
}
void MainWindow::setEncoding()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	uchar enc = (uchar)qobject_cast<QAction *>(sender())->data().toInt();
	view->setCharEncoding(enc);
}
void MainWindow::onEncodingChanged()
{
    EditView *view = qobject_cast<EditView *>(sender());
	int ix = m_tabWidget->indexOf(view);
	if( ix < 0 ) return;
	m_tabWidget->setTabToolTip(ix, view->toolTipText());
	updateEncodingMenuChecked(view->charEncoding());
}
void MainWindow::updateEncodingMenuChecked(uchar enc)
{
	m_encUTF8Act->setChecked(enc == CharEncoding::UTF8);
	m_encUTF16LEAct->setChecked(enc == CharEncoding::UTF16_LE);
	m_encUTF16BEAct->setChecked(enc == CharEncoding::UTF16_BE);
	m_encSJISAct->setChecked(enc == CharEncoding::SJIS);
	m_encEUCAct->setChecked(enc == CharEncoding::EUC);
}
void MainWindow::browserBack()
{
}
void MainWindow::setupStatusBar()
{
}
void MainWindow::writeSettings()
{
	QSettings settings;
	settings.setValue("geometry", saveGeometry());
	settings.setValue("windowState", saveState());
	m_settings->writeSettings();
}
void MainWindow::readSettings()
{
	QSettings settings;
	restoreGeometry(settings.value("geometry").toByteArray());
	restoreState(settings.value("windowState").toByteArray());
	m_settings->readSettings();
}
bool MainWindow::eventFilter ( QObject * obj, QEvent * event )
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if (obj == view
        && event->type() == QEvent::KeyPress)
	{
		if( !m_running ) {
			QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
			if( keyEvent->key() == Qt::Key_Escape ) {
				view->clearSelection();
				return true;
			}
		}
	}
#if 0
	if (m_running && obj == m_editor 
        && event->type() == QEvent::KeyPress)
	{
		QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
		const QString text = keyEvent->text();
		m_process->writeToRuby(text);
		//emit writeToRuby(text);
		return true;
	}
#endif
#if 0
	//	}EX m_outputError LĂ̂ł܂Ȃ 12/03/25
	if( view != 0 && obj == m_outputError &&
		event->type() == QEvent::MouseButtonDblClick )
	{
		QTextCursor cur = m_outputError->textCursor();
		QTextBlock block = cur.block();
		QString text = block.text();
		QRegExp exp(":\\d+:");
		int ix = exp.indexIn(text);
		if( ix >= 0 ) {
			int lineNum = text.mid(ix + 1, exp.matchedLength() - 2).toInt();
			cur = view->textCursor();
			cur.movePosition(QTextCursor::Start);
			cur.movePosition(QTextCursor::Down, QTextCursor::MoveAnchor, lineNum - 1);
			view->setTextCursor(cur);
			view->setFocus();
			return true;
		}
	}
#endif
	return false;
}
#if 0
void MainWindow::keyPressEvent ( QKeyEvent * event )
{
}
#endif
void MainWindow::onTabChanged(int ix)
{
	EditView *view = 0;
	if( ix < 0 ) {
		m_encMenu->setTitle(QString("encoding of this doc"));
	} else {
		view = (EditView *)m_tabWidget->widget(ix);
		updateEncodingMenuChecked(view->charEncoding());
		m_encMenu->setTitle(QString("encoding of '%1'").arg(view->title()));
	}
	if( m_replaceDlg )
		m_replaceDlg->setView(view);
}
void MainWindow::doOutput(const QString &text)
{
	QTextCursor cur = m_output->textCursor();
	cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	m_output->setTextCursor(cur);
	cur.insertText(text);
}
void MainWindow::doOutputError(const QString &text)
{
	QTextCursor cur = m_outputError->textCursor();
	cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	m_outputError->setTextCursor(cur);
	cur.insertText(text);
}
//	WXg "recentDirList" ɒǉ
void MainWindow::addToRecentDirList(const QString &fullPath)
{
	QDir dir(fullPath);
	dir.cdUp();
	QString dirPath = dir.absolutePath();
    QSettings settings;
    QStringList dirs = settings.value(KEY_RECENTDIRLIST).toStringList();
    dirs.removeAll(dirPath);
    dirs.push_front(dirPath);
    while (dirs.size() > MaxRecentDirs )
        dirs.removeLast();
    settings.setValue(KEY_RECENTDIRLIST, dirs);
}
//	WXg "recentFileList" ɒǉ
void MainWindow::addToRecentFileList(const QString &fullPath)
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTFILELIST).toStringList();
    files.removeAll(fullPath);
    files.push_front(fullPath);
    while (files.size() > MaxRecentFiles)
        files.removeLast();
    settings.setValue(KEY_RECENTFILELIST, files);
}
//	settings  RecentFile oAm_recentFileActs ɐݒ
void MainWindow::updateRecentFileActions()
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTFILELIST).toStringList();
    int numRecentFiles = qMin(files.size(), (int)MaxRecentFiles);
    for (int i = 0; i < numRecentFiles; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_recentFileActs[i]->setText(text);
        m_recentFileActs[i]->setData(files[i]);
        m_recentFileActs[i]->setStatusTip(files[i]);
        m_recentFileActs[i]->setVisible(true);
    }
    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
        m_recentFileActs[j]->setVisible(false);
}
//	settings  RecentDir oAm_recentDirActs ɐݒ
void MainWindow::updateRecentDirActions()
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTDIRLIST).toStringList();
    int numRecentDirs = qMin(files.size(), (int)MaxRecentDirs);
    for (int i = 0; i < numRecentDirs; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_recentDirActs[i]->setText(text);
        m_recentDirActs[i]->setData(files[i]);
        m_recentDirActs[i]->setStatusTip(files[i]);
        m_recentDirActs[i]->setVisible(true);
    }
    for (int j = numRecentDirs; j < MaxRecentDirs; ++j)
        m_recentDirActs[j]->setVisible(false);
}
void MainWindow::openRecentFile()
{
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        loadFile(action->data().toString());
}
void MainWindow::openFromRecentDir()
{
    QAction *action = qobject_cast<QAction *>(sender());
    if (action) {
		QString fullPath = QFileDialog::getOpenFileName(this, tr("Open Ruby source File"),
														action->data().toString(),
														tr("Ruby Files(*.rb);;All Files(*.*)"));
		if( fullPath.isEmpty() ) return;
		loadFile(fullPath);
    }
}
void MainWindow::newFile()
{
	EditView *view = createView();
	QString title = tr("Untitled-%1").arg(++m_docNumber);
	view->setTitle(title);
	m_tabWidget->addTab(view, title);
	m_tabWidget->setCurrentWidget(view);
	view->setFocus();
}
void MainWindow::closeEvent(QCloseEvent *event)
{
	if (maybeSave()) {
		writeSettings();
		QMainWindow::closeEvent(event);
	} else {
		event->ignore();
	}
}
void MainWindow::closeThisDocument()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	close(view);
}

void MainWindow::close(EditView *view)
{
	if( !maybeSave(view) )	//	undone: ۑ̏ꍇ͕ۑmF
		return;
	m_tabWidget->removeTab(m_tabWidget->indexOf(view));
	delete view;
}
void MainWindow::tabCloseRequested(int ix)
{
	EditView *view = (EditView *)m_tabWidget->widget(ix);
	close(view);
}

void MainWindow::exit()
{
}
bool MainWindow::maybeSave()
{
	for(int i = 0; i < m_tabWidget->count(); ++i) {
		EditView *view = (EditView *)m_tabWidget->widget(i);
		if( !maybeSave(view) )
			return false;		//	LZIꂽꍇ
	}
	return true;
}
bool MainWindow::maybeSave(EditView *view)
{
    if (view->modified() && !view->document()->isEmpty()) {
	QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("ruviEdit"),
                     tr("The '%1' has been modified.\n"
                        "Do you want to save your changes?").arg(view->title()),
                     QMessageBox::Save | QMessageBox::Discard
		     | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
            return save();
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}
bool MainWindow::save()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return false;
	if( view->fullPath().isEmpty() )
		return saveAs();
	else
		return saveFile(view, view->fullPath());
}
bool MainWindow::saveAs()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return false;
	view->cdCurrentDir();		//	I[vĂt@C̃fBNgɈړ
#if 0
	//	OςcO߂̂ QFileDialog ĝ͒fO
	QFileDialog aDlg(this, tr("Save File"), view->title(), view->currentDir());
	aDlg.setAcceptMode(QFileDialog::AcceptSave);
	QLayout *layout = aDlg.layout();
	layout->addWidget(new QCheckBox("test"));
	if( aDlg.exec() != QFileDialog::Accepted ) return false;
	QStringList list = aDlg.selectedFiles();
	if( list.size() != 1 ) return false;
	QString fullPath = list[0];
#else
	QString fullPath = QFileDialog::getSaveFileName(this, tr("Save File"), view->title(),
													tr("Ruby files(*.rb);;All Files(*.*)"));
#endif
	if( fullPath.isEmpty() ) return false;
    view->setFullPath(fullPath);
    //	TAB ̃^CgύX
    //	undone	QTabWidget ɈˑĂ̂ŁA
    int ix = m_tabWidget->indexOf(view);
    if( ix >= 0 ) {
    	m_tabWidget->setTabText(ix, view->title());
    	m_tabWidget->setTabToolTip(ix, view->toolTipText());
    }
    //setCurrentFile(fullPath);
	if( !saveFile(view, fullPath) )
		return false;
	addToRecentFileList(fullPath);
	addToRecentDirList(fullPath);
	updateRecentFileActions();
	updateRecentDirActions();
	return true;
}
QTextCodec *toCodec(uchar enc)
{
	cchar *encName = codecName(enc);
	if( encName != 0 )
		return QTextCodec::codecForName(encName);
	else
		return QTextCodec::codecForLocale();
}
bool MainWindow::saveFile(EditView *view, const QString &fullPath)
{
	QFile file(fullPath);
	if( !file.open(QIODevice::WriteOnly) ) {
		QMessageBox::critical(this, tr("save"),
								tr("failed to save file '%1'").arg(fullPath));
		return false;
	}
	QString text = view->toPlainText();
	//QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QTextCodec *codec = toCodec(view->charEncoding());
	QByteArray ba = codec->fromUnicode(text);
	file.write(ba);
	return true;
}
void MainWindow::open()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view != 0 )
		view->cdCurrentDir();		//	I[vĂt@C̃fBNgɈړ
	QString fullPath = QFileDialog::getOpenFileName(this, tr("Open Ruby source File"), "" /*curDir()*/,
													tr("Ruby Files(*.rb);;All Files(*.*)"));
	if( fullPath.isEmpty() ) return;
	loadFile(fullPath);
}
void MainWindow::loadFile(const QString &fileNameRaw)
{
	QString fileFullPath(fileNameRaw);
	fileFullPath.replace("\xa5", "/");		//	\ = 0xa5
	QFileInfo fi(fileFullPath);
	if( !fi.exists() ) {
		return;
	}
	QString absFullPath = fi.absoluteFilePath();
	QString name = fi.fileName();		//	hoge/fuga.rb  fuga.rb

	for(int i = 0; i < m_tabWidget->count(); ++i) {
		EditView *view = (EditView *)m_tabWidget->widget(i);
		if( view->fullPath() == absFullPath ) {
			m_tabWidget->setCurrentIndex(i);
			return;
		}
	}

	EditView *view = createView();
	int ix = m_tabWidget->addTab(view, name);
	view->setFocus();
	view->setFullPath(absFullPath);
	bool rc = loadFile(view, fileNameRaw);
	m_tabWidget->setCurrentWidget(view);
	m_tabWidget->setTabToolTip(ix, view->toolTipText());
	if( !rc )
		return;
	addToRecentFileList(absFullPath);
	addToRecentDirList(absFullPath);
	updateRecentFileActions();
	updateRecentDirActions();
}
bool MainWindow::loadFile(EditView *view, const QString &fileNameRaw)
{
	QString fileFullPath(fileNameRaw);
	fileFullPath.replace("\xa5", "/");		//	\ = 0xa5
	QFile file(fileFullPath);
	if( !file.open(QIODevice::ReadOnly) ) {
		return false;
	}
	QByteArray ba = file.readAll();
	int bom;
	uchar enc = checkCharEncoding((cuchar *)ba.data(), (cuchar *)ba.data() + ba.size(), bom);
	QTextCodec *codec = toCodec(enc);
	QString text = codec->toUnicode(ba);
	view->setPlainText(text);
	view->setCharEncoding(enc);
	return true;
}
void MainWindow::dragEnterEvent ( QDragEnterEvent * event )
{
#if 1
	if( event->mimeData()->hasUrls() ) {
		//qDebug() << "has text/uri-list format";
		event->acceptProposedAction();
	}
#else
	//qDebug() << "MainWindow::dragEnterEvent";
	if( event->mimeData()->hasFormat("text/uri-list") ) {
		//qDebug() << "has text/uri-list format";
		event->acceptProposedAction();
	}
#endif
}
void MainWindow::dropEvent ( QDropEvent * event )
{
	//qDebug() << "MainWindow::dropEvent";
	QList<QUrl> fileList = event->mimeData()->urls();
	foreach(QUrl url, fileList) {
		QString fileName = QDir::toNativeSeparators(url.toLocalFile());
		//qDebug() << fileName;
		loadFile(fileName);
	}
}
//
void MainWindow::onReadyRead()
{
	QByteArray ba = m_process->readAllStandardOutput();
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QString text = codec->toUnicode(ba);
	doOutput(text);
}
void MainWindow::onReadyReadError()
{
	QByteArray ba = m_process->readAllStandardError();
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QString text = codec->toUnicode(ba);
	doOutputError(text);
}
void MainWindow::run()
{
	callRuby(true);
}
void MainWindow::stop()
{
	if( m_process->state() != QProcess::NotRunning ) {
		m_toTerminate = true;
		m_process->kill();
		statusBar()->showMessage(tr("terminated.."));
	}
}
void MainWindow::checkSyntax()
{
	if( m_process->state() == QProcess::NotRunning )
		callRuby(false);
}
void MainWindow::jumpToErrorLine()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->jumpToErrorLine();
}
void MainWindow::gotoMatchedParen()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->gotoMatchedParen();
}
void MainWindow::onDocContentsChanged()
{
	//m_docModified = true;
}
void MainWindow::onTimer()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	if( view->modifiedAfterCompile() )
		callRuby(false);
}

void MainWindow::callRuby(bool bRun)
{
	if( m_process->state() != QProcess::NotRunning ) {
		stop();
		return;
	}
	//int tabIX = m_tabWidget->currentIndex();
	//if( tabIX < 0 ) return;
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->setModifiedAfterCompile(false);
	//m_docModified = false;
	m_toTerminate = false;
	m_output->document()->clear();
	m_outputError->document()->clear();
	const QString text = view->toPlainText();
	if( text.isEmpty() ) {
		return;
	}

	//	hLgtpXĂȂꍇ́Ae|t@Cɕۑ
	if( ///!bRun ||		//	@`FbN̏ꍇ͌t@C㏑ۑsȂ
		view->fullPath().isEmpty() )
	{
		m_tempFile = new QTemporaryFile;
	    if( !m_tempFile->open() ) {
			return;
		}
		m_fileName = m_tempFile->fileName();
		QTextCodec *codec = QTextCodec::codecForName("UTF-8");
		QByteArray ba = codec->fromUnicode(text);
		m_tempFile->write(ba);
		m_tempFile->close();
	} else {
		m_fileName = view->fullPath();
		//	undone: ۑ`FbN
		saveFile(view, m_fileName);
		///if( bRun )
			view->setModified(false);
		view->cdCurrentDir();
	}

	QStringList argList;
	if( !bRun )
		argList << "-c";
	argList << m_fileName;
	//QProcess process;
	//m_process->start("ruby", argList);
	m_running = bRun;
	emit startRuby(argList);

	QProcess::ProcessError err = m_process->error();
	if( err == QProcess::FailedToStart ) {
		doOutputError(tr("can't start Ruby.\n"));
		return;
	}
	if( bRun )
		statusBar()->showMessage(tr("running..."));
	//statusBar()->showMessage(bRun ? tr("running...") : tr("syntax checking..."));
	//m_process->waitForFinished();
	//statusBar()->showMessage(tr("finished."));
}
void MainWindow::onFinished()
{
	m_running = false;
	delete m_tempFile;
	parseSyntaxError();
	m_tempFile = 0;
	statusBar()->showMessage(!m_toTerminate ? tr("finished.") : tr("terminated."));
}
void MainWindow::parseSyntaxError()
{
	QList<int> errLineNums;
	int lineNum = 1;
	QRegExp exp(":\\d+:");
	QTextDocument *doc = m_outputError->document();
	QTextBlock block = doc->begin();
	while( block.isValid() ) {
		QString text = block.text();
		int ix;
		if( (ix = exp.indexIn(text)) >= 0 ) {
			errLineNums.push_back(text.mid(ix + 1, exp.matchedLength() - 2).toInt());
		}
		++lineNum;
		block = block.next();
	}
	//if( !errLineNums.isEmpty() ) {
		EditView *view = (EditView *)m_tabWidget->currentWidget();
		if( view != 0 ) {
			view->setSyntaxErrorLineNums(errLineNums);
			QTextDocument *doc = view->document();
			const int length = doc->toPlainText().length();
			//doc->contentsChange(0, length, length);
		}
	//}
}
void MainWindow::onModificationChanged ( bool changed )
{
	EditView *view = qobject_cast<EditView *>(sender());
	int ix = m_tabWidget->indexOf(view);
	if( ix < 0 ) return;
	QString title = m_tabWidget->tabText(ix);
	if( changed && title.right(2) != "*" )
		title += " *";
	else if( !changed && title.right(2) == " *" )
		title = title.left(title.length() - 2);
	else
		return;
	m_tabWidget->setTabText(ix, title);
}
void MainWindow::undo()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->undo();
}
void MainWindow::redo()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->redo();
}
void MainWindow::cut()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->cut();
}
void MainWindow::copy()
{
#if 1
	QWidget *w = QApplication::focusWidget();
	if( w == 0 ) return;
	if( w->inherits("QTextEdit") )
		qobject_cast<QTextEdit *>(w)->copy();
#else
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->copy();
#endif
}
void MainWindow::paste()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->paste();
}
void MainWindow::openLineAbove()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->openLineAbove();
}
void MainWindow::openLineBelow()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->openLineBelow();
}
void MainWindow::unIndent()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->shiftLeft();
}
void MainWindow::doSettings()
{
	SettingsDlg stgDlg(m_settings, this);
	if( QDialog::Accepted == stgDlg.exec() ) {
		m_settings->m_lineNumber = stgDlg.lineNumber();
		m_settings->m_softTab = stgDlg.softTab();
		m_settings->m_tabWidth = stgDlg.tabWidth();
		QFont font(m_settings->m_fontFamily = stgDlg.fontFamily(),
					m_settings->m_fontSize = stgDlg.fontSize());
		for(int ix = 0; ix < m_tabWidget->count(); ++ix) {
			EditView *view = (EditView *)m_tabWidget->widget(ix);
			view->setFont(font);
			//view->updateLeftMarginSize();
			view->onSettingsChanged();
		}
		m_settings->writeSettings();
	}
#if 0
	QDialog aDlg;
	aDlg.exec();
	QMessageBox::information(this, "Settings", "");
#endif
}
void MainWindow::replace()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
#if 1
	if( m_replaceDlg == 0 ) {
		m_replaceDlg = new ReplaceDlg(view, settings());
		connect(m_replaceDlg, SIGNAL(undo()), this, SLOT(undo()));
		connect(m_replaceDlg, SIGNAL(redo()), this, SLOT(redo()));
		connect(m_replaceDlg, SIGNAL(showMessage(const QString &)), statusBar(), SLOT(showMessage(const QString &)));
	}
	m_replaceDlg->show();
#else
	ReplaceDlg aDlg(view, settings());
	connect(&aDlg, SIGNAL(showMessage(const QString &)), statusBar(), SLOT(showMessage(const QString &)));
	aDlg.exec();
#endif
}
void MainWindow::findWordAtCursor()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	QTextCursor cur = view->textCursor();
	if( !cur.hasSelection() ) {
		cur.movePosition(QTextCursor::StartOfWord);
		cur.movePosition(QTextCursor::EndOfWord, QTextCursor::KeepAnchor);
		if( !cur.hasSelection() ) return;
	}
	m_findString = cur.selectedText();
	settings()->addFindString(m_findString);
	view->find(m_findString);
}
void MainWindow::findNext()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	view->find(m_findString);
}
void MainWindow::findPrev()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	view->find(m_findString, QTextDocument::FindBackward);
}
int getToken(const QString &text, int &ix, QString &token);
void MainWindow::tagJump()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( !view ) return;
	QString blockText = view->textCursor().block().text();
	QString token;
	int ix = 0;
	getToken(blockText, ix, token);
	if( token == "require" ) {
		getToken(blockText, ix, token);
		if( token[0] == QChar('\'') || token[0] == QChar('\"') ) {
			QString fileName = token.mid(1, token.length() - 2);
			loadFile(fileName);
		}
	}
}
void MainWindow::about()
{
	QMessageBox msgBox;
	msgBox.setIconPixmap(QPixmap(":MainWindow/Resources/ayabu.png"));
	msgBox.setText(tr("<div align=center><b>RuviEdit</b> version %1</div>").arg(VERSION_STR));
	const QString ayabu((const QChar *)L"F ");
	msgBox.setInformativeText(QString("<div align=center>Copyright (C) 2012 by N.Tsuda<br>"
								"mailto:ntsuda@master.email.ne.jp<br>"
								"<a href=\"http://vivi.dyndns.org/?from=qvi%1\">http://vivi.dyndns.org/</a><br><br>"
								"Powered by <a href=\"http://qt.nokia.com/\">Qt</a>"
								"<p>illustrated by <a href=\"http://www.pixiv.net/member.php?id=220294\">%2</a></div>")
								.arg(VERSION_STR).arg(ayabu));
	msgBox.exec();
}
