#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H

#include <QDialog>

class QFontComboBox;
class QSpinBox;
class QComboBox;
class Settings;
class QToolButton;
class QCheckBox;
class QAction;

class SettingsDlg : public QDialog
{
	Q_OBJECT

public:
	SettingsDlg(Settings *, QWidget *parent = 0);
	~SettingsDlg();

public:
	bool	softTab() const;
	bool	lineNumber() const;
	int		tabWidth() const;
	QString	fontFamily() const;
	int		fontSize() const;

public:
	void	setFontFamily(const QString &);
	void	setFontSize(int);

protected:
	QToolButton	*createColorButton(int);

protected slots:
	void	selectColor();
	void	namedColor();

private:
	Settings	*m_settings;
	//QFontComboBox	*m_fontCB;
	QComboBox	*m_fontCombo;
	QSpinBox	*m_fontSpin;
	QSpinBox	*m_tabWidthSpin;
	QCheckBox	*m_softTabCheck;
	QCheckBox	*m_lineNumberCheck;

	//QAction		*m_namedColorAct;
};

#endif // SETTINGSDLG_H
