#pragma once

#include <QString>
#include <QStringList>
#include <QColor>

#define		MIN_FONT_SIZE		4
#define		MAX_FONT_SIZE		100
#define		N_FIND_STRINGS		20

struct Settings
{
public:
	enum {
		TEXT,
		BACKGROUND,
		SEL_TEXT,
		SEL_BACKGROUND,
		KEYWORD,
		STRING,
		COMMENT,
		LINE_NUMBER,
		LEFT_MARGIN,
		ERROR_MARK,

		N_COLOR,		//	F
	};
public:
	Settings(void);
	~Settings(void);

public:
	QColor	color(int ix) const { return m_colors[ix]; }
	const QStringList	&findStringList() const { return m_findStringList; }
	const QStringList	&replaceStringList() const { return m_replaceStringList; }

public:
	void	setColor(int ix, const QColor &col);
	void	addFindString(const QString &);		//	ǉWXgۑ
	void	addReplaceString(const QString &);		//	ǉWXgۑ

public:
    void	readSettings();
    void	writeSettings();

public:
    bool		m_lineNumber;	//	sԍ\
    bool		m_softTab;
    bool		m_regexp;		//	K\
    bool		m_ignoreCase;	//	p啶ꎋ
    bool		m_wordSearch;	//	Pꌟi񐳋K\̎̂ݗLj
    int			m_tabWidth;
	QString		m_fontFamily;
	int			m_fontSize;
	QColor		m_colors[N_COLOR];
	QStringList	m_findStringList;
	QStringList	m_replaceStringList;
};

