#include "Settings.h"

#include <QtCore>

typedef const char cchar;


Settings::Settings(void)
{
}


Settings::~Settings(void)
{
}
void Settings::setColor(int ix, const QColor &col)
{
	if( ix >= 0 && ix < N_COLOR )
		m_colors[ix] = col;
}

#if 1
//	undone: colorKeys, defaultColor ͍\̂ɂ悢
struct KeyColor
{
	cchar	*m_key;
	cchar	*m_color;
} keyColorTable[] = {
	{"col_text",         "black"},
	{"col_background",   "white"},
	{"col_selText",      "white"},
	{"col_selBackground","darkblue"},
	{"col_keyword",      "blue"},
	{"col_string",       "violet"},
	{"col_comment",      "darkgreen"},
	{"col_lineNumber",   "black"},
	{"col_leftMargin",   "antiquewhite"},
	{"col_errorMark",    "red"},
};

#else
static cchar *colorKeys[] = {
	"col_text",
	"col_background",
	"col_selText",
	"col_selBackground",
	"col_keyword",
	"col_string",
	"col_comment",
	"col_lineNumber",
	"col_leftMargin",
	"col_errorMark",
};
static cchar *defaultColor[] = {
	"black",
	"white",
	"white",
	"darkblue",
	"blue",
	"violet",
	"darkgreen",
	"black",
	"antiquewhite",
	"red",
};
#endif
void Settings::writeSettings()
{
	QSettings settings;
	settings.setValue("tabWidth", m_tabWidth);
	settings.setValue("lineNumber", m_lineNumber ? 1 : 0);
	settings.setValue("softTab", m_softTab ? 1 : 0);
	settings.setValue("regexp", m_regexp ? 1 : 0);
	settings.setValue("ignoreCase", m_ignoreCase ? 1 : 0);
	settings.setValue("wordSearch", m_wordSearch ? 1 : 0);
	settings.setValue("fontFamily", m_fontFamily);
	settings.setValue("fontSize", m_fontSize);
	for(int i = 0; i < N_COLOR; ++i) {
		settings.setValue(keyColorTable[i].m_key, m_colors[i].name());
		//settings.setValue(colorKeys[i], m_colors[i].name());
	}
}
void Settings::readSettings()
{
	QSettings settings;
	m_tabWidth = settings.value("tabWidth", "2").toInt();
	m_lineNumber = settings.value("lineNumber", "0").toInt() != 0;
	m_softTab = settings.value("softTab", "0").toInt() != 0;
	m_regexp = settings.value("regexp", "0").toInt() != 0;
	m_ignoreCase = settings.value("ignoreCase", "1").toInt() != 0;
	m_wordSearch = settings.value("wordSearch", "0").toInt() != 0;
	m_fontFamily = settings.value("fontFamily", "Courier New").toString();
	m_fontSize = settings.value("fontSize", "12").toInt();
	for(int i = 0; i < N_COLOR; ++i)
		m_colors[i] = QColor(settings.value(keyColorTable[i].m_key,
											keyColorTable[i].m_color).toString());
	m_findStringList = settings.value("findStrings").toStringList();
	m_replaceStringList = settings.value("replaceStrings").toStringList();
}
//	ǉWXgۑ
void Settings::addFindString(const QString &text)
{
	int ix = m_findStringList.indexOf(text);
	if( ix >= 0 )
		m_findStringList.removeAt(ix);
	m_findStringList.push_front(text);
	while( m_findStringList.size() > N_FIND_STRINGS )
		m_findStringList.removeLast();
	QSettings settings;
	settings.setValue("findStrings", m_findStringList);
	settings.setValue("regexp", m_regexp ? 1 : 0);			//	K\IvVłɕۑ
	settings.setValue("ignoreCase", m_ignoreCase ? 1 : 0);
	settings.setValue("wordSearch", m_wordSearch ? 1 : 0);
}
void Settings::addReplaceString(const QString &text)
{
	int ix = m_replaceStringList.indexOf(text);
	if( ix >= 0 )
		m_replaceStringList.removeAt(ix);
	m_replaceStringList.push_front(text);
	while( m_replaceStringList.size() > N_FIND_STRINGS )
		m_replaceStringList.removeLast();
	QSettings settings;
	settings.setValue("replaceStrings", m_replaceStringList);
}
