#ifndef REPLACEDLG_H
#define REPLACEDLG_H

#include <QDialog>

class EditView;
class Settings;
class QComboBox;
class QCheckBox;

class ReplaceDlg : public QDialog
{
	Q_OBJECT

public:
	ReplaceDlg(EditView *, Settings *, QWidget *parent = 0);
	~ReplaceDlg();

public:
	void	setView(EditView *view) { m_view = view; }

protected:
	bool	doFind(bool backward);
	void	addFindString(const QString &);

protected slots:
	bool	findForward();
	bool	findBackward();
	void	replaceNext();
	void	regexpToggled(bool);

signals:
	void	undo();
	void	redo();
	void	showMessage(const QString &);

private:
	EditView	*m_view;
	Settings	*m_settings;
	QComboBox	*m_findStrCombo;
	QComboBox	*m_replaceToCombo;
	QComboBox	*m_ignoreCaseCombo;
	QCheckBox	*m_regexpCheck;
	QCheckBox	*m_wordSearchCheck;
};

#endif // REPLACEDLG_H
