/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include "ErrorOutput.h"
#include "ErrorSyntaxHighlighter.h"

ErrorOutput::ErrorOutput(QWidget *parent)
	: QTextEdit(parent)
{
	m_clearFlag = false;
	//m_currentLineNum = 0;
	QPalette plt = palette();
	plt.setColor(QPalette::Highlight, QColor("lemonchiffon"));
	plt.setColor(QPalette::HighlightedText, Qt::black);
	setPalette(plt);

	m_errorSyntaxHighliter = new ErrorSyntaxHighlighter(this);

	connect(document(), SIGNAL(contentsChange(int, int, int)), this, SLOT(contentsChange(int, int int)));
}

ErrorOutput::~ErrorOutput()
{

}
void ErrorOutput::contentsChange(int /*pos*/, int /*remove*/, int /*add*/)
{
}
void ErrorOutput::mousePressEvent ( QMouseEvent * e )
{
	QTextEdit::mousePressEvent(e);
}
void ErrorOutput::mouseDoubleClickEvent ( QMouseEvent * e )
{
	QTextEdit::mouseDoubleClickEvent(e);
	QTextCursor cur = textCursor();
	QTextBlock block = cur.block();
	QString path;
	int errLineNum;
	if( getErrorLineAndPath(block, errLineNum, path) ) {
		emit jumpToLine(errLineNum, path);
	}
}
bool ErrorOutput::getErrorLineAndPath(const QTextBlock &block,
										int &errLineNum, QString &path)
{
	QString blockText = block.text();
	QRegExp exp(":(\\d+)(:.+)?$");
	int ix = exp.indexIn(blockText);
	if( ix < 0 ) return false;
	errLineNum = exp.capturedTexts()[1].toInt();	//	[0] ͑ŚA[1] ͍ŏ̕v񁁐l
	//errLineNum = blockText.mid(ix + 1, exp.matchedLength() - 2).toInt();
	path = blockText.left(ix);
	if( path.startsWith("\tfrom ") )
		path = path.mid(strlen("\tfrom "));
	QTextCursor cur = textCursor();
	cur.setPosition(block.position());
	cur.movePosition(QTextCursor::EndOfLine, QTextCursor::KeepAnchor);
	setTextCursor(cur);
	return true;
}
void ErrorOutput::jumpToNextErrorLine()
{
	QTextCursor cur = textCursor();
	QTextBlock block = cur.block();
	QString path;
	int errLineNum;
	for(;;) {
		block = block.next();
		if( !block.isValid() ) break;
		if( getErrorLineAndPath(block, errLineNum, path) ) {
			emit jumpToLine(errLineNum, path);
			return;
		}
	}
	block = document()->begin();
	do {
		if( getErrorLineAndPath(block, errLineNum, path) ) {
			emit jumpToLine(errLineNum, path);
			return;
		}
		block = block.next();
	} while( block.isValid() );
}
void ErrorOutput::appendText(const QString &text)
{
	QTextCursor cur = textCursor();
	if( m_clearFlag ) {
		m_clearFlag = false;
		cur.select(QTextCursor::Document);
	} else
		cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	setTextCursor(cur);
	QStringList lst = text.split("\n");
	QRegExp exp("must be CONSTANT$");
	foreach(QString lineText, lst) {
		if( !m_currentFileName.isEmpty() && lineText.startsWith(m_currentFileName) )
			lineText = lineText.mid(m_currentFileName.length());
#ifdef Q_CC_MSVC
		if( exp.indexIn(lineText) >= 0 ) {
			lineText += QString::fromWCharArray(L"ip啶Ŏn܂pgpĂˁBFHogej");
		}
#endif
		cur.insertText(lineText + "\n");
	}
	//cur.insertText(text);
}
