/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include "ErrorSyntaxHighlighter.h"
#include "ErrorOutput.h"
#include <QTextDocument>
#include <QTextEdit>

ErrorSyntaxHighlighter::ErrorSyntaxHighlighter(ErrorOutput *parent)
	: QSyntaxHighlighter(parent)
{
	init();
}

ErrorSyntaxHighlighter::~ErrorSyntaxHighlighter()
{
}
void ErrorSyntaxHighlighter::init()
{
	m_openQuoteExp = QRegExp("[\"`']");
	m_quotationExp = QRegExp("\"[^\"]+\"");
	m_quotationExp2 = QRegExp("[`'][^']+'");

    m_quotationFormat.setForeground(QColor("red"));
}
void ErrorSyntaxHighlighter::highlightBlock ( const QString & text )
{
	int ix = 0;
	int k;
	while( (ix = m_openQuoteExp.indexIn(text, ix)) >= 0 ) {
		if( (k = m_quotationExp.indexIn(text, ix)) >= 0 ) {
			int len = m_quotationExp.matchedLength();
			setFormat(k, len, m_quotationFormat);
			ix = k + len;
		} else if( (k = m_quotationExp2.indexIn(text, ix)) >= 0 ) {
			int len = m_quotationExp2.matchedLength();
			setFormat(k, len, m_quotationFormat);
			ix = k + len;
		} else
			++ix;
	}
}
