//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QtGui>
#include <QtNetwork>
//#include <QTextBrowse>
//#include <QClipBoard>

#include "ver.h"
#include "mainwindow.h"
#include "EditView.h"
#include "RubyProcess.h"
#include "charEncoding.h"
#include "SettingsDlg.h"
#include "Settings.h"
#include "ReplaceDlg.h"
#include "ErrorOutput.h"
#include "OutlineBar.h"
#include "FileSystemView.h"
#include "SortFilterProxyModel.h"
#include "StartPage.h"
#include "StartPage2.h"
#include "JumpLineNumberDlg.h"

#define		CHECK_SYNTAX_INTERVAL		200
#define		KEY_RECENTFILELIST			"recentFileList"
#define		KEY_RECENTDIRLIST			"recentDirList"
#define		URL_SF_RELEASE				"http://sourceforge.jp/projects/ruviedit/releases/"
#define		URL_INFO					"http://vivi.dyndns.org/RuviEdit/info.php"

#if 0
const uchar imgData[] = {
	0x0e, 0xf0,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x01, 0x00,
	0x0e, 0xf0,
};
const uchar imgMask[] = {
	0x0f, 0xf0,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x01, 0x80,
	0x0f, 0xf0,
};
#endif

QHash<QString, uint> g_cmdStatistics;
void incCmdStatistics(const QString &keyText)
{
	if( keyText.isEmpty() ) return;
	if( g_cmdStatistics.find(keyText) == g_cmdStatistics.end() ) {
		g_cmdStatistics.insert(keyText, 1);
	} else {
		g_cmdStatistics[keyText] += 1;
	}
}

MainWindow::MainWindow(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	init();
}
MainWindow::MainWindow(const QStringList &fileNames, QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	init();
	foreach(const QString fileName, fileNames)
		loadFile(fileName);
}

void MainWindow::init()
{
	QSettings settings;
	QStringList lst = settings.value("cmdStatistics").toStringList();
	foreach(const QString &text, lst) {
		QStringList kv = text.split(":");
		if( kv.size() == 2 )
			g_cmdStatistics.insert(kv[0], (uint)kv[1].toInt());
	}
	setAcceptDrops(true);
	m_settings = new Settings();
	m_loading = false;
	m_running = false;
	//m_docModified = false;
	m_toTerminate = false;
	m_replaceDlg = 0;
	m_tempFile = 0;
	m_docNumber = 0;
	setAcceptDrops(true);
	m_tabWidget = new QTabWidget;
	m_tabWidget->setMovable(true);
	m_tabWidget->setTabsClosable(true);
	connect(m_tabWidget, SIGNAL(tabCloseRequested(int)), this, SLOT(tabCloseRequested(int)));
	connect(m_tabWidget, SIGNAL(currentChanged(int)), this, SLOT(onTabChanged(int)));
	setCentralWidget(m_tabWidget);
	m_startPage = 0;
	m_process = new RubyProcess();
	connect(this, SIGNAL(startRuby(const QStringList &)), m_process, SLOT(startRuby(const QStringList &)));
	connect(this, SIGNAL(writeToRuby(const QString &)), m_process, SLOT(writeToRuby(const QString &)));
	connect(m_process, SIGNAL(finished()), this, SLOT(onFinished()));
	//connect(m_process, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(onFinished(int, QProcess::ExitStatus)));
	connect(m_process, SIGNAL(readyReadStandardOutput()), this, SLOT(onReadyRead()));
	connect(m_process, SIGNAL(readyReadStandardError()), this, SLOT(onReadyReadError()));

#if 0	//	܂Ȃ 12/04/13
	//	ACr[J[\
	QPixmap curData = QPixmap::fromImage(QImage(imgData, 16, 16, QImage::Format_Mono));
	QPixmap curMask = QPixmap::fromImage(QImage(imgMask, 16, 16, QImage::Format_Mono));
	m_ibCursor = new QCursor(curData, curMask, 8, 8);
#endif


	createActions();
	createDockWindows();
	createMenus();			//	DockWidget ANVǉ̂ŁAcreateDockWindows ̌ɃR[邱
	createToolBars();
    readSettings();			//	createActions() ̌ɃR[邱
    //connect(m_browserBackAct, SIGNAL(triggered()), m_browser, SLOT(backward()));
    connect(m_outlineBar, SIGNAL(viewActivated(EditView *, int)), this, SLOT(activateView(EditView *, int)));
    connect(m_outlineBar, SIGNAL(closeView(EditView *)), this, SLOT(close(EditView *)));
    connect(m_outlineBar, SIGNAL(dirActivated(const QString &)), this, SLOT(openDir(const QString &)));
    //connect(m_outlineBar, SIGNAL(setFocusCurrentView()), this, SLOT(setFocusCurrentView()));
    setWindowTitle(QString("RuviEdit version %1").arg(VERSION_STR));

	//newFile();
	m_networkAccessManager = new QNetworkAccessManager(this);
	connect(m_networkAccessManager, SIGNAL(finished(QNetworkReply*)),
			this, SLOT(replyFinished(QNetworkReply*)));
	//m_networkAccessManager->get(QNetworkRequest(QUrl("http://sourceforge.jp/projects/ruviedit/releases/")));
	newStartPage();

	m_timer = new QTimer;
	connect(m_timer, SIGNAL(timeout()), this, SLOT(onTimer()));
	m_timer->start(CHECK_SYNTAX_INTERVAL);
	statusBar()->showMessage(tr("Ready"));

	m_thread = new QThread;
	m_thread->start();
	m_process->moveToThread(m_thread);

	m_tabWidget->widget(0)->setFocus();

	incCmdStatistics("System.start");		//	vǂݎɃR[邱
}

MainWindow::~MainWindow()
{
	saveCmdStatistics();
	delete m_settings;
}
void MainWindow::saveCmdStatistics()
{
	QStringList lst;
	QHash<QString, uint>::const_iterator itr = g_cmdStatistics.begin();
	while( itr != g_cmdStatistics.end() ) {
		lst << QString("%1:%2").arg(itr.key()).arg(itr.value());
		++itr;
	}
	QSettings settings;
	settings.setValue("cmdStatistics", lst);
}
EditView *MainWindow::createView()
{
	EditView *view = new EditView(m_settings);
	QFont font(m_settings->m_fontFamily, m_settings->m_fontSize);
	view->setFont(font);
	view->onSettingsChanged();
	connect(view, SIGNAL(contentsChanged()), this, SLOT(onContentsChanged()));
	connect(view, SIGNAL(modificationChanged(bool)), this, SLOT(onModificationChanged(bool)));
	connect(view, SIGNAL(encodingChanged()), this, SLOT(onEncodingChanged()));
	connect(view, SIGNAL(showMessage(const QString &)), this, SLOT(showMessage(const QString &)));
	connect(view, SIGNAL(doOutput(const QString &)), this, SLOT(doOutput(const QString &)));
	connect(view, SIGNAL(toClose(EditView *)), m_outlineBar, SLOT(removeView(EditView *)));
	connect(view, SIGNAL(focusIn()), this, SLOT(viewFocusIn()));
	connect(view, SIGNAL(focusOut()), this, SLOT(viewFocusOut()));
	view->installEventFilter(this);
	connect(view->document(), SIGNAL(undoAvailable(bool)), this, SLOT(undoAvailable(bool)));
	connect(view->document(), SIGNAL(redoAvailable(bool)), this, SLOT(redoAvailable(bool)));
	///view->setCursor(*m_ibCursor);
	view->setModifiedAfterCompile(false);	//	fBt@CtOOFF
	return view;
}
void MainWindow::createActions()
{
	//	t@C֘A
    m_newAct = new QAction(QIcon(":MainWindow/Resources/new.png"), tr("&New"), this);
    m_newAct->setShortcuts(QKeySequence::New);
    m_newAct->setStatusTip(tr("Create a new document"));
    m_newAct->setToolTip(tr("New (Ctrl + N)"));
    connect(m_newAct, SIGNAL(triggered()), this, SLOT(newFile()));

    m_openAct = new QAction(QIcon(":MainWindow/Resources/open.png"), tr("&Open..."), this);
    m_openAct->setShortcuts(QKeySequence::Open);
    m_openAct->setStatusTip(tr("Open an existing file"));
    m_openAct->setToolTip(tr("Open (Ctrl + O)"));
    connect(m_openAct, SIGNAL(triggered()), this, SLOT(open()));

    m_saveAct = new QAction(QIcon(":MainWindow/Resources/save.png"), tr("&Save"), this);
    m_saveAct->setShortcuts(QKeySequence::Save);
    m_saveAct->setStatusTip(tr("Save to file"));
    m_saveAct->setToolTip(tr("Save (Ctrl + S)"));
    connect(m_saveAct, SIGNAL(triggered()), this, SLOT(save()));

    m_saveAsAct = new QAction(tr("Save&As..."), this);
    m_saveAsAct->setShortcuts(QKeySequence::SaveAs);
    m_saveAsAct->setStatusTip(tr("Save the file under a new fileName"));
    connect(m_saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));

    //	RecentFilesMenu ̂߂̏
    for (int i = 0; i < MaxRecentFiles; ++i) {
        m_recentFileActs[i] = new QAction(this);
        m_recentFileActs[i]->setVisible(false);
        connect(m_recentFileActs[i], SIGNAL(triggered()), this, SLOT(openRecentFile()));
    }
    for (int i = 0; i < MaxFavoriteFiles; ++i) {
        m_favoriteFileActs[i] = new QAction(this);
        m_favoriteFileActs[i]->setVisible(false);
        connect(m_favoriteFileActs[i], SIGNAL(triggered()), this, SLOT(openRecentFile()));
    }
    for (int i = 0; i < MaxRecentDirs; ++i) {
        m_recentDirActs[i] = new QAction(this);
        m_recentDirActs[i]->setVisible(false);
        connect(m_recentDirActs[i], SIGNAL(triggered()), this, SLOT(openFromRecentDir()));
        m_recentFileSystemActs[i] = new QAction(this);
        m_recentFileSystemActs[i]->setVisible(false);
        connect(m_recentFileSystemActs[i], SIGNAL(triggered()), this, SLOT(openRecentFileSystem()));
    }

    m_closeAct = new QAction(tr("&CloseCurDoc"), this);
    m_closeAct->setShortcuts(QKeySequence::Close);
    m_closeAct->setStatusTip(tr("close current document"));
    connect(m_closeAct, SIGNAL(triggered()), this, SLOT(closeThisDocument()));
    m_closeAllAct = new QAction(tr("C&loseAll"), this);
    m_closeAllAct->setStatusTip(tr("close all document"));
    connect(m_closeAllAct, SIGNAL(triggered()), this, SLOT(closeAll()));

    m_exitAct = new QAction(tr("e&Xit"), this);
    m_exitAct->setShortcuts(QKeySequence::Quit);
    //m_exitAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_F4));	//	Mac ł͕s
    m_exitAct->setStatusTip(tr("close all files and exit"));
    connect(m_exitAct, SIGNAL(triggered()), qApp, SLOT(quit()));

    m_encUTF8Act = new QAction(tr("UTF&8"), this);
    m_encUTF8Act->setData(CharEncoding::UTF8);
    m_encUTF8Act->setCheckable(true);
    connect(m_encUTF8Act, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encUTF16LEAct = new QAction(tr("UTF16&LE"), this);
    m_encUTF16LEAct->setData(CharEncoding::UTF16_LE);
    m_encUTF16LEAct->setCheckable(true);
    connect(m_encUTF16LEAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encUTF16BEAct = new QAction(tr("UTF16&BE"), this);
    m_encUTF16BEAct->setData(CharEncoding::UTF16_BE);
    m_encUTF16BEAct->setCheckable(true);
    connect(m_encUTF16BEAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encSJISAct = new QAction(tr("&SJIS"), this);
    m_encSJISAct->setData(CharEncoding::SJIS);
    m_encSJISAct->setCheckable(true);
    connect(m_encSJISAct, SIGNAL(triggered()), this, SLOT(setEncoding()));
    m_encEUCAct = new QAction(tr("&EUC"), this);
    m_encEUCAct->setData(CharEncoding::EUC);
    m_encEUCAct->setCheckable(true);
    connect(m_encEUCAct, SIGNAL(triggered()), this, SLOT(setEncoding()));

    //	Ruby
	m_runAct = new QAction(QIcon(":MainWindow/Resources/Play.png"), tr("&Run"), this);
	m_runAct->setShortcut(QKeySequence(Qt::Key_F5));
    m_runAct->setStatusTip(tr("Run Ruby interpreter"));
    m_runAct->setToolTip(tr("Run (F5)"));
	connect(m_runAct, SIGNAL(triggered()), this, SLOT(run()));
	m_stopAct = new QAction(QIcon(":MainWindow/Resources/Stop.png"), tr("&Stop"), this);
	m_stopAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F5));
    m_stopAct->setStatusTip(tr("Stop running Ruby interpreter"));
    m_stopAct->setToolTip(tr("Stop (Shifr + F5)"));
	connect(m_stopAct, SIGNAL(triggered()), this, SLOT(stop()));
	m_checkSyntaxAct = new QAction(QIcon(":MainWindow/Resources/Check.png"), tr("&CheckSyntax"), this);
	m_checkSyntaxAct->setShortcut(QKeySequence(Qt::Key_F7));
    m_checkSyntaxAct->setStatusTip(tr("Check Syntax of source code"));
    m_checkSyntaxAct->setToolTip(tr("CheckSyntax (F7)"));
	connect(m_checkSyntaxAct, SIGNAL(triggered()), this, SLOT(checkSyntax()));
	m_jumpToErrorLineAct = new QAction(tr("JumpTo&ErrorLine"), this);
	m_jumpToErrorLineAct->setShortcut(QKeySequence(Qt::Key_F4));
    m_jumpToErrorLineAct->setStatusTip(tr("jump to error line"));
	connect(m_jumpToErrorLineAct, SIGNAL(triggered()), this, SLOT(jumpToErrorLine()));

	//	ҏW
	m_undoAct = new QAction(QIcon(":MainWindow/Resources/undo.png"), tr("&Undo"), this);
    m_undoAct->setShortcuts(QKeySequence::Undo);
    m_undoAct->setStatusTip(tr("undo edit command"));
	m_undoAct->setEnabled(false);
    connect(m_undoAct, SIGNAL(triggered()), this, SLOT(undo()));
    ///connect(this, SIGNAL(canUndoChanged(bool)), m_undoAct, SLOT(setEnabled(bool)));

	m_redoAct = new QAction(QIcon(":MainWindow/Resources/redo.png"), tr("&Redo"), this);
    m_redoAct->setShortcuts(QKeySequence::Redo);
    //m_redoAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_R));
    m_redoAct->setStatusTip(tr("redo edit commande"));
	m_redoAct->setEnabled(false);
    connect(m_redoAct, SIGNAL(triggered()), this, SLOT(redo()));
    ///connect(this, SIGNAL(canRedoChanged(bool)), m_redoAct, SLOT(setEnabled(bool)));

    m_cutAct = new QAction(QIcon(":MainWindow/Resources/cut.png"), tr("Cu&t"), this);
    m_cutAct->setShortcuts(QKeySequence::Cut);
    m_cutAct->setStatusTip(tr("Cut the current selection's contents to the clipboard"));
    m_cutAct->setToolTip(tr("Cut (Ctrl + X)"));
    connect(m_cutAct, SIGNAL(triggered()), this, SLOT(cut()));

    m_copyAct = new QAction(QIcon(":MainWindow/Resources/copy.png"), tr("&Copy"), this);
    m_copyAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_C));
    //m_copyAct->setShortcuts(QKeySequence::Copy);
    m_copyAct->setStatusTip(tr("Copy the current selection's contents to the clipboard"));
    m_copyAct->setToolTip(tr("Copy (Ctrl + C)"));
    connect(m_copyAct, SIGNAL(triggered()), this, SLOT(copy()));

    m_pasteAct = new QAction(QIcon(":MainWindow/Resources/paste.png"), tr("&Paste"), this);
    m_pasteAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_V));
    m_pasteAct->setStatusTip(tr("Paste the clipboard's contents into the current selection"));
    m_pasteAct->setToolTip(tr("Paste (Ctrl + V)"));
    connect(m_pasteAct, SIGNAL(triggered()), this, SLOT(paste()));
    m_replaceAct = new QAction(QIcon(":/MainWindow/Resources/Search.png"), tr("&Find/Replace..."), this);
    m_replaceAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F));
    m_replaceAct->setToolTip(tr("Find/Replace (Ctrl + F)..."));
    m_replaceAct->setStatusTip(tr("Find and/or Replace text"));
    connect(m_replaceAct, SIGNAL(triggered()), this, SLOT(replace()));

    m_selectAllAct = new QAction(tr("select&All"), this);
    m_selectAllAct->setShortcuts(QKeySequence::SelectAll);
    m_selectAllAct->setStatusTip(tr("select All text"));
    connect(m_selectAllAct, SIGNAL(triggered()), this, SLOT(selectAll()));

    m_openLineAboveAct = new QAction(tr("&OpenLineAbove"), this);
    m_openLineAboveAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Return));
    m_openLineAboveAct->setStatusTip(tr("Open a new line above"));
    connect(m_openLineAboveAct, SIGNAL(triggered()), this, SLOT(openLineAbove()));
    m_openLineBelowAct = new QAction(tr("OpenLine&Below"), this);
    m_openLineBelowAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Return));
    m_openLineBelowAct->setStatusTip(tr("Open a new line below"));
    connect(m_openLineBelowAct, SIGNAL(triggered()), this, SLOT(openLineBelow()));
    m_unIndentAct = new QAction(tr("&UnIndent"), this);
    m_unIndentAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Tab));
    //m_unIndentAct->setStatusTip(tr("Open a new line above"));
    connect(m_unIndentAct, SIGNAL(triggered()), this, SLOT(unIndent()));
    m_enCommentAct = new QAction(tr("&EnComment"), this);
    m_enCommentAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Equal));
    m_enCommentAct->setStatusTip(tr("comment out selected lines"));
    connect(m_enCommentAct, SIGNAL(triggered()), this, SLOT(enComment()));
    m_completionAct = new QAction(tr("&WordCompletion"), this);
    m_completionAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_L));
    m_completionAct->setStatusTip(tr("word completion"));
    connect(m_completionAct, SIGNAL(triggered()), this, SLOT(completion()));
    m_keywordCompletionAct = new QAction(tr("&KeywordCompletion"), this);
    m_keywordCompletionAct->setEnabled(false);
    m_keywordCompletionAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_K));
    m_keywordCompletionAct->setStatusTip(tr("keyword completion"));
    connect(m_keywordCompletionAct, SIGNAL(triggered()), this, SLOT(keywordCompletion()));

    m_findWordAtCursorAct = new QAction(tr("Find&Word"), this);
    m_findWordAtCursorAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F3));
    connect(m_findWordAtCursorAct, SIGNAL(triggered()), this, SLOT(findWordAtCursor()));

    m_findNextAct = new QAction(tr("Find&Next"), this);
    m_findNextAct->setShortcut(QKeySequence(Qt::Key_F3));
    connect(m_findNextAct, SIGNAL(triggered()), this, SLOT(findNext()));

    m_findPrevAct = new QAction(tr("Find&Prev"), this);
    m_findPrevAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F3));
    connect(m_findPrevAct, SIGNAL(triggered()), this, SLOT(findPrev()));

    m_tagJumpAct = new QAction(tr("&TagJump"), this);
    m_tagJumpAct->setShortcut(QKeySequence(Qt::Key_F9));
    connect(m_tagJumpAct, SIGNAL(triggered()), this, SLOT(tagJump()));
    m_gotoMatchedParenAct = new QAction(tr("&MatchedParen"), this);
    m_gotoMatchedParenAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_BracketRight));	//	^]
    connect(m_gotoMatchedParenAct, SIGNAL(triggered()), this, SLOT(gotoMatchedParen()));
    m_jumpLineNumberAct = new QAction(tr("Jump&LineNumber"), this);
    m_jumpLineNumberAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_G));	//	^]
    connect(m_jumpLineNumberAct, SIGNAL(triggered()), this, SLOT(jumpLineNumber()));

	m_viewLineNumberAct = new QAction(tr("&LineNumber"), this);
    m_viewLineNumberAct->setStatusTip(tr("draw lineNumber mode ON/OFF"));
    m_viewLineNumberAct->setCheckable(true);
	connect(m_viewLineNumberAct, SIGNAL(toggled(bool)), this, SLOT(viewLineNumber(bool)));
	m_viewStartPageAct = new QAction(tr("&StartPage"), this);
    m_viewStartPageAct->setStatusTip(tr("view Start page"));
	connect(m_viewStartPageAct, SIGNAL(triggered()), this, SLOT(newStartPage()));

    m_nextTabDocAct = new QAction(tr("&NextTab"), this);
    m_nextTabDocAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Tab));
    connect(m_nextTabDocAct, SIGNAL(triggered()), this, SLOT(nextTabDoc()));
    m_prevTabDocAct = new QAction(tr("&PrevTab"), this);
    m_prevTabDocAct->setShortcut(QKeySequence(Qt::CTRL + Qt::SHIFT + Qt::Key_Tab));
    connect(m_prevTabDocAct, SIGNAL(triggered()), this, SLOT(prevTabDoc()));
    m_previousDocAct = new QAction(tr("&PreviousDoc"), this);
    m_previousDocAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_AsciiCircum));		//	^
    connect(m_previousDocAct, SIGNAL(triggered()), this, SLOT(previousDoc()));
    m_outlineBarAct = new QAction(tr("&OutlineBar"), this);
    m_outlineBarAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_I));		//	^I
    connect(m_outlineBarAct, SIGNAL(triggered()), this, SLOT(outlineBar()));
    m_fileSytemAct = new QAction(tr("&FileSystem"), this);
    m_fileSytemAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_D));		//	^D
    connect(m_fileSytemAct, SIGNAL(triggered()), this, SLOT(fileSystem()));

    m_browserBackAct = new QAction(tr("&Back"), this);
    //m_browserBackAct->setStatusTip(tr("close all files and exit"));
    //connect(m_browserBackAct, SIGNAL(triggered()), this, SLOT(browserBack()));


    m_settingsAct = new QAction(QIcon(":MainWindow/Resources/settings.png"), tr("&Settings..."), this);
    m_settingsAct->setShortcut(QKeySequence(Qt::Key_F8));
    m_settingsAct->setStatusTip(tr("refer and/or modify Settings"));
    m_settingsAct->setToolTip(tr("Settings... (F8)"));
    connect(m_settingsAct, SIGNAL(triggered()), this, SLOT(doSettings()));

    m_aboutAct = new QAction(QIcon(":MainWindow/Resources/Information.png"), tr("&AboutRuviEdit..."), this);
    m_aboutAct->setStatusTip(tr("about dialog"));
    connect(m_aboutAct, SIGNAL(triggered()), this, SLOT(about()));

    m_helpAct = new QAction(tr("&Help"), this);
    m_helpAct->setStatusTip(tr("show help"));
    connect(m_helpAct, SIGNAL(triggered()), this, SLOT(help()));
    m_sourceCodeAct = new QAction(tr("Source&Code"), this);
    m_sourceCodeAct->setStatusTip(tr("brows RuviEdit sourece code page"));
    connect(m_sourceCodeAct, SIGNAL(triggered()), this, SLOT(sourceCode()));
    m_cmdStatisticsAct = new QAction(tr("commandS&tatistics"), this);
    m_cmdStatisticsAct->setStatusTip(tr("show command statistics"));
    connect(m_cmdStatisticsAct, SIGNAL(triggered()), this, SLOT(cmdStatistics()));

}
void MainWindow::createMenus()
{
    QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(m_newAct);
    fileMenu->addAction(m_openAct);
    fileMenu->addAction(m_saveAct);
    fileMenu->addAction(m_saveAsAct);
    m_encMenu = fileMenu->addMenu(tr("&Encoding of this doc"));
    m_encMenu->addAction(m_encUTF8Act);
    m_encMenu->addAction(m_encUTF16LEAct);
    m_encMenu->addAction(m_encUTF16BEAct);
    m_encMenu->addAction(m_encSJISAct);
    m_encMenu->addAction(m_encEUCAct);
    fileMenu->addAction(m_closeAct);
    fileMenu->addAction(m_closeAllAct);
    fileMenu->addSeparator();
    //	RecentFilesMenu ACeǉ
    QMenu *MRU = fileMenu->addMenu(tr("RecentFiles(&1)"));
    for (int i = 0; i < MaxRecentFiles; ++i)
        MRU->addAction(m_recentFileActs[i]);
    updateRecentFileActions();
    //	RecentDirMenu ACeǉ
    QMenu *MRUDir = fileMenu->addMenu(tr("OpenFromRecentDirs(&2)"));
    for (int i = 0; i < MaxRecentDirs; ++i) {
        MRUDir->addAction(m_recentDirActs[i]);
    }
    QMenu *MRUFileSystem = fileMenu->addMenu(tr("OpenRecentFileSystem(&3)"));
    for (int i = 0; i < MaxRecentDirs; ++i) {
        MRUFileSystem->addAction(m_recentFileSystemActs[i]);
    }
    updateRecentDirActions();
    fileMenu->addSeparator();
    fileMenu->addAction(m_exitAct);

    QMenu *editMenu = menuBar()->addMenu(tr("&Edit"));
    editMenu->addAction(m_undoAct);
    editMenu->addAction(m_redoAct);
    editMenu->addAction(m_cutAct);
    editMenu->addAction(m_copyAct);
    editMenu->addAction(m_pasteAct);
    editMenu->addAction(m_selectAllAct);
    editMenu->addSeparator();
    editMenu->addAction(m_openLineAboveAct);
    editMenu->addAction(m_openLineBelowAct);
    editMenu->addAction(m_unIndentAct);
    editMenu->addAction(m_enCommentAct);
    editMenu->addAction(m_keywordCompletionAct);
    editMenu->addAction(m_completionAct);
    editMenu->addSeparator();
    editMenu->addAction(m_replaceAct);
    editMenu->addAction(m_findWordAtCursorAct);
    editMenu->addAction(m_findNextAct);
    editMenu->addAction(m_findPrevAct);
    editMenu->addAction(m_tagJumpAct);
    editMenu->addAction(m_gotoMatchedParenAct);
    editMenu->addAction(m_jumpLineNumberAct);

    QMenu *rubyMenu = menuBar()->addMenu(tr("&Ruby"));
    rubyMenu->addAction(m_runAct);
    rubyMenu->addAction(m_stopAct);
    rubyMenu->addAction(m_checkSyntaxAct);
    rubyMenu->addAction(m_jumpToErrorLineAct);

    QMenu *viewMenu = menuBar()->addMenu(tr("&View"));
    viewMenu->addAction(m_viewLineNumberAct);
    viewMenu->addAction(m_viewStartPageAct);
    //QMenu *toolBarMenu = viewMenu->addMenu(tr("ToolBar"));
    QMenu *dockMenu = viewMenu->addMenu(tr("DockWidget"));
	dockMenu->addAction(qobject_cast<QDockWidget *>(m_output->parentWidget())->toggleViewAction());
	dockMenu->addAction(qobject_cast<QDockWidget *>(m_outputError->parentWidget())->toggleViewAction());
	dockMenu->addAction(qobject_cast<QDockWidget *>(m_outlineBar->parentWidget())->toggleViewAction());
	dockMenu->addAction(qobject_cast<QDockWidget *>(m_fileSystemView->parentWidget())->toggleViewAction());

    QMenu *windowMenu = menuBar()->addMenu(tr("&Window"));
    windowMenu->addAction(m_nextTabDocAct);
    windowMenu->addAction(m_prevTabDocAct);
    windowMenu->addAction(m_previousDocAct);
    windowMenu->addAction(m_outlineBarAct);
    windowMenu->addAction(m_fileSytemAct);

    QMenu *otherMenu = menuBar()->addMenu(tr("&Other"));
    otherMenu->addAction(m_settingsAct);
    otherMenu->addAction(m_helpAct);
    otherMenu->addAction(m_sourceCodeAct);
    otherMenu->addAction(m_cmdStatisticsAct);
    otherMenu->addAction(m_aboutAct);
    //otherMenu->addAction(m_browserBackAct);
}
void MainWindow::createToolBars()
{
    QToolBar *fileToolBar = addToolBar(tr("File"));
    fileToolBar->setObjectName("File");
    fileToolBar->addAction(m_newAct);
    fileToolBar->addAction(m_openAct);
    fileToolBar->addAction(m_saveAct);

    QToolBar *rubyToolBar = addToolBar(tr("Ruby"));
    rubyToolBar->setObjectName("Ruby");
    rubyToolBar->addWidget(new QLabel(tr("Arg:")));
    rubyToolBar->addWidget(m_argText = new QLineEdit());
    rubyToolBar->addAction(m_runAct);
    rubyToolBar->addAction(m_stopAct);
    rubyToolBar->addAction(m_checkSyntaxAct);

    QToolBar *editToolBar = addToolBar(tr("Edit"));
    editToolBar->setObjectName("Edit");
    editToolBar->addAction(m_undoAct);
    editToolBar->addAction(m_redoAct);
    editToolBar->addAction(m_cutAct);
    editToolBar->addAction(m_copyAct);
    editToolBar->addAction(m_pasteAct);
    editToolBar->addAction(m_replaceAct);

    QToolBar *otherToolBar = addToolBar(tr("Other"));
    otherToolBar->setObjectName("Other");
    otherToolBar->addAction(m_settingsAct);
    otherToolBar->addAction(m_aboutAct);
}
void MainWindow::createDockWindows()
{
	QDockWidget *dock;
	dock = new QDockWidget(tr("Output"));
	dock->setWidget(m_output = new QPlainTextEdit());
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::BottomDockWidgetArea, dock);

	dock = new QDockWidget(tr("Error"));
	dock->setWidget(m_outputError = new ErrorOutput());
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::BottomDockWidgetArea, dock);
	//m_outputError->installEventFilter(this);
	connect(m_outputError, SIGNAL(jumpToLine(int, QString)), this, SLOT(jumpToLine(int, QString)));

	dock = new QDockWidget(tr("Outline"));
	dock->setWidget(m_outlineBar = new OutlineBar);
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::LeftDockWidgetArea, dock);

	QDockWidget *dock2 = new QDockWidget(tr("FileSystem"));
	dock2->setWidget(m_fileSystemView = new FileSystemView(this));
	m_dirModel = new QFileSystemModel;
	m_fileSystemView->setModel(m_dirModel);
	//m_dirModel->setFilter(QDir::NoDotAndDotDot | QDir::Dirs);
	m_dirModel->setRootPath("/");
	m_fileSystemView->setCurrentIndex(m_dirModel->index(0,0));
	//QAbstractItemView::SelectionMode mode = m_fileSystemView->selectionMode();
	//QModelIndex index = m_dirModel->index("C:/");
	//if( index.isValid() )
	//	m_fileSystemView->setCurrentIndex(index);
	m_proxyModel = new SortFilterProxyModel(this);
	m_proxyModel->setSourceModel(m_dirModel);
	//m_dirModel->setRootPath(m_settings->m_fileSystemRootPath);
	//m_fileSystemView->header()->hide();
	//m_fileSystemView->setRootIndex(m_dirModel->index(QDir::currentPath()));
	m_proxyModel->sort(0, Qt::AscendingOrder);	//	t@CŃ\[g
	//m_fileSystemView->setSortingEnabled(true);
	dock2->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::LeftDockWidgetArea, dock2);
	tabifyDockWidget(dock, dock2);
	//connect(m_fileSystemView, SIGNAL(clicked(const QModelIndex &)),
	//		this, SLOT(setCurrentDir(const QModelIndex &)));
	connect(m_fileSystemView, SIGNAL(openFile(const QString &)),
			this, SLOT(loadFile(const QString &)));
	connect(m_fileSystemView, SIGNAL(expanded(const QModelIndex &)),
			this, SLOT(dirExpanded(const QModelIndex &)));

#if 0
	dock = new QDockWidget(tr("FileView"));
	dock->setWidget(m_fileView = new QTreeView(this));
	m_fileModel = new QFileSystemModel;
	m_fileModel->setFilter(QDir::NoDotAndDotDot | QDir::Files);
	m_fileModel->setRootPath(QDir::currentPath());
	m_fileView->setModel(m_fileModel);
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::LeftDockWidgetArea, dock);
	connect(m_fileView, SIGNAL(doubleClicked(const QModelIndex &)),
			this, SLOT(loadFile(const QModelIndex &)));
#endif
}
void MainWindow::dirExpanded(const QModelIndex &index)
{
	//m_dirModel->sort(0, Qt::AscendingOrder);	//	t@CŃ\[g
	//m_fileSystemView->setRootIndex(index);
	m_dirModel->setRootPath(m_dirModel->filePath(index));
	m_proxyModel->sort(0, Qt::AscendingOrder);	//	t@CŃ\[g
}
void MainWindow::viewFocusIn()
{
	m_keywordCompletionAct->setEnabled(true);
	m_completionAct->setEnabled(true);
}
void MainWindow::viewFocusOut()
{
	m_keywordCompletionAct->setEnabled(false);
	m_completionAct->setEnabled(false);
}
#if 0
void MainWindow::setCurrentDir(const QModelIndex &index)
{
	QString path = m_dirModel->fileInfo(index).absoluteFilePath();
	m_fileView->setRootIndex(m_fileModel->setRootPath(path));
}
#endif
void MainWindow::loadFile(const QModelIndex &index)
{
	QString path = m_fileModel->fileInfo(index).absoluteFilePath();
	loadFile(path);
}

Settings *MainWindow::settings()
{
	return m_settings;
}
void MainWindow::showMessage(const QString &text)
{
	statusBar()->showMessage(text);
}
void MainWindow::onSourceChanged(const QUrl &src)
{
	QString path = src.path();
	statusBar()->showMessage(path, 5000);

#if 0
	QFile file(":" + path);
	if( !file.open(QIODevice::ReadOnly) ) return;
	QByteArray ba = file.readAll();
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	m_browser->setHtml(codec->toUnicode(ba));
#endif
}
void MainWindow::onContentsChanged()
{
    EditView *view = qobject_cast<EditView *>(sender());
    m_outlineBar->onContentsChanged(view);
}
EditView *MainWindow::currentEditView()
{
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view != 0 && view->metaObject()->className() != QString("EditView") )
		view = 0;
	return view;
}
EditView *MainWindow::editView(int ix)
{
	EditView *view = (EditView *)m_tabWidget->widget(ix);
	if( view != 0 && view->metaObject()->className() != QString("EditView") )
		view = 0;
	return view;
}
void MainWindow::setEncoding()
{
	incCmdStatistics("Action.setEncoding");
	EditView *view = currentEditView();
	if( !view ) return;
	uchar enc = (uchar)qobject_cast<QAction *>(sender())->data().toInt();
	view->setCharEncoding(enc);
}
void MainWindow::onEncodingChanged()
{
    EditView *view = qobject_cast<EditView *>(sender());
	int ix = m_tabWidget->indexOf(view);
	if( ix < 0 ) return;
	m_tabWidget->setTabToolTip(ix, view->toolTipText());
	updateEncodingMenuChecked(view->charEncoding());
}
void MainWindow::setFocusCurrentView()
{
	EditView *view = currentEditView();
	if( view )
		view->setFocus();
}
void MainWindow::updateEncodingMenuChecked(uchar enc)
{
	m_encUTF8Act->setChecked(enc == CharEncoding::UTF8);
	m_encUTF16LEAct->setChecked(enc == CharEncoding::UTF16_LE);
	m_encUTF16BEAct->setChecked(enc == CharEncoding::UTF16_BE);
	m_encSJISAct->setChecked(enc == CharEncoding::SJIS);
	m_encEUCAct->setChecked(enc == CharEncoding::EUC);
}
void MainWindow::browserBack()
{
}
void MainWindow::setupStatusBar()
{
}
void MainWindow::writeSettings()
{
	QSettings settings;
	settings.setValue("geometry", saveGeometry());
	settings.setValue("windowState", saveState());
	settings.setValue("fileSystemHeader", m_fileSystemView->header()->saveState());
	m_settings->writeSettings();
}
void MainWindow::readSettings()
{
	QSettings settings;
	restoreGeometry(settings.value("geometry").toByteArray());
	restoreState(settings.value("windowState").toByteArray());
	m_fileSystemView->header()->restoreState(settings.value("fileSystemHeader").toByteArray());
	m_settings->readSettings();
	m_viewLineNumberAct->setChecked(m_settings->m_lineNumber);
}
bool MainWindow::eventFilter ( QObject * obj, QEvent * event )
{
	EditView *view = currentEditView();
	if (obj == view
        && event->type() == QEvent::KeyPress)
	{
		if( !m_running ) {
			QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
			if( keyEvent->key() == Qt::Key_Escape ) {
				view->clearSelection();
				return true;
			}
		}
	}
#if 0
	if (m_running && obj == m_editor 
        && event->type() == QEvent::KeyPress)
	{
		QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
		const QString text = keyEvent->text();
		m_process->writeToRuby(text);
		//emit writeToRuby(text);
		return true;
	}
#endif
#if 0
	//	}EX m_outputError LĂ̂ł܂Ȃ 12/03/25
	if( view != 0 && obj == m_outputError &&
		event->type() == QEvent::MouseButtonDblClick )
	{
		QTextCursor cur = m_outputError->textCursor();
		QTextBlock block = cur.block();
		QString text = block.text();
		QRegExp exp(":\\d+:");
		int ix = exp.indexIn(text);
		if( ix >= 0 ) {
			int lineNum = text.mid(ix + 1, exp.matchedLength() - 2).toInt();
			cur = view->textCursor();
			cur.movePosition(QTextCursor::Start);
			cur.movePosition(QTextCursor::Down, QTextCursor::MoveAnchor, lineNum - 1);
			view->setTextCursor(cur);
			view->setFocus();
			return true;
		}
	}
#endif
	return false;
}
#if 0
void MainWindow::keyPressEvent ( QKeyEvent * event )
{
}
#endif
void MainWindow::onTabChanged(int ix)
{
	m_previousFilePath = m_currentFilePath;
	m_previousFileTitle = m_currentFileTitle;
	EditView *view = 0;
	if( ix < 0 ) {
		m_encMenu->setTitle(QString(tr("encoding of this doc")));
		m_currentFilePath.clear();
		m_currentFileTitle.clear();
	} else {
		view = editView(ix);
		if( view != 0 ) {
			m_currentFilePath = view->fullPath();
			m_currentFileTitle = view->title();
			updateEncodingMenuChecked(view->charEncoding());
			m_encMenu->setTitle(QString(tr("encoding of '%1'")).arg(view->title()));
			m_undoAct->setEnabled(view->document()->isUndoAvailable());
			m_redoAct->setEnabled(view->document()->isRedoAvailable());
			m_outlineBar->selectViewItem(view);
			statusBar()->showMessage(view->toolTipText(), 3000);	//	pXER[h\ i3bԁj
		}
	}
	if( m_replaceDlg )
		m_replaceDlg->setView(view);
}
void MainWindow::activateView(EditView *view, int lineNum)
{
	m_tabWidget->setCurrentWidget(view);
	//int ix = m_tabWidget->IndexOf(view);
	//if( ix >= 0 )
	if( lineNum != 0 )
		view->jumpToLine(lineNum);
}
void MainWindow::doOutput(const QString &text)
{
	QTextCursor cur = m_output->textCursor();
	cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	m_output->setTextCursor(cur);
	cur.insertText(text);
}
void MainWindow::doOutputError(const QString &text)
{
	qobject_cast<QDockWidget *>(m_outputError->parentWidget())->show();
	m_outputError->appendText(text);
#if 0
	QTextCursor cur = m_outputError->textCursor();
	cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	m_outputError->setTextCursor(cur);
	cur.insertText(text);
#endif
}
//	WXg "recentDirList" ɒǉ
void MainWindow::addToRecentDirList(const QString &fullPath)
{
	QDir dir(fullPath);
	dir.cdUp();
	QString dirPath = dir.absolutePath();
    QSettings settings;
    QStringList dirs = settings.value(KEY_RECENTDIRLIST).toStringList();
    dirs.removeAll(dirPath);
    dirs.push_front(dirPath);
    while (dirs.size() > MaxRecentDirs )
        dirs.removeLast();
    settings.setValue(KEY_RECENTDIRLIST, dirs);
}
//	WXg "recentFileList" ɒǉ
void MainWindow::addToRecentFileList(const QString &fullPath)
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTFILELIST).toStringList();
    files.removeAll(fullPath);
    files.push_front(fullPath);
    while (files.size() > MaxRecentFiles)
        files.removeLast();
    settings.setValue(KEY_RECENTFILELIST, files);
}
//	settings  RecentFile oAm_recentFileActs ɐݒ
void MainWindow::updateRecentFileActions()
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTFILELIST).toStringList();
    int numRecentFiles = qMin(files.size(), (int)MaxRecentFiles);
    for (int i = 0; i < numRecentFiles; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_recentFileActs[i]->setText(text);
        m_recentFileActs[i]->setData(files[i]);
        m_recentFileActs[i]->setStatusTip(files[i]);
        m_recentFileActs[i]->setVisible(true);
    }
    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
        m_recentFileActs[j]->setVisible(false);
}
//	settings  RecentDir oAm_recentDirActs ɐݒ
void MainWindow::updateRecentDirActions()
{
    QSettings settings;
    QStringList files = settings.value(KEY_RECENTDIRLIST).toStringList();
    int numRecentDirs = qMin(files.size(), (int)MaxRecentDirs);
    for (int i = 0; i < numRecentDirs; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_recentDirActs[i]->setText(text);
        m_recentDirActs[i]->setData(files[i]);
        m_recentDirActs[i]->setStatusTip(files[i]);
        m_recentDirActs[i]->setVisible(true);
        m_recentFileSystemActs[i]->setText(text);
        m_recentFileSystemActs[i]->setData(files[i]);
        m_recentFileSystemActs[i]->setStatusTip(files[i]);
        m_recentFileSystemActs[i]->setVisible(true);
    }
    for (int j = numRecentDirs; j < MaxRecentDirs; ++j) {
        m_recentDirActs[j]->setVisible(false);
        m_recentFileSystemActs[j]->setVisible(false);
    }
}
void MainWindow::openRecentFile()
{
	incCmdStatistics("Action.openRecentFile");
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        loadFile(action->data().toString());
}
void MainWindow::setFirstDockWidget(QDockWidget *dw)
{
	QList<QDockWidget *> lst = tabifiedDockWidgets(dw);	//	dw ȊÔԂXgAbv
	if( !lst.isEmpty() )
		tabifyDockWidget(dw, lst[0]);
	dw->show();
}
void MainWindow::openRecentFileSystem()
{
	incCmdStatistics("Action.openRecentFileSystem");
    QAction *action = qobject_cast<QAction *>(sender());
    if (action) {
    	QString dirText = action->data().toString();
    	openDir(dirText);
    }
}
void MainWindow::openDir(const QString &dirText)
{
	QFileSystemModel *model = (QFileSystemModel *)m_fileSystemView->model();
	QModelIndex mi = model->index(dirText);
	if( mi.isValid() ) {
		//setFirstDockWidget((QDockWidget *)m_fileSystemView->parentWidget());
		m_fileSystemView->parentWidget()->show();
		m_fileSystemView->parentWidget()->raise();
		QModelIndex pi = mi.parent();
		m_fileSystemView->setCurrentIndex(mi);
		m_fileSystemView->setExpanded(mi, true);
		m_fileSystemView->setFocus();
	}
}
void MainWindow::openFromRecentDir()
{
	incCmdStatistics("Action.openFromRecentDir");
    QAction *action = qobject_cast<QAction *>(sender());
    if (action) {
    	QString dirText = action->data().toString();
    	openFromDir(dirText);
    }
}
void MainWindow::open()
{
	incCmdStatistics("Action.FileOpen");
	EditView *view = currentEditView();
	if( view != 0 )
		view->cdCurrentDir();		//	I[vĂt@C̃fBNgɈړ
	openFromDir("");		//	JgfBNgI[v
}
void MainWindow::openFromDir(const QString &dirText)
{
	QStringList lst = QFileDialog::getOpenFileNames(this, tr("Open Ruby source File"),
													dirText,
													tr("Ruby Files(*.rb);;All Files(*.*)"));
	if( lst.isEmpty() ) return;
	foreach(const QString &fullPath, lst)
		loadFile(fullPath);
}
void MainWindow::replyFinished(QNetworkReply* reply)
{
	if( reply->error() == QNetworkReply::NoError ) {
		QTextCodec *codec = QTextCodec::codecForName("UTF-8");
		QString buffer = codec->toUnicode(reply->readAll());
		if( reply->url() == QString(URL_SF_RELEASE) ) {
			QRegExp exp("RuviEdit-(0.\\d{3})-win\\.zip");
			if( exp.indexIn(buffer) ) {
				m_latestVersion = exp.capturedTexts()[1];
				m_startPage->addHtml(tr("<p>the latest version is <b>'%1'</b>.<br>\n").arg(m_latestVersion));
				int r = m_latestVersion.compare(QString(VERSION_STR).left(5));
				if( !r )
					m_startPage->addHtml(tr("<p>you are using the latest version of RuviEdit.\n"));
				else if( r > 0 ) {
					m_startPage->addHtml(tr("<p>The newer version of RuviEdit is available.\n"));
					m_startPage->addHtml(tr("<br>Could you download the latest version of RuviEdit "
										"from <a href=\"http://sourceforge.jp/projects/ruviedit/releases/\">SourceForge.JP</a>\n"));
				} else
					m_startPage->addHtml(tr("<p>Wow! you are using a future version of RuviEdit.\n"));
#if 0
				m_startPage->addHtml(tr("the latest version is <b>'%1'</b>.<br>\n").arg(exp.capturedTexts()[0]));
				m_startPage->addHtml(tr("Could you download the latest version of RuviEdit "
										"from <a href=\"http://sourceforge.jp/projects/ruviedit/releases/\">SourceForge.JP</a>\n"));
#endif
				m_startPage->addText("\n");
				QRegExp exp2("/projects/ruviedit/releases/\\d+/note");
				if( exp2.indexIn(buffer) ) {
					m_noteURL = "http://sourceforge.jp" + exp2.capturedTexts()[0];
					m_changelogURL = m_noteURL.left(m_noteURL.size() - 4) + "changelog";
					m_networkAccessManager->get(QNetworkRequest(QUrl(m_noteURL)));
				}
			}
		} else if( reply->url() == m_noteURL || reply->url() == m_changelogURL ) {
			QRegExp exp("<h2 class=\"titlebar\">");
			int ix = exp.indexIn(buffer);
			if( ix >= 0 ) {
				ix = buffer.indexOf("<p>", ix);
				if( ix >= 0 ) {
					int ix2 = buffer.indexOf("</p>", ix);
					if( ix2 >= 0 ) {
						m_startPage->addText("\n");
						QString text = buffer.mid(ix, ix2 + 4 - ix);
						if( reply->url() == m_noteURL )
							m_startPage->addHtml(tr("<p><b>%1 Release Note:</b><br>\n").arg(m_latestVersion));
						else
							m_startPage->addHtml(tr("<p><b>%1 Change Log:</b><br>\n").arg(m_latestVersion));
						m_startPage->addHtml("<p>" + text);
						m_startPage->addText("\n");
					}
				}
			}
			if( reply->url() == m_noteURL )
				m_networkAccessManager->get(QNetworkRequest(QUrl(m_changelogURL)));
		} else if( reply->url() == m_infoURL ) {
			QRegExp exp("<div>(.+)</div>");
			int ix = exp.indexIn(buffer);
			if( ix >= 0 ) {
				m_startPage->addHtmlStat(tr("%1\n").arg(exp.capturedTexts()[1]));
			}
		}
	} else {
		m_startPage->addText(reply->errorString());
	}
}
void MainWindow::newStartPage()
{
	if( sender() != 0 )
		incCmdStatistics("Action.viewStartPage");
	if( m_startPage == 0 )
		m_startPage = new StartPage2();
	if( m_tabWidget->indexOf(m_startPage) < 0 )
		m_tabWidget->addTab(m_startPage, tr("StartPage"));
	m_tabWidget->setCurrentWidget(m_startPage);
	m_startPage->setFocus();
	m_startPage->clearOutput();
#ifndef	_DEBUG
	m_infoURL = QString("%1?from=%2").arg(URL_INFO).arg(VERSION_STR);
	m_networkAccessManager->get(QNetworkRequest(QUrl(m_infoURL)));
	m_networkAccessManager->get(QNetworkRequest(QUrl(URL_SF_RELEASE)));
#endif
}
void MainWindow::newFile()
{
	if( sender() != 0 )
		incCmdStatistics("Action.FileNew");
	EditView *view = createView();
	QString title = tr("Untitled-%1").arg(++m_docNumber);
	view->setTitle(title);
	m_tabWidget->addTab(view, title);
	m_tabWidget->setCurrentWidget(view);
	m_outlineBar->addView(view);
	view->setFocus();
}
void MainWindow::closeEvent(QCloseEvent *event)
{
	if (maybeSave()) {
		writeSettings();
		QMainWindow::closeEvent(event);
	} else {
		event->ignore();
	}
}
void MainWindow::closeThisDocument()
{
	incCmdStatistics("Action.closeThisDocument");
	QWidget *w = m_tabWidget->currentWidget();
	if( !w ) return;
	if( w->metaObject()->className() == QString("EditView") )
		close((EditView *)w);
	else
		m_tabWidget->removeTab(m_tabWidget->currentIndex());
}
void MainWindow::closeAll()
{
	incCmdStatistics("Action.closeAll");
	for(int i = m_tabWidget->count() - 1; i >= 0; --i) {
		EditView *view = (EditView *)m_tabWidget->widget(i);
		if( view->metaObject()->className() == QString("EditView") )
			close(view);
		else
			m_tabWidget->removeTab(i);
	}
}

void MainWindow::close(EditView *view)
{
	if( !maybeSave(view) )	//	undone: ۑ̏ꍇ͕ۑmF
		return;
	viewFocusOut();
	m_tabWidget->removeTab(m_tabWidget->indexOf(view));
	delete view;
	view = currentEditView();
	if( view != 0 )
		view->setFocus();
}
void MainWindow::tabCloseRequested(int ix)
{
	EditView *view = (EditView *)m_tabWidget->widget(ix);
	if( view == 0 ) return;
	if( view->metaObject()->className() == QString("EditView") )
		close(view);
	else
		m_tabWidget->removeTab(ix);
}

#if 0
void MainWindow::exit()
{
}
#endif
bool MainWindow::maybeSave()
{
	for(int i = 0; i < m_tabWidget->count(); ++i) {
		EditView *view = editView(i);
		if( view != 0 && !maybeSave(view) )
			return false;		//	LZIꂽꍇ
	}
	return true;
}
bool MainWindow::maybeSave(EditView *view)
{
    if (view->modified() && !view->document()->isEmpty()) {
    	m_tabWidget->setCurrentWidget(view);
		QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("ruviEdit"),
                     tr("The '%1' has been modified.\n"
                        "Do you want to save your changes?").arg(view->title()),
                     QMessageBox::Save | QMessageBox::Discard
		     | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
            return save();
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}
bool MainWindow::save()
{
	incCmdStatistics("Action.FileSave");
	EditView *view = currentEditView();
	if( view == 0 ) return false;
	if( view->fullPath().isEmpty() )
		return saveAs();
	else
		return saveFile(view, view->fullPath());
}
bool MainWindow::saveAs()
{
	incCmdStatistics("Action.FileSaveAs");
	EditView *view = currentEditView();
	if( view == 0 ) return false;
	view->cdCurrentDir();		//	I[vĂt@C̃fBNgɈړ
#if 0
	//	OςcO߂̂ QFileDialog ĝ͒fO
	QFileDialog aDlg(this, tr("Save File"), view->title(), view->currentDir());
	aDlg.setAcceptMode(QFileDialog::AcceptSave);
	QLayout *layout = aDlg.layout();
	layout->addWidget(new QCheckBox("test"));
	if( aDlg.exec() != QFileDialog::Accepted ) return false;
	QStringList list = aDlg.selectedFiles();
	if( list.size() != 1 ) return false;
	QString fullPath = list[0];
#else
	QString fullPath = QFileDialog::getSaveFileName(this, tr("Save File"), view->title(),
													tr("Ruby files(*.rb);;All Files(*.*)"));
#endif
	if( fullPath.isEmpty() ) return false;
    view->setFullPath(fullPath);
    m_outlineBar->pathChanged(view);	//	zg EditView oRŌĂ񂾕H
    //	TAB ̃^CgύX
    //	undone	QTabWidget ɈˑĂ̂ŁA
    int ix = m_tabWidget->indexOf(view);
    if( ix >= 0 ) {
    	m_tabWidget->setTabText(ix, view->title());
    	m_tabWidget->setTabToolTip(ix, view->toolTipText());
    }
    //setCurrentFile(fullPath);
	if( !saveFile(view, fullPath) )
		return false;
	addToRecentFileList(fullPath);
	addToRecentDirList(fullPath);
	updateRecentFileActions();
	updateRecentDirActions();
	return true;
}
QTextCodec *toCodec(uchar enc)
{
	cchar *encName = codecName(enc);
	if( encName != 0 ) {
		QTextCodec *codec = QTextCodec::codecForName(encName);
		if( codec != 0 )
			return codec;
	}
	return QTextCodec::codecForLocale();
}
bool MainWindow::saveFile(EditView *view, const QString &fullPath)
{
	QFile file(fullPath);
	if( !file.open(QIODevice::WriteOnly) ) {
		QMessageBox::critical(this, tr("save"),
								tr("failed to save file '%1'").arg(fullPath));
		return false;
	}
	QString text = view->toPlainText();
	//QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QTextCodec *codec = toCodec(view->charEncoding());
	QByteArray ba = codec->fromUnicode(text);
	file.write(ba);
	view->setModified(false);
	return true;
}
void MainWindow::loadFile(const QString &fileNameRaw)
{
	saveCmdStatistics();
	QString fileFullPath(fileNameRaw);
	fileFullPath.replace("\xa5", "/");		//	\ = 0xa5
	QFileInfo fi(fileFullPath);
	if( !fi.exists() ) {
		return;
	}
	QString absFullPath = fi.absoluteFilePath();
	QString name = fi.fileName();		//	hoge/fuga.rb  fuga.rb

	for(int i = 0; i < m_tabWidget->count(); ++i) {
		EditView *view = editView(i);
		if( view != 0 && view->fullPath() == absFullPath ) {
			m_tabWidget->setCurrentIndex(i);
			return;
		}
	}

	EditView *view = createView();
	int ix = m_tabWidget->addTab(view, name);
	view->setFocus();
	view->setFullPath(absFullPath);
	bool rc = loadFile(view, fileNameRaw);
	m_tabWidget->setCurrentWidget(view);
	m_tabWidget->setTabToolTip(ix, view->toolTipText());
	if( !rc )
		return;
	addToRecentFileList(absFullPath);
	addToRecentDirList(absFullPath);
	updateRecentFileActions();
	updateRecentDirActions();
	m_outlineBar->addView(view);
}
bool MainWindow::loadFile(EditView *view, const QString &fileNameRaw)
{
	QString fileFullPath(fileNameRaw);
	fileFullPath.replace("\xa5", "/");		//	\ = 0xa5
	QFile file(fileFullPath);
	if( !file.open(QIODevice::ReadOnly) ) {
		return false;
	}
	m_loading = true;
	QByteArray ba = file.readAll();
	int bom;
	uchar enc = checkCharEncoding((cuchar *)ba.data(), (cuchar *)ba.data() + ba.size(), bom);
	QTextCodec *codec = toCodec(enc);
	QString text = codec->toUnicode(ba);
	view->setPlainText(text);
	view->setModified(false, /*forced=*/true);
	view->setCharEncoding(enc);
	view->setModifiedAfterCompile(false);
	closeNullDoc();
	m_loading = false;
	return true;
}
void MainWindow::closeNullDoc()
{
	for(int ix = m_tabWidget->count() - 1; ix >= 0; --ix) {
		EditView *view = editView(ix);
		if( view != 0 && view->fullPath().isEmpty() && view->document()->isEmpty() ) {
			close(view);
		}
	}
}
void MainWindow::dragEnterEvent ( QDragEnterEvent * event )
{
#if 1
	if( event->mimeData()->hasUrls() ) {
		//qDebug() << "has text/uri-list format";
		event->acceptProposedAction();
	}
#else
	//qDebug() << "MainWindow::dragEnterEvent";
	if( event->mimeData()->hasFormat("text/uri-list") ) {
		//qDebug() << "has text/uri-list format";
		event->acceptProposedAction();
	}
#endif
}
void MainWindow::dropEvent ( QDropEvent * event )
{
	//qDebug() << "MainWindow::dropEvent";
	QList<QUrl> fileList = event->mimeData()->urls();
	foreach(QUrl url, fileList) {
		QString fileName = QDir::toNativeSeparators(url.toLocalFile());
		//qDebug() << fileName;
		loadFile(fileName);
	}
}
//
void MainWindow::onReadyRead()
{
	QByteArray ba = m_process->readAllStandardOutput();
	int bom;
	uchar enc = checkCharEncoding((cuchar *)ba.data(), (cuchar *)ba.data() + ba.size(), bom);
	QTextCodec *codec = toCodec(enc);
	//QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QString text = codec->toUnicode(ba);
	doOutput(text);
}
void MainWindow::onReadyReadError()
{
	QByteArray ba = m_process->readAllStandardError();
	if( ba.isEmpty() ) return;
#if 0
	QTextCodec *codecUTF8 = QTextCodec::codecForName("UTF-8");
	QTextCodec *codec = QTextCodec::codecForName(codecUTF8->fromUnicode(m_settings->m_errorEncoding));
	if( codec == 0 )
		codec = QTextCodec::codecForName("UTF-8");
#else
#if 1	//	codecs/qjcodec4.dll ƃNbVꍇH
	int bom;
	uchar enc = checkCharEncoding((cuchar *)ba.data(), (cuchar *)ba.data() + ba.size(), bom);
	QTextCodec *codec = toCodec(enc);
#else
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
#endif
#endif
	QString text = codec->toUnicode(ba);
	doOutputError(text);
}
void MainWindow::run()
{
	incCmdStatistics("Action.RubyRun");
	callRuby(true);
}
void MainWindow::stop()
{
	incCmdStatistics("Action.RubyStop");
	if( m_process->state() != QProcess::NotRunning ) {
		m_toTerminate = true;
		m_process->kill();
		statusBar()->showMessage(tr("terminated.."));
	}
}
void MainWindow::checkSyntax()
{
	incCmdStatistics("Action.RubyCheckSyntax");
	if( m_process->state() == QProcess::NotRunning )
		callRuby(false);
}
void MainWindow::jumpToLine(int lineNum, QString path)
{
	if( !path.isEmpty() )
		loadFile(path);
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->jumpToLine(lineNum);
	view->setFocus(Qt::OtherFocusReason);
}
//	̃G[sɈړ
void MainWindow::jumpToErrorLine()
{
	m_outputError->jumpToNextErrorLine();
#if 0
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->jumpToErrorLine();
#endif
}
void MainWindow::jumpLineNumber()
{
	EditView *view = currentEditView();
	if( view == 0 ) return;
	incCmdStatistics("Action.JumpLineNumber");
	JumpLineNumberDlg aDlg;
	aDlg.ui.lineNumber->setChecked(true);
	QTextCursor cur = view->textCursor();
	aDlg.ui.lineNumberLE->setText(QString::number(cur.blockNumber() + 1));
	aDlg.ui.lineNumberLE->selectAll();
	if( QDialog::Accepted == aDlg.exec() ) {
		int lineNum = aDlg.ui.lineNumberLE->text().toInt();
		if( aDlg.ui.beginOfDoc->isChecked() )
			lineNum = 1;
		else if( aDlg.ui.endOfDoc->isChecked() )
			lineNum = view->document()->lineCount();
		view->jumpToLine(lineNum);
		view->setFocus(Qt::OtherFocusReason);
	}
}
void MainWindow::gotoMatchedParen()
{
	EditView *view = currentEditView();
	if( view == 0 ) return;
	incCmdStatistics("Action.gotoMatchParen");
	view->gotoMatchedParen();
}
void MainWindow::onDocContentsChanged()
{
	//m_docModified = true;
}
void MainWindow::onTimer()
{
	EditView *view = currentEditView();
	if( view == 0 ) return;
	if( view->modifiedAfterCompile() )
		callRuby(false);
}

void MainWindow::callRuby(bool bRun)
{
	if( m_process->state() != QProcess::NotRunning ) {
		stop();
		return;
	}
#if 0
#if 0
	QStringList e = m_process->environment();
	e.size();
#else
	QProcessEnvironment pe = m_process->processEnvironment();
	//QStringList keys = pe.keys();
	//keys.size();
	//QString pePath = pe.value("path");
	pe.insert("path", "c:/ruby/193/bin");
	m_process->setProcessEnvironment(pe);		//	Ȃ 12/04/17
#endif
#endif

	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->setModifiedAfterCompile(false);
	m_toTerminate = false;
	m_output->document()->clear();
	m_outputError->setClearFlag();
	const QString text = view->toPlainText();
	if( text.isEmpty() ) {
		if( !view->fullPath().isEmpty() && view->modified() )
			saveFile(view, view->fullPath());
		if( !bRun || m_argText->text().isEmpty() )	//	@`FbN ܂ 
			return;
		m_fileName.clear();
	} else {
		//	hLgtpXĂȂꍇ́Ae|t@Cɕۑ
		if( ///!bRun ||		//	@`FbN̏ꍇ͌t@C㏑ۑsȂ
			view->fullPath().isEmpty() )
		{
			m_tempFile = new QTemporaryFile;
		    if( !m_tempFile->open() ) {
				return;
			}
			m_fileName = m_tempFile->fileName();
			m_outputError->setCurrentFileName(m_fileName);
			QTextCodec *codec = QTextCodec::codecForName("UTF-8");
			QByteArray ba = codec->fromUnicode(text);
			m_tempFile->write(ba);
			m_tempFile->close();
		} else {
			m_fileName = view->fullPath();
			m_outputError->setCurrentFileName(QString());
			//	undone: ۑ`FbN
			saveFile(view, m_fileName);
			///if( bRun )
				view->setModified(false);
			view->cdCurrentDir();
		}
	}

	QStringList argList;
	if( !bRun )
		argList << "-c";
	if( !m_fileName.isEmpty() )
		argList << m_fileName;
	if( bRun && !m_argText->text().isEmpty() )
		argList << m_argText->text().split(" ");
	m_running = bRun;
	emit startRuby(argList);

	QProcess::ProcessError err = m_process->error();
	if( err == QProcess::FailedToStart ) {
		doOutputError(tr("can't start Ruby.\n"));
		return;
	}
	if( bRun )
		statusBar()->showMessage(tr("running..."));
}
void MainWindow::onFinished()
{
	m_running = false;
	delete m_tempFile;
	if( m_outputError->clearFlag() ) {		//	o̓NA܂xĂꍇ
		m_outputError->document()->clear();
		m_outputError->setClearFlag(false);
	}
	//m_outputError->appendText("syntax checking finished.\n");
	parseSyntaxError();
	m_tempFile = 0;
	statusBar()->showMessage(!m_toTerminate ? tr("finished.") : tr("terminated."));
}
void MainWindow::parseSyntaxError()
{
	EditView *view = currentEditView();
	if( view == 0 ) return;
	QString fullPath = view->fullPath();
	QList<int> errLineNums;
	int lineNum = 1;
	QRegExp exp(":\\d+:");
	QTextDocument *doc = m_outputError->document();
	QTextBlock block = doc->begin();
	while( block.isValid() ) {
		QString text = block.text();
		int ix;
		if( (ix = exp.indexIn(text)) >= 0 &&
			text.left(ix) == fullPath )
		{
			errLineNums.push_back(text.mid(ix + 1, exp.matchedLength() - 2).toInt());
		}
		++lineNum;
		block = block.next();
	}
	view->setSyntaxErrorLineNums(errLineNums);
#if 0
	//if( !errLineNums.isEmpty() ) {
		EditView *view = (EditView *)m_tabWidget->currentWidget();
		if( view != 0 ) {
			view->setSyntaxErrorLineNums(errLineNums);
			//QTextDocument *doc = view->document();
			//const int length = doc->toPlainText().length();
			//doc->contentsChange(0, length, length);
		}
	//}
#endif
}
void MainWindow::onModificationChanged ( bool changed )
{
	if( m_loading ) return;
	EditView *view = qobject_cast<EditView *>(sender());
	int ix = m_tabWidget->indexOf(view);
	if( ix < 0 ) return;
	QString title = m_tabWidget->tabText(ix);
	if( changed && title.right(2) != " *"
		&& view->fullPath().isEmpty() )		//	t肪ꂵ̂ŁAt@CĂ\[Xɂ * tȂ
	{
		title += " *";
	} else if( !changed && title.right(2) == " *" )
		title = title.left(title.length() - 2);
	else
		return;
	m_tabWidget->setTabText(ix, title);
}
void MainWindow::undo()
{
	incCmdStatistics("Action.EditEndo");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->undo();
}
void MainWindow::undoAvailable(bool b)
{
	m_undoAct->setEnabled(b);
}
void MainWindow::redo()
{
	incCmdStatistics("Action.EditRedo");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->redo();
}
void MainWindow::redoAvailable(bool b)
{
	m_redoAct->setEnabled(b);
}
void MainWindow::cut()
{
	incCmdStatistics("Action.EditCut");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->cut();
}
void MainWindow::copy()
{
	incCmdStatistics("Action.EditCopy");
#if 1
	QWidget *w = QApplication::focusWidget();
	if( w == 0 ) return;
	if( w->inherits("QTextEdit") )
		qobject_cast<QTextEdit *>(w)->copy();
#else
	EditView *view = (EditView *)m_tabWidget->currentWidget();
	if( view == 0 ) return;
	view->copy();
#endif
}
void MainWindow::paste()
{
	incCmdStatistics("Action.EditPaste");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->paste();
}
void MainWindow::selectAll()
{
	incCmdStatistics("Action.selectAll");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->selectAll();
}
void MainWindow::openLineAbove()
{
	incCmdStatistics("Action.openLineAbove");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->openLineAbove();
}
void MainWindow::openLineBelow()
{
	incCmdStatistics("Action.openLineBelow");
	EditView *view = currentEditView();
	if( view == 0 ) return; view->openLineBelow();
}
void MainWindow::unIndent()
{
	incCmdStatistics("Action.unIndent");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->shiftLeft();
}
void MainWindow::enComment()
{
	incCmdStatistics("Action.enComment");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->enComment();
}
void MainWindow::keywordCompletion()
{
	incCmdStatistics("Action.keywordCompletion");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->keywordCompletion();
}
void MainWindow::completion()
{
	incCmdStatistics("Action.completion");
	EditView *view = currentEditView();
	if( view == 0 ) return;
	view->completion();
}
void MainWindow::doSettings()
{
	incCmdStatistics("Action.doSettings");
	SettingsDlg stgDlg(m_settings, this);
	connect(&stgDlg, SIGNAL(apply(SettingsDlg *)), this, SLOT(applySettings(SettingsDlg *)));
	if( QDialog::Accepted == stgDlg.exec() ) {
		applySettings(&stgDlg);
	}
#if 0
	QDialog aDlg;
	aDlg.exec();
	QMessageBox::information(this, "Settings", "");
#endif
}
void MainWindow::applySettings(SettingsDlg *stgDlg)
{
	m_viewLineNumberAct->setChecked(m_settings->m_lineNumber = stgDlg->lineNumber());
	m_settings->m_softTab = stgDlg->softTab();
	m_settings->m_tabWidth = stgDlg->tabWidth();
#if 0
	m_settings->m_fileSystemRootPath = stgDlg->fileSystemRootPath();
	QFileSystemModel *model = (QFileSystemModel *)m_fileSystemView->model();
	model->setRootPath(m_settings->m_fileSystemRootPath);
#endif
	//m_settings->m_errorEncoding = stgDlg->errorEncoding();
	QFont font(m_settings->m_fontFamily = stgDlg->fontFamily(),
				m_settings->m_fontSize = stgDlg->fontSize());
	for(int ix = 0; ix < m_tabWidget->count(); ++ix) {
		EditView *view = editView(ix);
		if( view == 0 ) continue;
		view->setFont(font);
		//view->updateLeftMarginSize();
		view->onSettingsChanged();
	}
	if( m_settings->m_userKeywordFileName != stgDlg->userKeywordFileName() ) {
		m_settings->m_userKeywordFileName = stgDlg->userKeywordFileName();
		m_settings->setupUserKeywordHash();
	}
	m_settings->writeSettings();
}
void MainWindow::nextTabDoc()
{
	incCmdStatistics("Action.nextTabDoc");
	if( m_tabWidget->count() <= 1 ) return;
	int ix = m_tabWidget->currentIndex();
	if( ++ix == m_tabWidget->count() )
		ix = 0;
	m_tabWidget->setCurrentIndex(ix);
}
void MainWindow::prevTabDoc()
{
	incCmdStatistics("Action.prevTabDoc");
	if( m_tabWidget->count() <= 1 ) return;
	int ix = m_tabWidget->currentIndex();
	if( --ix < 0 )
		ix = m_tabWidget->count() - 1;
	m_tabWidget->setCurrentIndex(ix);
}
void MainWindow::previousDoc()
{
	incCmdStatistics("Action.previousDoc");
	if( !m_previousFilePath.isEmpty() ) {
		loadFile(m_previousFilePath);		//	current, previous ̌ onTabChanged ōs
	} else
		selectTabByTitle(m_previousFileTitle);
}
//	w^Cg̃^uI
void MainWindow::selectTabByTitle(const QString &title)
{
	for(int i = 0; i < m_tabWidget->count(); ++i) {
		EditView *view = editView(i);
		if( view != 0 && view->title() == title ) {
			m_tabWidget->setCurrentIndex(i);
			return;
		}
	}
}
void MainWindow::outlineBar()
{
	incCmdStatistics("Action.outlineBar");
	QWidget *fw = QWidget::focusWidget();
	if( fw == m_outlineBar ) {
		setFocusCurrentView();
	} else {
		m_outlineBar->parentWidget()->show();
		m_outlineBar->parentWidget()->raise();
		m_outlineBar->setFocus();
	}
}
void MainWindow::fileSystem()
{
	incCmdStatistics("Action.fileSystem");
	QWidget *fw = QWidget::focusWidget();
	if( fw == m_fileSystemView ) {
		setFocusCurrentView();
	} else {
		m_fileSystemView->parentWidget()->show();
		m_fileSystemView->parentWidget()->raise();
		m_fileSystemView->setFocus();
	}
}
void MainWindow::replace()
{
	EditView *view = currentEditView();
	if( !view ) return;
#if 1
	if( m_replaceDlg == 0 ) {
		m_replaceDlg = new ReplaceDlg(view, settings());
		connect(m_replaceDlg, SIGNAL(undo()), this, SLOT(undo()));
		connect(m_replaceDlg, SIGNAL(redo()), this, SLOT(redo()));
		connect(m_replaceDlg, SIGNAL(nextDoc()), this, SLOT(nextTabDoc()));
		connect(m_replaceDlg, SIGNAL(showMessage(const QString &)), this, SLOT(showMessage(const QString &)));
	}
	m_replaceDlg->show();
	m_replaceDlg->raise();
#else
	ReplaceDlg aDlg(view, settings());
	connect(&aDlg, SIGNAL(showMessage(const QString &)), statusBar(), SLOT(showMessage(const QString &)));
	aDlg.exec();
#endif
}
void MainWindow::findWordAtCursor()
{
	incCmdStatistics("Action.findWordAtCursor");
	EditView *view = currentEditView();
	if( !view ) return;
	QTextCursor cur = view->textCursor();
	if( !cur.hasSelection() ) {
		cur.movePosition(QTextCursor::StartOfWord);
		cur.movePosition(QTextCursor::EndOfWord, QTextCursor::KeepAnchor);
		if( !cur.hasSelection() ) return;
	}
	QString findString = cur.selectedText();
	settings()->addFindString(findString);
	view->find(findString);
}
void MainWindow::findNext()
{
	incCmdStatistics("Action.findNext");
	EditView *view = currentEditView();
	if( !view ) return;
	QString text = m_settings->lastFindString();
	if( !text.isEmpty() )
		view->doFind(text, /*backward=*/false);
}
void MainWindow::findPrev()
{
	incCmdStatistics("Action.findPrev");
	EditView *view = currentEditView();
	if( !view ) return;
	QString text = m_settings->lastFindString();
	if( !text.isEmpty() )
		view->doFind(text, /*backward=*/true);
}
int getToken(const QString &text, int &ix, QString &token, bool &, char = 0);
void MainWindow::tagJump()
{
	incCmdStatistics("Action.tagJump");
	EditView *view = currentEditView();
	if( !view ) return;
	QString blockText = view->textCursor().block().text();
	QString token;
	int ix = 0;
	bool inBrace = false;
	getToken(blockText, ix, token, inBrace);
	if( token == "require" ) {
		getToken(blockText, ix, token, inBrace);
		if( token[0] == QChar('\'') || token[0] == QChar('\"') ) {
			QString fileName = token.mid(1, token.length() - 2);
			loadFile(fileName);
		}
	}
}
void MainWindow::viewLineNumber(bool b)
{
	m_settings->m_lineNumber = b;
	m_settings->writeSettings();
	for(int ix = 0; ix < m_tabWidget->count(); ++ix) {
		EditView *view = editView(ix);
		if( view != 0 )
			view->onSettingsChanged();
	}
}
void MainWindow::help()
{
	incCmdStatistics("Action.help");
	QDesktopServices::openUrl(QUrl("http://vivi.dyndns.org/RuviEdit/howToUse.php?from=RuviEdit"));
}
void MainWindow::sourceCode()
{
	incCmdStatistics("Action.sourceCode");
	QDesktopServices::openUrl(QUrl("http://sourceforge.jp/projects/ruviedit/svn/view/"));
}
struct StatItem
{
	StatItem(const QString &key, uint count)
		: m_key(key), m_count(count)
		{}
public:
	QString	m_key;
	uint	m_count;
};
bool notLessStatItem(const StatItem &lhs, const StatItem &rhs)
{
	return lhs.m_count > rhs.m_count;
}
void MainWindow::cmdStatistics()
{
	incCmdStatistics("Action.cmdStatistics");
	if( m_tabWidget->indexOf(m_startPage) < 0 )
		m_tabWidget->addTab(m_startPage, tr("StartPage"));
	m_startPage->clearStatOutput();
	uint sum = 0;
	QList<StatItem> lst;
	QHash<QString, uint>::const_iterator itr = g_cmdStatistics.begin();
	while( itr != g_cmdStatistics.end() ) {
		sum += itr.value();
		lst << StatItem(itr.key(), itr.value());
		++itr;
	}
	qSort(lst.begin(), lst.end(), notLessStatItem);
	QString text = "<table>\n";
	//m_startPage->addHtmlStat("<table>\n");
	foreach(const StatItem &item, lst) {
		text += QString("<tr><td>%1</td><td>%2</td><td>(%3%)</td></tr>\n")
					.arg(item.m_key, 30)
					.arg(item.m_count)
					.arg(item.m_count * 100 / (double)sum);
#if 0
		m_startPage->addHtmlStat(QString("<tr><td>%1</td><td>%2</td><td>(%3%)</td></tr>\n")
					.arg(item.m_key, 30)
					.arg(item.m_count)
					.arg(item.m_count * 100 / (double)sum));
#endif
	}
	text += "</table>\n";
	m_startPage->addHtmlStat(text);
	//m_startPage->addHtmlStat("</table>\n");
#if 0
	QHash<QString, uint>::const_iterator itr = g_cmdStatistics.begin();
	while( itr != g_cmdStatistics.end() ) {
		doOutput(QString("%1 => %2\n").arg(itr.key()).arg(itr.value()));
		++itr;
	}
#endif
}
void MainWindow::about()
{
	incCmdStatistics("Action.about");
	QMessageBox msgBox;
	msgBox.setIconPixmap(QPixmap(":MainWindow/Resources/ayabu.png"));
	msgBox.setText(tr("<div align=center><b>RuviEdit</b> version %1</div>").arg(VERSION_STR));
#ifdef	Q_CC_MSVC
	const QString ayabu((const QChar *)L"F ");
#else
	const QString ayabu("momoshiki tsubaki");
#endif
	msgBox.setInformativeText(QString("<div align=center>Copyright (C) 2012 by N.Tsuda<br>"
								"mailto:ntsuda@master.email.ne.jp<br>"
								"<a href=\"http://vivi.dyndns.org/?from=qvi%1\">http://vivi.dyndns.org/</a><br><br>"
								"Powered by <a href=\"http://qt.nokia.com/\">Qt</a>"
								"<p>illustrated by <a href=\"http://www.pixiv.net/member.php?id=220294\">%2</a>"
								"<p>icons by <a href=\"http://www.visualpharm.com/\">VisualPharm</a></div>")
								.arg(VERSION_STR).arg(ayabu));
	msgBox.exec();
}
