#ifndef EDITVIEW_H
#define EDITVIEW_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	EditView NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/


#include <QTextEdit>
//#include <QPlainTextEdit>

class RubySyntaxHighliter;
struct Settings;

class EditView : public QTextEdit
{
	Q_OBJECT

public:
	EditView(Settings *, QWidget *parent = 0);
	~EditView();

public:
	const QString	&title() const { return m_title; }
	const QString	&fullPath() const { return m_fullPath; }
	bool	isRunning() const { return m_running; }
	bool	modified() const;
	bool	modifiedAfterCompile() const { return m_modifiedAfterCompile; }
	QString	currentDir() const;
	void	cdCurrentDir() const;
	bool	isSyntaxErrorLine(int) const;
	const	Settings *settings() const { return m_settings; }
	Settings *settings() { return m_settings; }
	uchar	charEncoding() const { return m_charEncoding; }
	QString	toolTipText() const;
	bool	isMatch(const QString &);	//	I𕶎 or J[\ʒuɃ}b`Ă邩H
	//QString	hereDocumentIdend() const { return m_hereDocumentIdent; }

public:
	void	setTitle(const QString &title) { m_title = title; }
	void	setFullPath(const QString &fullPath);
	void	setModified(bool b, bool forced = false);
	void	setRunning(bool b) { m_running = b; }
	void	setModifiedAfterCompile(bool b) { m_modifiedAfterCompile = b; }
	void	setCharEncoding(uchar enc);		//{ m_charEncoding = enc; }
	void	clearSelection();
	void	setSyntaxErrorLineNums(const QList<int> &);
	void	setRegexpFormat(QTextCharFormat *p) { m_regexpFormat = p; }
	void	setQuoteFormat(QTextCharFormat *p) { m_quoteFormat = p; }
	void	updateLeftMarginSize();
	void	onSettingsChanged();
	void	jumpToErrorLine();
	void	gotoMatchedParen();
	void	shiftRight();		//	IsEVtgiCfgj
	void	shiftLeft();		//	IsVtgitCfgj
	void	openLineAbove();	//	J[\sOɍs}
	void	openLineBelow();	//	J[\sɍs}
	void	enComment();		//	I͈͂Rg
	void	keywordCompletion();	//	L[[h⊮
	void	completion();		//	⊮
	bool	find(const QString &, QTextDocument::FindFlags options = 0);
	bool	doFind(const QString &, bool=false, bool=false);
	bool	doFindSub(const QString &, bool=false);
	//	K\AIvV Settings Q
	bool	findRegexp(const QString &, bool=false);
	//void	setHereDocumentIdent(const QString &t) { m_hereDocumentIdent = t; }
	void	doOutput2(const QString &text)
	{ emit doOutput(text); }

public slots:
	void	onContentsChanged();
	void	onModificationChanged ( bool changed );
	void	jumpToLine(int);
	//void	paste();

protected:
	QString	autoIndentText(QTextCursor);
	void	drawLeftMargin();
	int		leftMarginWidth();
	void	completion(bool keyword);
	void	setupCompletionCandidates(QStringList &, const QString &);
	//QString	getToken(int &position);
	bool	revAutoIndent(const QString &);
	void	scrollCurToTop();	//	\[ʍŏ㕔ɂȂ悤XN[
	bool	atJustBehindRegexp(QTextCursor);

protected:
	void	keyPressEvent ( QKeyEvent * e );
	void	paintEvent(QPaintEvent * event);
	void	resizeEvent(QResizeEvent *event);
	void	wheelEvent(QWheelEvent * event);
	void	mousePressEvent ( QMouseEvent * event );
	void	mouseDoubleClickEvent ( QMouseEvent * event );
	bool	eventFilter(QObject *obj, QEvent *event);
	void	focusOutEvent ( QFocusEvent * e );
	void	focusInEvent ( QFocusEvent * e );

signals:
	void	modificationChanged ( bool changed );
	void	fontSizeChanged(int);
	void	encodingChanged();
	void	focusIn();
	void	focusOut();
	void	showMessage(const QString &);
	void	doOutput(const QString &);
	void	toClose(EditView *);		//	N[Y钼OɃR[
	void	contentsChanged();

private:
	Settings	*m_settings;
    QTextCharFormat	*m_regexpFormat;
    QTextCharFormat	*m_quoteFormat;
	//bool	m_modified;					//	ҏWۑ
	bool	m_running;
	bool	m_modifiedAfterCompile;		//	s or @`FbNɕҏWꂽ
	char	m_charEncoding;				//	R[h
	int		m_revAIPosition;			//	tCfgʒuiend Ȃǂ̒j
	QString	m_orgIndentText;
	QString	m_title;
	QString	m_fullPath;
	RubySyntaxHighliter	*m_rubySyntaxHighliter;
	//QString	m_hereDocumentIdent;		//	here document ʎq
	QWidget		*m_lmWidget;
	//QList<int>	m_syntaxErrorLineNums;
	int		m_errorLineNum;
	QHash<int, bool>	m_syntaxErrorHashMap;
};

#endif // EDITVIEW_H
