/*
 * Copyright (C) 2006-2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.model;

import java.util.Arrays;

import minicmds.common.AppException;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;


/**
 * NX
 * 
 * @author hiro
 */
public class ExcelToTextArgument {

	private static final String HELP_CHAR = "h";

	private static final String HELP_LONG = "help";

	private static final String LINE_NUMBER_CHAR = "n";

	private static final String LINE_NUMBER_LONG = "line-number";

	private static final String VERSION_CHAR = "V";

	private static final String VERSION_LONG = "version";

	/**
	 * R}hC
	 */
	private CommandLine cmd = null;

	/**
	 * R}hCp[T[
	 */
	private CommandLineParser parser = new PosixParser();

	/**
	 * IvVW
	 */
	private Options options = new Options();

	/**
	 * ̓t@Cz
	 */
	private String[] inFileArray;

	/**
	 * RXgN^
	 */
	public ExcelToTextArgument() {

		Option helpFlag = new Option(HELP_CHAR, HELP_LONG, false, "gp@\܂B");

		Option lineNumberFlag = new Option(LINE_NUMBER_CHAR, LINE_NUMBER_LONG,
				false, "eo͍s̑OɁA̓t@Cɂsԍ\܂B");

		Option versionFlag = new Option(VERSION_CHAR, VERSION_LONG, false,
				"o[Wԍ\܂B");

		options.addOption(helpFlag);
		options.addOption(lineNumberFlag);
		options.addOption(versionFlag);
	}

	/**
	 * gp@̏o
	 */
	public void printUsage(String programName) {
		HelpFormatter help = new HelpFormatter();
		help.printHelp(programName + " [IvV] t@C ...", "IvV", options,
				"", false);
		System.out.println("K{");
		System.out.println(" t@C");
	}

	/**
	 * R}hC̈ݒ肷
	 * 
	 * @throws AppException
	 */
	public void set(String[] args) throws AppException {

		// ̉
		try {
			cmd = parser.parse(options, args);
		} catch (ParseException e) {
			throw new AppException("=" + Arrays.toString(args), e);
		}

		// pX̃ChJ[hWJ
		// javȁꍇAWindowsłIɃChJ[hWJĂ̂ŁAȂB
		inFileArray = cmd.getArgs();
	}

	/**
	 * @return inFileArray ߂܂B
	 */
	public String[] getInFileArray() {
		return (String[]) inFileArray.clone();
	}

	/**
	 * @return helpFlag ߂܂B
	 */
	public boolean isHelpFlag() {
		return cmd.hasOption(HELP_CHAR);
	}

	/**
	 * @return lineNumberFlag ߂܂B
	 */
	public boolean isLineNumberFlag() {
		return cmd.hasOption(LINE_NUMBER_CHAR);
	}

	/**
	 * @return versionFlag ߂܂B
	 */
	public boolean isVersionFlag() {
		return cmd.hasOption(VERSION_CHAR);
	}

}
