/*
 * Copyright (C) 2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.diff;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class Main {

	class MyFilenameFilter implements FilenameFilter {
		private static final String EXCLUDE_PATTERN = ".svn";

		public boolean accept(File dir, String name) {
			if (name.equals(EXCLUDE_PATTERN)) {
				return false;
			} else {
				return true;
			}
		}
	}

	private MyFilenameFilter filter = new MyFilenameFilter();

	/**
	 * @param args
	 * @throws IOException
	 * @throws IOException
	 */
	public static void main(String[] args) {
		Main main = new Main();
		main.run(args);
	}

	private void run(String[] args) {
		Argument arg = new Argument();
		arg.parse(args);

		// gp@o
		if (arg.isHelpFlag()) {
			arg.printUsage();
			return;
		}

		// fBNg/t@CċAIɏ
		procDirLoop(arg.getBefore(), arg.getAfter(), 0);
	}

	private void procDirLoop(String path1, String path2, int nest) {

		File file1 = new File(path1);
		File file2 = new File(path2);
		if (file1.isDirectory() && file2.isDirectory()) {
			String[] list1 = file1.list(filter);
			String[] list2 = file2.list(filter);

			// TODO \[g

			int count1 = 0;
			int count2 = 0;
			while (count1 < list1.length || count2 < list2.length) {
				int cmp = 0;

				// t@C̒ǉ/폜Ȃǂ𔻒
				if (count1 >= list1.length) {
					cmp = 1;
				} else if (count2 >= list2.length) {
					cmp = -1;
				} else {
					cmp = list1[count1].compareTo(list2[count2]);
				}

				// t@C̒ǉ/폜Ȃǂɏ]ď
				if (cmp < 0) {
					procOnePath(path1, list1[count1], cmp);
					count1++;
				} else if (cmp > 0) {
					procOnePath(path2, list2[count2], cmp);
					count2++;
				} else {
					// g̃t@C
					procDirLoop(path1 + "/" + list1[count1], path2 + "/" + list2[count2], nest + 1);
					count1++;
					count2++;
				}
			}
		} else {
			// g̃t@C
			procFilePair(path1, path2, nest);
		}
	}

	private void procOnePath(String dir, String name, int cmp) {
		File file = new File(dir + "/" + name);

		if (file.isDirectory()) {
			String list[] = file.list(filter);
			for (String str : list) {
				procOnePath(dir + "/" + name, str, cmp);
			}
		} else {
			// t@Cǂݍ
			Document doc;
			try {
				doc = read(dir + "/" + name);
			} catch (IOException e) {
				return;
			}

			// o
			List<Difference> diffList = new ArrayList<Difference>();
			if (cmp < 0) {
				diffList.add(new Difference(0, doc.getArray().length - 1, 0, -1));
			} else {
				diffList.add(new Difference(0, -1, 0, doc.getArray().length - 1));
			}

			// o
			System.out.println("Only in " + dir + ": " + name);
			DiffWriter twriter = new DiffWriter();
			twriter.printDiffList(System.out, doc, doc, diffList);
		}
	}

	/**
	 * 1g̃t@C
	 * 
	 * @param beforeName
	 * @param afterName
	 * @param nest
	 *            1ȏ̏ꍇAo͂̐擪Ƀt@Co͂B
	 */
	private void procFilePair(String beforeName, String afterName, int nest) {
		File file1 = new File(beforeName);
		File file2 = new File(afterName);

		if (file1.isDirectory()) {
			beforeName += "/" + file2.getName();
		}
		if (file2.isDirectory()) {
			afterName += "/" + file1.getName();
		}

		// t@Cǂݍ
		Document before;
		Document after;
		try {
			before = read(beforeName);
			after = read(afterName);
		} catch (IOException e) {
			return;
		}

		// o
		Diff diff = new Diff(before.getArray(), after.getArray());
		List<Difference> diffList = callDiff(diff);

		// o
		if (diffList.size() > 0 && nest > 0) {
			System.out.println("diff " + beforeName + " " + afterName);
		}
		DiffWriter twriter = new DiffWriter();
		twriter.printDiffList(System.out, before, after, diffList);
	}

	private Document read(String path) throws IOException {
		Document doc;

		try {
			Reader reader = ReaderFactory.getReader(path);
			doc = reader.read(path);
		} catch (IOException e) {
			System.out.println("t@Cǂݍ݃G[F" + path);
			System.out.println(e.toString());
			throw e;
		}

		return doc;
	}

	@SuppressWarnings("unchecked")
	private List<Difference> callDiff(Diff diff) {
		return diff.diff();
	}

}
